/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.core.quests.objectives.misc;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.infernalstudios.questlog.core.quests.objectives.Objective;
import org.infernalstudios.questlog.event.QuestlogEventBus;
import org.infernalstudios.questlog.event.events.QLPlayerEvent;
import org.infernalstudios.questlog.util.JsonUtils;

public class VisitBiomeObjective
extends Objective {
    private final ResourceLocation biome;
    private int ticksUntilCheck = 0;

    public VisitBiomeObjective(JsonObject definition) {
        super(definition);
        this.biome = new ResourceLocation(JsonUtils.getString(definition, "biome"));
    }

    @Override
    public void registerEventListeners(QuestlogEventBus bus) {
        super.registerEventListeners(bus);
        bus.addListener(this::onPlayerMove);
    }

    private void onPlayerMove(QLPlayerEvent.Tick event) {
        ServerPlayer player;
        if (this.isCompleted() || this.getParent() == null) {
            return;
        }
        Player player2 = event.player;
        if (player2 instanceof ServerPlayer && this.getParent().manager.player.equals((Object)(player = (ServerPlayer)player2)) && --this.ticksUntilCheck <= 0) {
            if (((ResourceKey)player.m_284548_().m_204166_(player.m_20183_()).m_203543_().orElseThrow()).m_135782_().equals((Object)this.biome)) {
                this.setUnits(this.getUnits() + 1);
            }
            this.ticksUntilCheck = 20;
        }
    }
}

