/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.core.quests.objectives.misc;

import com.google.gson.JsonObject;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import org.infernalstudios.questlog.core.quests.objectives.Objective;
import org.infernalstudios.questlog.event.QuestlogEventBus;
import org.infernalstudios.questlog.event.events.QLEntityEvent;
import org.infernalstudios.questlog.util.CachedValue;
import org.infernalstudios.questlog.util.JsonUtils;

public class EffectAddedObjective
extends Objective {
    private final CachedValue<MobEffect> effect = new CachedValue<MobEffect>(() -> (MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(JsonUtils.getString(definition, "effect"))));

    public EffectAddedObjective(JsonObject definition) {
        super(definition);
    }

    @Override
    public void registerEventListeners(QuestlogEventBus bus) {
        super.registerEventListeners(bus);
        bus.addListener(this::onEffectAdded);
    }

    private void onEffectAdded(QLEntityEvent.EffectAdded event) {
        ServerPlayer player;
        if (this.isCompleted() || this.getParent() == null) {
            return;
        }
        LivingEntity livingEntity = event.entity;
        if (livingEntity instanceof ServerPlayer && this.getParent().manager.player.equals((Object)(player = (ServerPlayer)livingEntity)) && event.effect.m_19544_().equals(this.effect.get())) {
            this.setUnits(this.getUnits() + 1);
        }
    }
}

