/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.core.quests.objectives;

import com.google.gson.JsonObject;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import org.infernalstudios.questlog.core.quests.Quest;
import org.infernalstudios.questlog.core.quests.display.ObjectiveDisplayData;
import org.infernalstudios.questlog.core.quests.display.WithDisplayData;
import org.infernalstudios.questlog.event.QuestlogEventBus;
import org.infernalstudios.questlog.util.JsonUtils;
import org.infernalstudios.questlog.util.NbtSaveable;

public abstract class Objective
implements NbtSaveable,
WithDisplayData<ObjectiveDisplayData> {
    private final ObjectiveDisplayData display;
    private final int totalUnits;
    @CheckForNull
    private Quest parent;
    private int units;

    public Objective(JsonObject definition) {
        this.totalUnits = JsonUtils.getOrDefault(definition, "total", 1);
        this.units = 0;
        this.display = new ObjectiveDisplayData(JsonUtils.getOrDefault(definition, "display", new JsonObject()));
        this.display.setObjective(this);
    }

    public void registerEventListeners(QuestlogEventBus bus) {
    }

    @Nullable
    public final Quest getParent() {
        return this.parent;
    }

    public final void setParent(@Nullable Quest parent) {
        this.parent = parent;
    }

    public final int getUnits() {
        return this.units;
    }

    public final void setUnits(int units) {
        this.units = Math.min(units, this.totalUnits);
        if (this.getParent() != null) {
            this.getParent().markForUpdate();
        }
    }

    public final int getTotalUnits() {
        return this.totalUnits;
    }

    public final boolean isCompleted() {
        return this.units >= this.totalUnits;
    }

    @Override
    public ObjectiveDisplayData getDisplay() {
        return this.display;
    }

    @Override
    public void writeInitialData(CompoundTag data) {
        data.m_128405_("units", this.units);
    }

    @Override
    public void deserialize(CompoundTag data) {
        this.units = data.m_128451_("units");
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("units", this.units);
        return tag;
    }
}

