/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.core.quests.display;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.infernalstudios.questlog.client.gui.QuestlogGuiSet;
import org.infernalstudios.questlog.core.quests.Quest;
import org.infernalstudios.questlog.core.quests.display.ObjectiveDisplayData;
import org.infernalstudios.questlog.core.quests.display.Palette;
import org.infernalstudios.questlog.core.quests.display.RewardDisplayData;
import org.infernalstudios.questlog.core.quests.display.WithDisplayData;
import org.infernalstudios.questlog.util.JsonUtils;
import org.infernalstudios.questlog.util.texture.Blittable;

public class QuestDisplayData {
    private final Component title;
    private final Component description;
    @Nullable
    private final Blittable icon;
    @Nullable
    private final ResourceLocation completedSound;
    @Nullable
    private final ResourceLocation triggeredSound;
    private final boolean toastOnTrigger;
    private final boolean toastOnComplete;
    private final boolean popup;
    private final boolean hidden;
    private final ResourceLocation bgTexture;
    private final ResourceLocation peripheralTexture;
    private final Component backButtonText;
    private final Component collectButtonText;
    private final Component collectedText;
    private final Component uncollectedText;
    private final Palette palette;
    @Nullable
    private List<ObjectiveDisplayData> objectiveDisplay = null;
    @Nullable
    private List<RewardDisplayData> rewardDisplay = null;

    public QuestDisplayData(JsonObject data) {
        String peripheralLoc;
        String backgroundLoc;
        boolean translatable = JsonUtils.getOrDefault(data, "translatable", false);
        String title = JsonUtils.getString(data, "title");
        String description = JsonUtils.getString(data, "description");
        this.title = translatable ? Component.m_237115_((String)title) : Component.m_237113_((String)title);
        this.description = translatable ? Component.m_237115_((String)description) : Component.m_237113_((String)description);
        this.icon = JsonUtils.getIcon(data, "icon");
        String completedSoundLoc = JsonUtils.getOrDefault(JsonUtils.getOrDefault(data, "sound", new JsonObject()), "completed", (String)null);
        this.completedSound = completedSoundLoc == null ? null : new ResourceLocation(completedSoundLoc);
        String triggeredSoundLoc = JsonUtils.getOrDefault(JsonUtils.getOrDefault(data, "sound", new JsonObject()), "triggered", (String)null);
        this.triggeredSound = triggeredSoundLoc == null ? null : new ResourceLocation(triggeredSoundLoc);
        JsonObject style = JsonUtils.getOrDefault(data, "style", new JsonObject());
        String string = backgroundLoc = style.has("background") ? JsonUtils.getOrDefault(JsonUtils.getOrDefault(style, "background", new JsonObject()), "texture", (String)null) : null;
        if (backgroundLoc == null) {
            backgroundLoc = "questlog:textures/gui/quest_page.png";
        }
        String string2 = peripheralLoc = style.has("peripheral") ? JsonUtils.getOrDefault(JsonUtils.getOrDefault(style, "peripheral", new JsonObject()), "texture", (String)null) : null;
        if (peripheralLoc == null) {
            peripheralLoc = "questlog:textures/gui/quest_peripherals.png";
        }
        this.bgTexture = new ResourceLocation(backgroundLoc);
        this.peripheralTexture = new ResourceLocation(peripheralLoc);
        this.palette = new Palette(JsonUtils.getOrDefault(style, "textColor", "#4C381B"), JsonUtils.getOrDefault(style, "completedTextColor", "#529E52"), JsonUtils.getOrDefault(style, "hoveredTextColor", "#FFFFFF"), JsonUtils.getOrDefault(style, "titleColor", "#4C381B"), JsonUtils.getOrDefault(style, "progressTextColor", "#9E7852"));
        String buttonTextRaw = JsonUtils.getOrDefault(style, "backButtonText", (String)null);
        this.backButtonText = buttonTextRaw == null ? Component.m_237115_((String)"gui.back") : (translatable ? Component.m_237115_((String)buttonTextRaw) : Component.m_237113_((String)buttonTextRaw));
        String backButtonTextRaw = JsonUtils.getOrDefault(style, "collectButtonText", (String)null);
        this.collectButtonText = buttonTextRaw == null ? Component.m_237115_((String)"questlog.reward.collect") : (translatable ? Component.m_237115_((String)backButtonTextRaw) : Component.m_237113_((String)backButtonTextRaw));
        String uncollectedTextRaw = JsonUtils.getOrDefault(style, "uncollectedText", (String)null);
        this.uncollectedText = uncollectedTextRaw == null ? Component.m_237115_((String)"questlog.reward.uncollected") : (translatable ? Component.m_237115_((String)uncollectedTextRaw) : Component.m_237113_((String)uncollectedTextRaw));
        String collectedTextRaw = JsonUtils.getOrDefault(style, "collectedText", (String)null);
        this.collectedText = collectedTextRaw == null ? Component.m_237115_((String)"questlog.reward.collected") : (translatable ? Component.m_237115_((String)collectedTextRaw) : Component.m_237113_((String)collectedTextRaw));
        JsonObject notification = JsonUtils.getOrDefault(data, "notification", new JsonObject());
        this.toastOnTrigger = JsonUtils.getOrDefault(notification, "toastOnTrigger", true);
        this.toastOnComplete = JsonUtils.getOrDefault(notification, "toastOnComplete", true);
        this.popup = JsonUtils.getOrDefault(notification, "popup", false);
        this.hidden = JsonUtils.getOrDefault(data, "hidden", false);
    }

    public void setQuest(Quest quest) {
        this.objectiveDisplay = quest.objectives.stream().map(WithDisplayData::getDisplay).filter(Objects::nonNull).toList();
        this.rewardDisplay = quest.rewards.stream().map(WithDisplayData::getDisplay).filter(Objects::nonNull).toList();
    }

    public Component getTitle() {
        return this.title;
    }

    public Component getDescription() {
        return this.description;
    }

    public List<ObjectiveDisplayData> getObjectiveDisplayData() {
        if (this.objectiveDisplay == null) {
            throw new IllegalStateException("QuestDisplayData has not been assigned a quest");
        }
        return this.objectiveDisplay;
    }

    public List<RewardDisplayData> getRewardDisplayData() {
        if (this.rewardDisplay == null) {
            throw new IllegalStateException("QuestDisplayData has not been assigned a quest");
        }
        return this.rewardDisplay;
    }

    @Nullable
    public Blittable getIcon() {
        return this.icon;
    }

    @Nullable
    public SoundEvent getCompletedSound() {
        return (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(this.completedSound);
    }

    @Nullable
    public SoundEvent getTriggeredSound() {
        return (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(this.triggeredSound);
    }

    public QuestlogGuiSet getGuiSet() {
        return this.bgTexture.equals((Object)QuestlogGuiSet.DEFAULT.backgroundLoc) && this.peripheralTexture.equals((Object)QuestlogGuiSet.DEFAULT.peripheralLoc) ? QuestlogGuiSet.DEFAULT : new QuestlogGuiSet(this.bgTexture, this.peripheralTexture);
    }

    public boolean shouldToastOnTrigger() {
        return this.toastOnTrigger;
    }

    public boolean shouldToastOnComplete() {
        return this.toastOnComplete;
    }

    public boolean shouldPopup() {
        return this.popup;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Palette getPalette() {
        return this.palette;
    }

    public Component getBackButtonText() {
        return this.backButtonText;
    }

    public Component getCollectButtonText() {
        return this.collectButtonText;
    }

    public Component getCollectedText() {
        return this.collectedText;
    }

    public Component getUncollectedText() {
        return this.uncollectedText;
    }
}

