/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.core.quests.display;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import org.infernalstudios.questlog.core.quests.objectives.Objective;
import org.infernalstudios.questlog.util.JsonUtils;
import org.infernalstudios.questlog.util.texture.Blittable;

public class ObjectiveDisplayData {
    @Nullable
    private final Blittable icon;
    private final Component name;
    @Nullable
    private Objective objective;

    public ObjectiveDisplayData(JsonObject data) {
        String name = JsonUtils.getOrDefault(data, "name", (String)null);
        this.name = name == null ? Component.m_237115_((String)"questlog.objective.default") : (JsonUtils.getOrDefault(data, "translatable", false) ? Component.m_237115_((String)name) : Component.m_237113_((String)name));
        this.icon = JsonUtils.getIcon(data, "icon");
    }

    public void setObjective(@Nullable Objective objective) {
        this.objective = objective;
    }

    public Component getName() {
        return this.name;
    }

    public boolean isCompleted() {
        if (this.objective == null) {
            throw new IllegalStateException("ObjectiveDisplayData has not been assigned a quest type");
        }
        return this.objective.isCompleted();
    }

    public Component getProgress() {
        if (this.objective == null) {
            throw new IllegalStateException("ObjectiveDisplayData has not been assigned a quest type");
        }
        return this.isCompleted() ? Component.m_237115_((String)"questlog.objective.completed") : (this.objective.getTotalUnits() > 1 ? Component.m_237110_((String)"questlog.objective.in_progress", (Object[])new Object[]{this.objective.getUnits(), this.objective.getTotalUnits()}) : Component.m_237115_((String)"questlog.objective.in_progress_singular"));
    }

    @Nullable
    public Blittable getIcon() {
        return this.icon;
    }
}

