/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.core.quests;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import org.infernalstudios.questlog.core.quests.objectives.Objective;
import org.infernalstudios.questlog.core.quests.objectives.block.BlockMineObjective;
import org.infernalstudios.questlog.core.quests.objectives.block.BlockPlaceObjective;
import org.infernalstudios.questlog.core.quests.objectives.entity.EntityApproachObjective;
import org.infernalstudios.questlog.core.quests.objectives.entity.EntityBreedObjective;
import org.infernalstudios.questlog.core.quests.objectives.entity.EntityDeathObjective;
import org.infernalstudios.questlog.core.quests.objectives.entity.EntityKillObjective;
import org.infernalstudios.questlog.core.quests.objectives.entity.EntityTameObjective;
import org.infernalstudios.questlog.core.quests.objectives.item.ItemCraftObjective;
import org.infernalstudios.questlog.core.quests.objectives.item.ItemDropObjective;
import org.infernalstudios.questlog.core.quests.objectives.item.ItemEquipObjective;
import org.infernalstudios.questlog.core.quests.objectives.item.ItemObtainObjective;
import org.infernalstudios.questlog.core.quests.objectives.item.ItemPickupObjective;
import org.infernalstudios.questlog.core.quests.objectives.item.ItemUseObjective;
import org.infernalstudios.questlog.core.quests.objectives.misc.EffectAddedObjective;
import org.infernalstudios.questlog.core.quests.objectives.misc.EnchantObjective;
import org.infernalstudios.questlog.core.quests.objectives.misc.QuestCompleteObjective;
import org.infernalstudios.questlog.core.quests.objectives.misc.StatisticObjective;
import org.infernalstudios.questlog.core.quests.objectives.misc.TrampleObjective;
import org.infernalstudios.questlog.core.quests.objectives.misc.VisitBiomeObjective;
import org.infernalstudios.questlog.core.quests.objectives.misc.VisitDimensionObjective;
import org.infernalstudios.questlog.core.quests.objectives.misc.VisitPositionObjective;
import org.infernalstudios.questlog.core.quests.objectives.misc.VisitStructureObjective;
import org.infernalstudios.questlog.util.JsonUtils;

public class QuestObjectiveRegistry {
    private static final Map<ResourceLocation, Function<JsonObject, Objective>> REGISTRY = new HashMap<ResourceLocation, Function<JsonObject, Objective>>();

    public static void register(ResourceLocation id, Function<JsonObject, Objective> factory) {
        REGISTRY.put(id, factory);
    }

    public static Objective create(JsonObject definition) {
        ResourceLocation type;
        try {
            type = new ResourceLocation(JsonUtils.getString(definition, "type"));
        }
        catch (ResourceLocationException e) {
            throw new IllegalStateException("Invalid quest type: " + JsonUtils.getString(definition, "type"));
        }
        return QuestObjectiveRegistry.create(type, definition);
    }

    public static Objective create(ResourceLocation type, JsonObject definition) {
        if (!REGISTRY.containsKey(type)) {
            throw new NullPointerException("Objective type not found: " + type);
        }
        try {
            return REGISTRY.get(type).apply(definition);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create objective of type " + type, e);
        }
    }

    static {
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "block_mine"), BlockMineObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "block_place"), BlockPlaceObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "entity_breed"), EntityBreedObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "entity_death"), EntityDeathObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "entity_kill"), EntityKillObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "entity_approach"), EntityApproachObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "entity_tame"), EntityTameObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "item_craft"), ItemCraftObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "item_drop"), ItemDropObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "item_equip"), ItemEquipObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "item_obtain"), ItemObtainObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "item_pickup"), ItemPickupObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "item_use"), ItemUseObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "stat"), StatisticObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "trample"), TrampleObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "enchant"), EnchantObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "effect_added"), EffectAddedObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "visit_biome"), VisitBiomeObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "visit_dimension"), VisitDimensionObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "visit_position"), VisitPositionObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "visit_structure"), VisitStructureObjective::new);
        QuestObjectiveRegistry.register(new ResourceLocation("questlog", "quest_complete"), QuestCompleteObjective::new);
    }
}

