/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.core;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.infernalstudios.questlog.Questlog;
import org.infernalstudios.questlog.core.DefinitionUtil;
import org.infernalstudios.questlog.core.QuestManager;
import org.infernalstudios.questlog.core.quests.Quest;
import org.infernalstudios.questlog.mixin.MinecraftServerAccessor;
import org.infernalstudios.questlog.mixin.PlayerDataStorageAccessor;
import org.infernalstudios.questlog.network.packet.QuestDefinitionPacket;
import org.infernalstudios.questlog.platform.Services;

public class ServerPlayerManager {
    public static ServerPlayerManager INSTANCE = null;
    private final Map<UUID, QuestManager> questManagers = new HashMap<UUID, QuestManager>();
    private final MinecraftServer server;

    public ServerPlayerManager(MinecraftServer server) {
        this.server = server;
        for (Player player : this.server.m_6846_().m_11314_()) {
            this.addPlayer(player);
        }
    }

    public void addPlayer(Player player) {
        QuestManager questManager = new QuestManager(player);
        this.questManagers.put(player.m_20148_(), questManager);
    }

    public QuestManager getManagerByPlayer(Player player) {
        if (!this.questManagers.containsKey(player.m_20148_()) || this.questManagers.get((Object)player.m_20148_()).player != player) {
            this.addPlayer(player);
        }
        return this.questManagers.get(player.m_20148_());
    }

    public void save() {
        for (QuestManager questManager : this.questManagers.values()) {
            this.save(questManager);
        }
    }

    public void save(QuestManager questManager) {
        Questlog.LOGGER.debug("Saving player data for {}", (Object)questManager.player.m_36316_().getName());
        CompoundTag data = new CompoundTag();
        for (Quest quest : questManager.getAllQuests()) {
            data.m_128365_(quest.getId().toString(), (Tag)quest.serialize());
        }
        File playerDataFile = this.getPlayerDataFile(questManager.player);
        try {
            NbtIo.m_128944_((CompoundTag)data, (File)playerDataFile);
        }
        catch (IOException e) {
            Questlog.LOGGER.error("Failed to save player data for {}", (Object)questManager.player.m_36316_().getName());
        }
    }

    public void load() {
        Questlog.LOGGER.trace("Loading all player data");
        for (Player player : this.server.m_6846_().m_11314_()) {
            this.load(this.getManagerByPlayer(player));
        }
    }

    public void load(QuestManager questManager) {
        CompoundTag data;
        Questlog.LOGGER.debug("Loading player data for {}", (Object)questManager.player.m_36316_().getName());
        File playerDataFile = this.getPlayerDataFile(questManager.player);
        if (!playerDataFile.exists()) {
            try {
                NbtIo.m_128944_((CompoundTag)new CompoundTag(), (File)playerDataFile);
            }
            catch (IOException e) {
                Questlog.LOGGER.error("Failed to create player data for {}", (Object)questManager.player.m_36316_().getName());
                return;
            }
        }
        try {
            data = NbtIo.m_128937_((File)playerDataFile);
        }
        catch (IOException e) {
            Questlog.LOGGER.error("Failed to load player data for {}", (Object)questManager.player.m_36316_().getName());
            Questlog.LOGGER.error((Object)e);
            return;
        }
        boolean shouldSave = false;
        questManager.createAllQuests();
        for (Quest quest : questManager.getAllQuests()) {
            if (data.m_128441_(quest.getId().toString())) {
                CompoundTag questData = data.m_128469_(quest.getId().toString());
                quest.deserialize(questData);
            } else {
                shouldSave = true;
            }
            Questlog.LOGGER.trace("Loaded quest {} for {}, sending definition packet", (Object)quest.getId(), (Object)questManager.player.m_36316_().getName());
            Services.PLATFORM.sendPacketToClient((ServerPlayer)questManager.player, new QuestDefinitionPacket(quest.getId(), DefinitionUtil.getCached(quest.getId())));
        }
        if (shouldSave) {
            this.save(questManager);
        }
    }

    private File getPlayerDataFile(Player player) {
        return new File(((PlayerDataStorageAccessor)((MinecraftServerAccessor)this.server).getPlayerDataStorage()).getPlayerDir(), player.m_20148_() + ".questlog.dat");
    }
}

