/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.infernalstudios.questlog.core.QuestManager;
import org.infernalstudios.questlog.core.ServerPlayerManager;
import org.infernalstudios.questlog.core.quests.Quest;
import org.infernalstudios.questlog.core.quests.objectives.Objective;
import org.infernalstudios.questlog.core.quests.rewards.Reward;

public class QuestlogCommands {
    private static final SimpleCommandExceptionType UNKNOWN_QUEST = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.questlog.argument.quest.unknown"));
    private static final SimpleCommandExceptionType INVALID_TRIGGER = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.questlog.argument.trigger.invalid"));
    private static final SimpleCommandExceptionType INVALID_OBJECTIVE = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.questlog.argument.objective.invalid"));
    private static final SimpleCommandExceptionType INVALID_REWARD = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.questlog.argument.reward.invalid"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode root = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"questlog").requires(stack -> stack.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"quest", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, builder) -> {
            QuestManager manager = ServerPlayerManager.INSTANCE.getManagerByPlayer((Player)((CommandSourceStack)ctx.getSource()).m_81375_());
            manager.getAllQuests().stream().map(Quest::getId).forEach(id -> builder.suggest(id.toString()));
            return builder.buildFuture();
        }).then(Commands.m_82127_((String)"reset").executes(ctx -> QuestlogCommands.resetQuest((CommandContext<CommandSourceStack>)ctx, QuestlogCommands.getQuest((CommandContext<CommandSourceStack>)ctx))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"trigger").then(Commands.m_82127_((String)"reset").executes(ctx -> QuestlogCommands.resetAllTriggers((CommandContext<CommandSourceStack>)ctx, QuestlogCommands.getQuest((CommandContext<CommandSourceStack>)ctx))))).then(Commands.m_82127_((String)"set").executes(ctx -> QuestlogCommands.setAllTriggers((CommandContext<CommandSourceStack>)ctx, QuestlogCommands.getQuest((CommandContext<CommandSourceStack>)ctx))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"trigger", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82127_((String)"reset").executes(ctx -> QuestlogCommands.resetTrigger((CommandContext<CommandSourceStack>)ctx, QuestlogCommands.getQuest((CommandContext<CommandSourceStack>)ctx), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"trigger"))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"units", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> QuestlogCommands.setTrigger((CommandContext<CommandSourceStack>)ctx, QuestlogCommands.getQuest((CommandContext<CommandSourceStack>)ctx), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"trigger"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"units"))))).executes(ctx -> QuestlogCommands.setTrigger((CommandContext<CommandSourceStack>)ctx, QuestlogCommands.getQuest((CommandContext<CommandSourceStack>)ctx), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"trigger"), 1)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"objective").then(Commands.m_82127_((String)"reset").executes(ctx -> QuestlogCommands.resetAllObjectives((CommandContext<CommandSourceStack>)ctx, QuestlogCommands.getQuest((CommandContext<CommandSourceStack>)ctx))))).then(Commands.m_82127_((String)"set").executes(ctx -> QuestlogCommands.setAllObjectives((CommandContext<CommandSourceStack>)ctx, QuestlogCommands.getQuest((CommandContext<CommandSourceStack>)ctx))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"objective", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82127_((String)"reset").executes(ctx -> QuestlogCommands.resetObjective((CommandContext<CommandSourceStack>)ctx, QuestlogCommands.getQuest((CommandContext<CommandSourceStack>)ctx), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"objective"))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"units", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> QuestlogCommands.setObjective((CommandContext<CommandSourceStack>)ctx, QuestlogCommands.getQuest((CommandContext<CommandSourceStack>)ctx), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"objective"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"units"))))).executes(ctx -> QuestlogCommands.setObjective((CommandContext<CommandSourceStack>)ctx, QuestlogCommands.getQuest((CommandContext<CommandSourceStack>)ctx), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"objective"), 1)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reward").then(Commands.m_82127_((String)"uncollect").executes(ctx -> QuestlogCommands.uncollectAllRewards((CommandContext<CommandSourceStack>)ctx, QuestlogCommands.getQuest((CommandContext<CommandSourceStack>)ctx))))).then(Commands.m_82127_((String)"collect").executes(ctx -> QuestlogCommands.collectAllRewards((CommandContext<CommandSourceStack>)ctx, QuestlogCommands.getQuest((CommandContext<CommandSourceStack>)ctx))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"reward", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82127_((String)"uncollect").executes(ctx -> QuestlogCommands.uncollectReward((CommandContext<CommandSourceStack>)ctx, QuestlogCommands.getQuest((CommandContext<CommandSourceStack>)ctx), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"reward"))))).then(Commands.m_82127_((String)"collect").executes(ctx -> QuestlogCommands.collectReward((CommandContext<CommandSourceStack>)ctx, QuestlogCommands.getQuest((CommandContext<CommandSourceStack>)ctx), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"reward"))))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ql").requires(stack -> stack.m_6761_(2))).redirect((CommandNode)root));
    }

    private static int resetQuest(CommandContext<CommandSourceStack> ctx, Quest quest) throws CommandSyntaxException {
        quest.triggers.forEach(trigger -> trigger.setUnits(0));
        quest.objectives.forEach(objective -> objective.setUnits(0));
        quest.rewards.forEach(Reward::revokeReward);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"command.questlog.reset.success", (Object[])new Object[]{quest.getId()}), true);
        return 0;
    }

    private static int resetAllObjectives(CommandContext<CommandSourceStack> ctx, Quest quest) {
        quest.objectives.forEach(objective -> objective.setUnits(0));
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.questlog.objective.reset_all"), true);
        return 0;
    }

    private static int setAllObjectives(CommandContext<CommandSourceStack> ctx, Quest quest) throws CommandSyntaxException {
        quest.objectives.forEach(objective -> objective.setUnits(objective.getTotalUnits()));
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.questlog.objective.set_all"), true);
        return 0;
    }

    private static int resetObjective(CommandContext<CommandSourceStack> ctx, Quest quest, int index) throws CommandSyntaxException {
        if (index < 0 || index >= quest.objectives.size()) {
            throw INVALID_OBJECTIVE.create();
        }
        quest.objectives.get(index).setUnits(0);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"command.questlog.objective.reset", (Object[])new Object[]{index}), true);
        return 0;
    }

    private static int setObjective(CommandContext<CommandSourceStack> ctx, Quest quest, int index, int units) throws CommandSyntaxException {
        if (index < 0 || index >= quest.objectives.size()) {
            throw INVALID_OBJECTIVE.create();
        }
        Objective objective = quest.objectives.get(index);
        objective.setUnits(units == -1 ? objective.getTotalUnits() : units);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"command.questlog.objective.set", (Object[])new Object[]{index, units}), true);
        return 0;
    }

    private static int resetAllTriggers(CommandContext<CommandSourceStack> ctx, Quest quest) {
        quest.triggers.forEach(trigger -> trigger.setUnits(0));
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.questlog.trigger.reset_all"), true);
        return 0;
    }

    private static int setAllTriggers(CommandContext<CommandSourceStack> ctx, Quest quest) throws CommandSyntaxException {
        quest.triggers.forEach(trigger -> trigger.setUnits(trigger.getTotalUnits()));
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.questlog.trigger.set_all"), true);
        return 0;
    }

    private static int resetTrigger(CommandContext<CommandSourceStack> ctx, Quest quest, int index) throws CommandSyntaxException {
        if (index < 0 || index >= quest.triggers.size()) {
            throw INVALID_TRIGGER.create();
        }
        quest.triggers.get(index).setUnits(0);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"command.questlog.trigger.reset", (Object[])new Object[]{index}), true);
        return 0;
    }

    private static int setTrigger(CommandContext<CommandSourceStack> ctx, Quest quest, int index, int units) throws CommandSyntaxException {
        if (index < 0 || index >= quest.triggers.size()) {
            throw INVALID_TRIGGER.create();
        }
        Objective trigger = quest.triggers.get(index);
        trigger.setUnits(units == -1 ? trigger.getTotalUnits() : units);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"command.questlog.trigger.set", (Object[])new Object[]{index, units}), true);
        return 0;
    }

    private static int uncollectAllRewards(CommandContext<CommandSourceStack> ctx, Quest quest) {
        quest.rewards.forEach(Reward::revokeReward);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.questlog.reward.uncollect_all"), true);
        return 0;
    }

    private static int collectAllRewards(CommandContext<CommandSourceStack> ctx, Quest quest) throws CommandSyntaxException {
        quest.rewards.forEach(reward -> {
            if (!reward.hasRewarded()) {
                reward.applyReward(((CommandSourceStack)ctx.getSource()).m_230896_());
            }
        });
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"command.questlog.reward.collect_all"), true);
        return 0;
    }

    private static int uncollectReward(CommandContext<CommandSourceStack> ctx, Quest quest, int index) throws CommandSyntaxException {
        if (index < 0 || index >= quest.rewards.size()) {
            throw INVALID_REWARD.create();
        }
        quest.rewards.get(index).revokeReward();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"command.questlog.reward.uncollect", (Object[])new Object[]{index}), true);
        return 0;
    }

    private static int collectReward(CommandContext<CommandSourceStack> ctx, Quest quest, int index) throws CommandSyntaxException {
        if (index < 0 || index >= quest.rewards.size()) {
            throw INVALID_REWARD.create();
        }
        if (!quest.rewards.get(index).hasRewarded()) {
            quest.rewards.get(index).applyReward(((CommandSourceStack)ctx.getSource()).m_230896_());
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"command.questlog.reward.success", (Object[])new Object[]{index}), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"command.questlog.reward.already_collected", (Object[])new Object[]{index}), false);
        }
        return 0;
    }

    private static Quest getQuest(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ResourceLocation id;
        QuestManager manager = ServerPlayerManager.INSTANCE.getManagerByPlayer((Player)((CommandSourceStack)ctx.getSource()).m_81375_());
        Quest quest = manager.getQuest(id = (ResourceLocation)ctx.getArgument("quest", ResourceLocation.class));
        if (quest == null) {
            throw UNKNOWN_QUEST.create();
        }
        return quest;
    }
}

