/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.client.gui.screen;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.infernalstudios.questlog.QuestlogClient;
import org.infernalstudios.questlog.client.gui.components.QuestList;
import org.infernalstudios.questlog.client.gui.components.ScrollableComponent;
import org.infernalstudios.questlog.client.gui.screen.QuestDetails;
import org.infernalstudios.questlog.core.QuestManager;
import org.infernalstudios.questlog.core.quests.Quest;
import org.infernalstudios.questlog.util.texture.Texture;
import org.jetbrains.annotations.NotNull;

public class QuestlogScreen
extends Screen {
    private static final Texture BACKGROUND_TEXTURE = new Texture(new ResourceLocation("questlog", "textures/gui/questlog.png"), 1024, 512, 0, 0, 1024, 512);
    private final Screen previousScreen;
    private final QuestManager manager;
    @Nullable
    private ScrollableComponent questList;

    public QuestlogScreen(@Nullable Screen previousScreen) {
        super((Component)Component.m_237119_());
        this.previousScreen = previousScreen;
        this.manager = Objects.requireNonNull(QuestlogClient.getLocal());
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.questList != null) {
            this.m_169411_(this.questList);
        }
        this.questList = this.getList();
        if (this.questList != null) {
            this.m_142416_(this.questList);
        }
    }

    @Nullable
    private ScrollableComponent getList() {
        int width = 245;
        int height = 136;
        int x = (this.f_96543_ - width) / 2 + 1;
        int y = (this.f_96544_ - height) / 2 + 1;
        List<Quest> quests = this.manager.getAllQuests().stream().filter(quest -> !quest.getDisplay().isHidden() && quest.isTriggered()).toList();
        if (quests.isEmpty()) {
            return null;
        }
        return new ScrollableComponent(x, y, width, height, new QuestList(Minecraft.m_91087_(), quests, displayData -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new QuestDetails(this, (Quest)displayData));
            }
        }));
    }

    public void m_280273_(@NotNull GuiGraphics ps) {
        super.m_280273_(ps);
        int x = (this.f_96543_ - BACKGROUND_TEXTURE.width()) / 2;
        int y = (this.f_96544_ - BACKGROUND_TEXTURE.height()) / 2;
        BACKGROUND_TEXTURE.blit(ps, x, y);
    }

    public void m_88315_(@NotNull GuiGraphics ps, int mouseX, int mouseY, float delta) {
        this.m_280273_(ps);
        if (this.questList != null) {
            this.questList.m_88315_(ps, mouseX, mouseY, delta);
        } else {
            Font font = Objects.requireNonNull(this.f_96541_).f_91062_;
            float scale = 2.0f;
            ps.m_280168_().m_85836_();
            ps.m_280168_().m_85841_(scale, scale, scale);
            MutableComponent text = Component.m_237115_((String)"questlog.no_quests");
            int n = (int)(((float)this.f_96543_ - (float)font.m_92852_((FormattedText)text) * scale) / 2.0f / scale);
            float f = this.f_96544_;
            Objects.requireNonNull(font);
            ps.m_280614_(font, (Component)text, n, (int)((f - 9.0f * scale) / 2.0f / scale), 4995099, false);
            ps.m_280168_().m_85849_();
        }
        super.m_88315_(ps, mouseX, mouseY, delta);
    }

    public boolean m_7043_() {
        return true;
    }

    public boolean m_7933_(int key, int p_96553_, int p_96554_) {
        if (key == 256 || key == 69 || QuestlogClient.OPEN_SCREEN_KEY.m_90832_(key, p_96553_)) {
            Minecraft.m_91087_().m_91152_(this.previousScreen);
            return true;
        }
        return false;
    }
}

