/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.client.gui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.narration.NarrationSupplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import org.infernalstudios.questlog.client.gui.QuestlogGuiSet;
import org.infernalstudios.questlog.client.gui.components.QuestlogButton;
import org.infernalstudios.questlog.client.gui.components.ScrollableComponent;
import org.infernalstudios.questlog.client.gui.components.scrollable.ScrollableText;
import org.infernalstudios.questlog.core.quests.Quest;
import org.infernalstudios.questlog.core.quests.display.ObjectiveDisplayData;
import org.infernalstudios.questlog.core.quests.display.Palette;
import org.infernalstudios.questlog.core.quests.display.QuestDisplayData;
import org.infernalstudios.questlog.core.quests.display.RewardDisplayData;
import org.infernalstudios.questlog.core.quests.rewards.Reward;
import org.infernalstudios.questlog.network.packet.QuestRewardCollectPacket;
import org.infernalstudios.questlog.platform.Services;
import org.infernalstudios.questlog.util.texture.Blittable;
import org.jetbrains.annotations.NotNull;

public class QuestDetails
extends Screen
implements NarrationSupplier {
    private static final int TITLE_X = 71;
    private static final int TITLE_Y = 13;
    private static final int TITLE_WIDTH = 132;
    private static final int TITLE_HEIGHT = 16;
    private static final int CONTENT_X = 18;
    private static final int CONTENT_Y = 36;
    private static final int CONTENT_WIDTH = 237;
    private static final int CONTENT_HEIGHT = 86;
    private static final int BUTTON_X = 121;
    private static final int BUTTON_Y = 138;
    private static final int DESCRIPTION_INFO_PADDING = 5;
    private final Quest quest;
    @Nullable
    private final Screen previousScreen;
    private int x;
    private int y;
    @Nullable
    private QuestlogButton backButton;
    @Nullable
    private ScrollableComponent description;
    @Nullable
    private ScrollableComponent info;

    public QuestDetails(@Nullable Screen previousScreen, Quest quest) {
        super(quest.getDisplay().getTitle());
        this.previousScreen = previousScreen;
        this.quest = quest;
    }

    private QuestDisplayData getDisplay() {
        return this.quest.getDisplay();
    }

    private Palette getPalette() {
        return this.getDisplay().getPalette();
    }

    private QuestlogGuiSet getGuiSet() {
        return this.getDisplay().getGuiSet();
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.f_96541_ == null) {
            throw new IllegalStateException("Minecraft is null, UNREACHABLE");
        }
        this.x = (this.f_96543_ - this.getGuiSet().detailBackground.width()) / 2 + 375;
        this.y = (this.f_96544_ - this.getGuiSet().detailBackground.height()) / 2 + 174;
        if (this.backButton != null) {
            this.m_169411_((GuiEventListener)this.backButton);
        }
        this.backButton = new QuestlogButton(this.x + 121, this.y + 138, this.getPalette().textColor, this.getPalette().hoveredTextColor, this.getDisplay().getBackButtonText(), () -> {
            if (this.quest.isCompleted() && !this.quest.isRewarded()) {
                for (int i = 0; i < this.quest.rewards.size(); ++i) {
                    Reward reward = this.quest.rewards.get(i);
                    if (reward.hasRewarded()) continue;
                    Services.PLATFORM.sendPacketToServer(new QuestRewardCollectPacket(this.quest.getId(), i));
                    SoundEvent sound = null;
                    if (reward.getDisplay() != null) {
                        sound = reward.getDisplay().getClaimSound();
                    }
                    if (sound == null) continue;
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)sound, (float)1.0f, (float)1.0f));
                }
            } else if (this.f_96541_ != null) {
                this.f_96541_.m_91152_(this.previousScreen);
            }
        }, this.getGuiSet());
        this.m_142416_((GuiEventListener)this.backButton);
        if (this.description != null) {
            this.m_169411_(this.description);
        }
        this.description = new ScrollableComponent(this.x + 18, this.y + 36, 237, 86 - this.getInfoHeight() - 5, new ScrollableText(this.f_96541_.f_91062_, (FormattedText)this.getDisplay().getDescription(), this.getPalette().textColor));
        this.m_7787_(this.description);
        if (this.info != null) {
            this.m_169411_(this.info);
        }
        this.info = new ScrollableComponent(this.x + 18, this.y + 36 + 86 - this.getInfoHeight() + 5, 237, this.getInfoHeight(), new InfoScrollable(this.getDisplay()));
        this.m_7787_(this.info);
    }

    private void drawHorizontalLine(GuiGraphics ps, int x, int y, boolean small) {
        (small ? this.getGuiSet().smallHR : this.getGuiSet().bigHR).blit(ps, x - (small ? 60 : 10), y - 4);
    }

    public void m_88315_(@NotNull GuiGraphics ps, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(ps);
        if (this.backButton != null) {
            if (this.quest.isCompleted() && !this.quest.isRewarded()) {
                this.backButton.m_93666_(this.getDisplay().getCollectButtonText());
            } else {
                this.backButton.m_93666_(this.getDisplay().getBackButtonText());
            }
        }
        super.m_88315_(ps, mouseX, mouseY, partialTicks);
        this.renderTitle(ps);
        this.renderDescription(ps);
        this.renderInfo(ps);
    }

    public void m_280273_(@NotNull GuiGraphics ps) {
        super.m_280273_(ps);
        this.getGuiSet().detailBackground.blit(ps, this.x - 375, this.y - 174);
    }

    private void renderTitle(GuiGraphics ps) {
        QuestDisplayData displayData = this.getDisplay();
        float titleWidth = this.f_96547_.m_92852_((FormattedText)displayData.getTitle()) + (displayData.getIcon() != null ? displayData.getIcon().width() + 4 : 0);
        float x = (float)(this.x + 71) + (132.0f - titleWidth) / 2.0f;
        float y = this.y + 13;
        if (displayData.getIcon() != null) {
            displayData.getIcon().blit(ps, (int)x, this.y + 13);
            x += (float)(displayData.getIcon().width() + 4);
        }
        Objects.requireNonNull(this.f_96547_);
        ps.m_280614_(this.f_96547_, displayData.getTitle(), (int)x, (int)(y += (float)(16 - 9 + 2) / 2.0f), this.getPalette().titleColor, false);
        this.drawHorizontalLine(ps, this.x + 71, this.y + 13 + 16 + 2, true);
    }

    private int getInfoHeight() {
        return Math.min(2, this.quest.isCompleted() ? this.getDisplay().getRewardDisplayData().size() : this.getDisplay().getObjectiveDisplayData().size()) * 18;
    }

    private void renderInfo(GuiGraphics ps) {
        if (this.info == null) {
            throw new IllegalStateException("Info is null");
        }
        this.info.m_88315_(ps, 0, 0, 0.0f);
        if (this.info.height != 0) {
            this.drawHorizontalLine(ps, this.x + 18, this.y + 36 + 86 - this.getInfoHeight(), false);
        }
    }

    private void renderDescription(GuiGraphics ps) {
        if (this.description == null) {
            throw new IllegalStateException("Description is null");
        }
        this.description.m_88315_(ps, 0, 0, 0.0f);
    }

    public boolean m_7043_() {
        return true;
    }

    public void m_142291_(@NotNull NarrationElementOutput output) {
    }

    private class InfoScrollable
    implements ScrollableComponent.Scrollable {
        private final QuestDisplayData display;
        private List<InfoEntry> rewards;
        private List<InfoEntry> objectives;
        @Nullable
        private ScrollableComponent parent = null;

        public InfoScrollable(QuestDisplayData display) {
            this.display = display;
        }

        private List<InfoEntry> getInfoEntries() {
            if (QuestDetails.this.quest.isCompleted()) {
                if (this.rewards == null) {
                    this.rewards = new ArrayList<InfoEntry>();
                    List<RewardDisplayData> rewardDisplayData = QuestDetails.this.getDisplay().getRewardDisplayData();
                    for (int i = 0; i < rewardDisplayData.size(); ++i) {
                        RewardDisplayData reward = rewardDisplayData.get(i);
                        this.rewards.add(new InfoEntry(reward, 0, i * 18, this.display));
                    }
                }
                return this.rewards;
            }
            if (this.objectives == null) {
                this.objectives = new ArrayList<InfoEntry>();
                List<ObjectiveDisplayData> objectiveDisplayData = QuestDetails.this.getDisplay().getObjectiveDisplayData();
                for (int i = 0; i < objectiveDisplayData.size(); ++i) {
                    ObjectiveDisplayData objective = objectiveDisplayData.get(i);
                    this.objectives.add(new InfoEntry(objective, 0, i * 18));
                }
            }
            return this.objectives;
        }

        @Override
        public int getHeight() {
            return this.getInfoEntries().size() * 18;
        }

        public void m_88315_(@NotNull GuiGraphics ps, int mouseX, int mouseY, float partialTicks) {
            List<InfoEntry> infoEntries = this.getInfoEntries();
            for (int i = 0; i < infoEntries.size(); ++i) {
                InfoEntry entry = infoEntries.get(i);
                entry.x = this.parent != null ? (int)this.parent.getXOffset() : 0;
                entry.y = this.parent != null ? (int)this.parent.getYOffset() + 18 * i : 0;
                entry.m_88315_(ps, mouseX, mouseY, partialTicks);
            }
        }

        @Override
        public void setScrollableComponent(ScrollableComponent parent) {
            this.parent = parent;
        }
    }

    private class InfoEntry
    implements Renderable,
    GuiEventListener {
        private static final int INFO_ENTRY_HEIGHT = 18;
        @CheckForNull
        private final RewardDisplayData rewardDisplayData;
        @CheckForNull
        private final ObjectiveDisplayData objectiveDisplayData;
        protected int x;
        protected int y;
        @Nullable
        private QuestDisplayData display;

        public InfoEntry(RewardDisplayData rewardDisplayData, int x, @Nullable int y, QuestDisplayData display) {
            this.rewardDisplayData = rewardDisplayData;
            this.objectiveDisplayData = null;
            this.x = x;
            this.y = y;
            this.display = display;
        }

        public InfoEntry(ObjectiveDisplayData objectiveDisplayData, int x, int y) {
            this.rewardDisplayData = null;
            this.objectiveDisplayData = objectiveDisplayData;
            this.x = x;
            this.y = y;
        }

        private boolean isReward() {
            return this.rewardDisplayData != null && this.objectiveDisplayData == null;
        }

        private boolean isObjective() {
            return this.objectiveDisplayData != null && this.rewardDisplayData == null;
        }

        public void m_88315_(@NotNull GuiGraphics ps, int mouseX, int mouseY, float partialTicks) {
            if (this.isReward()) {
                this.renderReward(ps);
            } else if (this.isObjective()) {
                this.renderObjective(ps);
            } else {
                throw new IllegalStateException("Unknown entry type");
            }
        }

        private boolean drawIcon(GuiGraphics ps, @Nullable Blittable icon) {
            if (icon != null) {
                icon.blit(ps, this.x, this.y);
                return true;
            }
            return false;
        }

        private int drawName(GuiGraphics ps, Component name, boolean hasIcon) {
            Font font = Minecraft.m_91087_().f_91062_;
            int x = this.x + (hasIcon ? 18 : 0);
            Objects.requireNonNull(font);
            int y = this.y + (18 - 9) / 2;
            ps.m_280614_(font, name, x, y, QuestDetails.this.getPalette().textColor, false);
            return font.m_92852_((FormattedText)name) + (hasIcon ? 18 : 0);
        }

        private void drawProgress(GuiGraphics ps, int x) {
            Font font = Minecraft.m_91087_().f_91062_;
            Objects.requireNonNull(font);
            int y = this.y + (18 - 9) / 2;
            if (!this.isObjective()) {
                throw new IllegalCallerException("Progress can only be drawn for objectives");
            }
            Component progress = this.objectiveDisplayData.getProgress();
            ps.m_280614_(font, progress, x, y, this.objectiveDisplayData.isCompleted() ? QuestDetails.this.getPalette().completedTextColor : QuestDetails.this.getPalette().progressTextColor, false);
        }

        private void drawCollected(GuiGraphics ps, int x) {
            MutableComponent collected;
            Font font = Minecraft.m_91087_().f_91062_;
            Objects.requireNonNull(font);
            int y = this.y + (18 - 9) / 2;
            if (!this.isReward()) {
                throw new IllegalCallerException("Collected can only be drawn for rewards");
            }
            MutableComponent mutableComponent = collected = this.rewardDisplayData.hasRewarded() ? Component.m_237115_((String)"questlog.reward.collected") : Component.m_237115_((String)"questlog.reward.uncollected");
            if (this.display != null) {
                collected = this.rewardDisplayData.hasRewarded() ? this.display.getCollectedText() : this.display.getUncollectedText();
            }
            ps.m_280614_(font, (Component)collected, x, y, this.rewardDisplayData.hasRewarded() ? QuestDetails.this.getPalette().completedTextColor : QuestDetails.this.getPalette().progressTextColor, false);
        }

        private void renderReward(GuiGraphics ps) {
            if (this.rewardDisplayData == null) {
                throw new IllegalStateException("RewardDisplayData is null");
            }
            boolean hasIcon = this.drawIcon(ps, this.rewardDisplayData.getIcon());
            int nameWidth = this.drawName(ps, this.rewardDisplayData.getName(), hasIcon);
            this.drawCollected(ps, this.x + nameWidth + 5);
        }

        private void renderObjective(GuiGraphics ps) {
            if (this.objectiveDisplayData == null) {
                throw new IllegalStateException("ObjectiveDisplayData is null");
            }
            boolean hasIcon = this.drawIcon(ps, this.objectiveDisplayData.getIcon());
            int nameWidth = this.drawName(ps, this.objectiveDisplayData.getName(), hasIcon);
            this.drawProgress(ps, this.x + nameWidth + 5);
        }

        public boolean m_93696_() {
            return false;
        }

        public void m_93692_(boolean var1) {
        }
    }
}

