/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.client.gui.components.toasts;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.infernalstudios.questlog.util.texture.Blittable;
import org.infernalstudios.questlog.util.texture.Texture;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractToast
implements Toast {
    private boolean playedSound = false;

    protected abstract Component getTitle();

    protected abstract Component getDescription();

    @Nullable
    protected abstract Blittable getIcon();

    @Nullable
    protected SoundInstance getSound() {
        return null;
    }

    protected Texture getBackground() {
        return new Texture(Toast.f_94893_, 160, 32, 0, 0, 256, 256);
    }

    protected int titleColor() {
        return -65281;
    }

    protected int descriptionColor() {
        return -1;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Toast.Visibility m_7172_(@NotNull GuiGraphics ps, ToastComponent toastComponent, long time) {
        this.getBackground().blit(ps, -13, -9);
        Font font = toastComponent.m_94929_().f_91062_;
        List list = font.m_92923_((FormattedText)this.getDescription(), 125);
        int titleColor = this.titleColor();
        int descriptionColor = this.descriptionColor();
        if (list.size() == 1) {
            ps.m_280614_(font, this.getTitle(), 30, 7, titleColor | 0xFF000000, false);
            ps.m_280649_(font, (FormattedCharSequence)list.get(0), 30, 18, descriptionColor | 0xFF000000, false);
        } else if (time < 1500L) {
            opacity = Mth.m_14143_((float)(Mth.m_14036_((float)((float)(1500L - time) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
            ps.m_280614_(font, this.getTitle(), 30, 11, titleColor | opacity, false);
        } else {
            opacity = Mth.m_14143_((float)(Mth.m_14036_((float)((float)(time - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
            int lineHeight = this.m_94899_() / 2 - list.size() * 9 / 2;
            for (FormattedCharSequence formattedcharsequence : list) {
                ps.m_280649_(font, formattedcharsequence, 30, lineHeight, descriptionColor | opacity, false);
                lineHeight += 9;
            }
        }
        if (this.getIcon() != null) {
            this.getIcon().blit(ps, 8, 8);
        }
        if (!this.playedSound && time > 0L) {
            this.playedSound = true;
            SoundInstance sound = this.getSound();
            if (sound != null) {
                toastComponent.m_94929_().m_91106_().m_120367_(sound);
            }
        }
        return time >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

