/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.client.gui.components;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import org.infernalstudios.questlog.client.gui.QuestlogGuiSet;
import org.infernalstudios.questlog.util.ScrollbarTexture;
import org.jetbrains.annotations.NotNull;

public class ScrollableComponent
implements Renderable,
NarratableEntry,
GuiEventListener {
    public final int width;
    public final int height;
    private final Scrollable scrollable;
    private final int left;
    private final int right;
    private final int top;
    private final int bottom;
    private final ScrollbarTexture scrollbar;
    private double scrollAmount;
    private boolean scrolling;

    public ScrollableComponent(int x, int y, int width, int height, Scrollable scrollable) {
        this(x, y, width, height, scrollable, QuestlogGuiSet.DEFAULT.scrollbar);
    }

    public ScrollableComponent(int x, int y, int width, int height, Scrollable scrollable, ScrollbarTexture scrollbar) {
        this.width = width;
        this.height = height;
        this.left = x;
        this.right = x + width;
        this.top = y;
        this.bottom = y + height;
        this.scrollable = scrollable;
        this.scrollAmount = 0.0;
        this.scrollbar = scrollbar;
        this.scrollable.setScrollableComponent(this);
    }

    public double getXOffset() {
        return this.left;
    }

    public double getYOffset() {
        return (double)this.top - this.getScrollAmount();
    }

    protected int getScrollbarX() {
        return this.left + this.width - 14;
    }

    protected int getScrollbarY() {
        return (int)this.getScrollAmount() * (this.bottom - this.top - (this.scrollbar.bar().height() - 24)) / this.getMaxScroll() + this.top;
    }

    public int getScrollbarWidth() {
        return 5;
    }

    public boolean canScroll() {
        return this.getMaxScroll() > 0;
    }

    public void m_88315_(@NotNull GuiGraphics ps, int mouseX, int mouseY, float partialTicks) {
        this.scrollable.renderBackground(ps, mouseX - this.left, (int)((double)(mouseY - this.top) + this.getScrollAmount()), partialTicks);
        ps.m_280588_(this.left, this.top, this.left + this.width, this.top + this.height);
        this.scrollable.m_88315_(ps, mouseX - this.left, (int)((double)(mouseY - this.top) + this.getScrollAmount()), partialTicks);
        ps.m_280618_();
        if (this.canScroll()) {
            this.renderScrollbar(ps, mouseX, mouseY);
        }
    }

    private void renderScrollbarBackground(GuiGraphics ps) {
        int bgHeight = this.scrollbar.backgroundTopCap().height() + this.scrollbar.backgroundBottomCap().height();
        bgHeight += (int)(Math.floor((double)this.height - (double)bgHeight / (double)this.scrollbar.background().height()) * (double)this.scrollbar.background().height());
        int bgY = this.top;
        this.scrollbar.backgroundTopCap().blit(ps, this.getScrollbarX() + (this.scrollbar.bar().width() - this.scrollbar.backgroundTopCap().width()) / 2, bgY);
        bgY += this.scrollbar.backgroundTopCap().height();
        while (bgY < bgHeight + this.top - this.scrollbar.backgroundBottomCap().height()) {
            this.scrollbar.background().blit(ps, this.getScrollbarX() + (this.scrollbar.bar().width() - this.scrollbar.background().width()) / 2, bgY);
            bgY += this.scrollbar.background().height();
        }
        this.scrollbar.backgroundBottomCap().blit(ps, this.getScrollbarX() + (this.scrollbar.bar().width() - this.scrollbar.backgroundBottomCap().width()) / 2, bgY);
    }

    private void renderScrollbar(GuiGraphics ps, int mouseX, int mouseY) {
        this.renderScrollbarBackground(ps);
        int x = this.getScrollbarX();
        int y = this.getScrollbarY();
        if (y < this.top) {
            y = this.top;
        }
        if (y > this.bottom - (this.scrollbar.bar().height() - 24)) {
            y = this.bottom - (this.scrollbar.bar().height() - 24);
        }
        this.scrollbar.bar().blit(ps, x, y - 12);
    }

    private double getScrollAmount() {
        return this.scrollAmount;
    }

    private void setScrollAmount(double amount) {
        if (amount < 0.0) {
            amount = 0.0;
        } else if (amount > (double)this.getMaxScroll()) {
            amount = this.getMaxScroll();
        }
        this.scrollAmount = amount;
    }

    private int getMaxScroll() {
        return Math.max(0, this.scrollable.getHeight() - (this.bottom - this.top));
    }

    private void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && (double)this.getScrollbarX() + 10.0 <= mouseX && mouseX < (double)(this.getScrollbarX() + this.scrollbar.bar().width() - 10);
    }

    public boolean m_5953_(double x, double y) {
        return y >= (double)this.top && y <= (double)this.bottom && x >= (double)this.left && x <= (double)this.right;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        if (this.scrolling) {
            return true;
        }
        Scrollable scrollable = this.scrollable;
        if (scrollable instanceof GuiEventListener) {
            GuiEventListener listener = (GuiEventListener)scrollable;
            return listener.m_6375_(mouseX - (double)this.left, mouseY - (double)this.top + this.getScrollAmount(), button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 && this.scrolling) {
            this.setScrollAmount((double)this.getMaxScroll() * (mouseY - (double)this.top - (double)((this.scrollbar.bar().height() - 24) / 2)) / (double)(this.bottom - this.top - (this.scrollbar.bar().height() - 24)));
            return true;
        }
        Scrollable scrollable = this.scrollable;
        if (scrollable instanceof GuiEventListener) {
            GuiEventListener listener = (GuiEventListener)scrollable;
            return listener.m_7979_(mouseX - (double)this.left, mouseY - (double)this.top + this.getScrollAmount(), button, deltaX, deltaY);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
            return true;
        }
        Scrollable scrollable = this.scrollable;
        if (scrollable instanceof GuiEventListener) {
            GuiEventListener listener = (GuiEventListener)scrollable;
            return listener.m_6348_(mouseX - (double)this.left, mouseY - (double)this.top + this.getScrollAmount(), button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.canScroll()) {
            this.setScrollAmount(this.getScrollAmount() - amount * 10.0);
            return true;
        }
        Scrollable scrollable = this.scrollable;
        if (scrollable instanceof GuiEventListener) {
            GuiEventListener listener = (GuiEventListener)scrollable;
            return listener.m_6050_(mouseX - (double)this.left, mouseY - (double)this.top + this.getScrollAmount(), amount);
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void m_94757_(double mouseX, double mouseY) {
        Scrollable scrollable = this.scrollable;
        if (scrollable instanceof GuiEventListener) {
            GuiEventListener listener = (GuiEventListener)scrollable;
            listener.m_94757_(mouseX - (double)this.left, mouseY - (double)this.top + this.getScrollAmount());
        }
        super.m_94757_(mouseX, mouseY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        Scrollable scrollable = this.scrollable;
        if (scrollable instanceof GuiEventListener) {
            GuiEventListener listener = (GuiEventListener)scrollable;
            return listener.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        Scrollable scrollable = this.scrollable;
        if (scrollable instanceof GuiEventListener) {
            GuiEventListener listener = (GuiEventListener)scrollable;
            return listener.m_7920_(keyCode, scanCode, modifiers);
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char character, int keyCode) {
        Scrollable scrollable = this.scrollable;
        if (scrollable instanceof GuiEventListener) {
            GuiEventListener listener = (GuiEventListener)scrollable;
            return listener.m_5534_(character, keyCode);
        }
        return super.m_5534_(character, keyCode);
    }

    public boolean m_93696_() {
        GuiEventListener listener;
        Scrollable scrollable = this.scrollable;
        return scrollable instanceof GuiEventListener && (listener = (GuiEventListener)scrollable).m_93696_();
    }

    public void m_93692_(boolean shouldChangeFocus) {
        Scrollable scrollable = this.scrollable;
        if (scrollable instanceof GuiEventListener) {
            GuiEventListener listener = (GuiEventListener)scrollable;
            listener.m_93692_(shouldChangeFocus);
        }
    }

    @NotNull
    public NarratableEntry.NarrationPriority m_142684_() {
        Scrollable scrollable = this.scrollable;
        if (scrollable instanceof NarratableEntry) {
            NarratableEntry entry = (NarratableEntry)scrollable;
            return entry.m_142684_();
        }
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(@NotNull NarrationElementOutput output) {
        Scrollable scrollable = this.scrollable;
        if (scrollable instanceof NarratableEntry) {
            NarratableEntry entry = (NarratableEntry)scrollable;
            entry.m_142291_(output);
        }
    }

    public static interface Scrollable
    extends Renderable {
        public int getHeight();

        default public void setScrollableComponent(ScrollableComponent component) {
        }

        default public void renderBackground(GuiGraphics poseStack, int mouseX, int mouseY, float partialTicks) {
        }
    }
}

