/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog.client.gui.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.infernalstudios.questlog.client.gui.QuestlogGuiSet;
import org.infernalstudios.questlog.client.gui.components.ScrollableComponent;
import org.infernalstudios.questlog.core.quests.Quest;
import org.jetbrains.annotations.NotNull;

public class QuestList
extends AbstractContainerEventHandler
implements ScrollableComponent.Scrollable {
    protected final Minecraft minecraft;
    protected final int itemHeight;
    private final Consumer<Quest> onSelect;
    private final List<QuestListEntry> children = new ArrayList<QuestListEntry>();
    @Nullable
    private QuestListEntry hovered;
    @Nullable
    private ScrollableComponent scroller;

    public QuestList(Minecraft minecraft, List<Quest> quests, Consumer<Quest> onSelect) {
        this.minecraft = minecraft;
        this.itemHeight = 28;
        this.onSelect = onSelect;
        for (Quest quest : quests) {
            this.children.add(new QuestListEntry(this, quest));
        }
        this.children.sort((a, b) -> {
            Quest qa = a.quest;
            Quest qb = b.quest;
            if (qa.isCompleted() && !qb.isCompleted()) {
                return 1;
            }
            if (!qa.isCompleted() && qb.isCompleted()) {
                return -1;
            }
            if (!qa.isRewarded() && qb.isRewarded()) {
                return -1;
            }
            if (qa.isRewarded() && !qb.isRewarded()) {
                return 1;
            }
            return 0;
        });
    }

    public int getWidth() {
        return this.scroller != null ? this.scroller.width : 0;
    }

    @Override
    public int getHeight() {
        return this.children.size() * this.itemHeight;
    }

    @Override
    public void setScrollableComponent(ScrollableComponent component) {
        this.scroller = component;
    }

    private boolean isRenderingScrollbar() {
        return this.scroller != null && this.scroller.canScroll();
    }

    public int getRowWidth() {
        return this.getWidth();
    }

    public int getRowLeft() {
        return this.getWidth() / 2 - this.getRowWidth() / 2 + 2;
    }

    public int getRowRight() {
        return this.getRowLeft() + this.getRowWidth();
    }

    protected int getRowTop(int index) {
        return index * this.itemHeight;
    }

    private int getRowBottom(int index) {
        return this.getRowTop(index) + this.itemHeight;
    }

    @Nullable
    public QuestListEntry getFocused() {
        return (QuestListEntry)super.m_7222_();
    }

    protected QuestListEntry getEntry(int index) {
        return this.children.get(index);
    }

    protected int getItemCount() {
        return this.children.size();
    }

    @Nullable
    protected final QuestListEntry getEntryAtPosition(double x, double y) {
        int left = this.getRowLeft();
        int right = this.getRowRight() - (this.isRenderingScrollbar() ? Objects.requireNonNull(this.scroller).getScrollbarWidth() : 0);
        if ((double)right < x || x < (double)left) {
            return null;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            int top = this.getRowTop(i);
            int bottom = this.getRowBottom(i);
            if (!(y >= (double)top) || !(y <= (double)bottom)) continue;
            return this.children.get(i);
        }
        return null;
    }

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight;
    }

    public void m_88315_(@NotNull GuiGraphics ps, int mouseX, int mouseY, float partialTicks) {
        this.hovered = this.m_5953_(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        this.renderList(ps, mouseX, mouseY, partialTicks);
    }

    protected void renderList(GuiGraphics ps, int mouseX, int mouseY, float partialTicks) {
        int rowLeft = this.getRowLeft();
        int rowWidth = this.getRowWidth();
        for (int itemIndex = 0; itemIndex < this.getItemCount(); ++itemIndex) {
            this.renderItem(ps, mouseX, mouseY, partialTicks, itemIndex, rowLeft, this.getRowTop(itemIndex), rowWidth, this.itemHeight);
        }
    }

    protected void renderItem(GuiGraphics ps, int mouseX, int mouseY, float partialTicks, int itemIndex, int rowLeft, int rowTop, int rowWidth, int itemHeightAdjusted) {
        QuestListEntry entry = this.getEntry(itemIndex);
        entry.render(ps, itemIndex, rowTop, rowLeft, rowWidth, itemHeightAdjusted, mouseX, mouseY, Objects.equals(this.hovered, entry), partialTicks);
    }

    public boolean m_5953_(double x, double y) {
        return y >= 0.0 && y <= (double)this.getHeight() && x >= 0.0 && x <= (double)this.getWidth();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        QuestListEntry e = this.getEntryAtPosition(mouseX, mouseY);
        if (e != null) {
            return e.m_6375_(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.getFocused() != null && this.getFocused().m_6348_(mouseX, mouseY, button);
    }

    @NotNull
    public List<QuestListEntry> m_6702_() {
        return this.children;
    }

    public static class QuestListEntry
    implements GuiEventListener {
        private final QuestList list;
        private final Quest quest;

        protected QuestListEntry(QuestList list, Quest quest) {
            this.list = list;
            this.quest = quest;
        }

        public void render(GuiGraphics ps, int color, int yPosition, int xPosition, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTicks) {
            Font font = Minecraft.m_91087_().f_91062_;
            int dx = 5;
            if (this.quest.getDisplay().getIcon() != null) {
                this.quest.getDisplay().getIcon().blit(ps, xPosition + dx + (int)Objects.requireNonNull(this.list.scroller).getXOffset(), yPosition + 5 + (int)this.list.scroller.getYOffset());
                dx += 20;
            }
            if (this.quest.isCompleted()) {
                Objects.requireNonNull(font);
                int linesHeight = 9 * 2;
                int dy = (height - linesHeight) / 2;
                ps.m_280614_(font, this.quest.getDisplay().getTitle(), xPosition + (int)Objects.requireNonNull(this.list.scroller).getXOffset() + dx, yPosition + dy + (int)this.list.scroller.getYOffset(), 4995099, false);
                if (!this.quest.isRewarded()) {
                    MutableComponent mutableComponent = Component.m_237115_((String)"questlog.quest.uncollected");
                    int n = xPosition + (int)this.list.scroller.getXOffset() + dx;
                    int n2 = yPosition + (int)this.list.scroller.getYOffset() + dy;
                    Objects.requireNonNull(font);
                    ps.m_280614_(font, (Component)mutableComponent, n, n2 + 9, 10380850, false);
                } else {
                    MutableComponent mutableComponent = Component.m_237115_((String)"questlog.quest.completed");
                    int n = xPosition + (int)this.list.scroller.getXOffset() + dx;
                    int n3 = yPosition + (int)this.list.scroller.getYOffset() + dy;
                    Objects.requireNonNull(font);
                    ps.m_280614_(font, (Component)mutableComponent, n, n3 + 9, 5414482, false);
                }
            } else {
                int n = yPosition + (int)Objects.requireNonNull(this.list.scroller).getYOffset();
                Objects.requireNonNull(font);
                int y = n + (height - 9) / 2;
                ps.m_280614_(font, this.quest.getDisplay().getTitle(), xPosition + (int)this.list.scroller.getXOffset() + dx, y, 4995099, false);
            }
            if (this.hasNext()) {
                QuestlogGuiSet.DEFAULT.bigHR.blit(ps, (int)this.list.scroller.getXOffset() - 2, yPosition + (int)this.list.scroller.getYOffset() + height - 5);
            }
            if (isHovered) {
                ps.m_280509_(xPosition + (int)this.list.scroller.getXOffset() - 2, yPosition + (int)this.list.scroller.getYOffset(), xPosition + (int)this.list.scroller.getXOffset() + width - (this.list.isRenderingScrollbar() ? this.list.scroller.getScrollbarWidth() * 2 : 0), yPosition + (int)this.list.scroller.getYOffset() + height, -2130706433);
            }
        }

        private boolean hasNext() {
            return this.list.children.indexOf(this) < this.list.children.size() - 1;
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return Objects.equals(this.list.getEntryAtPosition(mouseX, mouseY), this);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.m_5953_(mouseX, mouseY) && button == 0) {
                this.list.onSelect.accept(this.quest);
                return true;
            }
            return false;
        }

        public boolean m_93696_() {
            return false;
        }

        public void m_93692_(boolean var1) {
        }
    }
}

