/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.questlog;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import org.infernalstudios.questlog.Questlog;
import org.infernalstudios.questlog.QuestlogClient;
import org.infernalstudios.questlog.client.gui.components.toasts.QuestAddedToast;
import org.infernalstudios.questlog.client.gui.components.toasts.QuestCompletedToast;
import org.infernalstudios.questlog.client.gui.screen.QuestDetails;
import org.infernalstudios.questlog.client.gui.screen.QuestlogScreen;
import org.infernalstudios.questlog.core.quests.Quest;
import org.infernalstudios.questlog.core.quests.rewards.Reward;
import org.infernalstudios.questlog.event.events.QuestEvent;
import org.infernalstudios.questlog.network.packet.QuestDefinitionPacket;

public class QuestlogClientEvents {
    public static void onClientTick() {
        LocalPlayer player;
        if (QuestToastState.tickDelayForCheck >= 0) {
            --QuestToastState.tickDelayForCheck;
        }
        if (QuestToastState.tickDelayForCheck == 0) {
            QuestlogClientEvents.displayQueuedPopups();
            QuestlogClientEvents.displayQueuedToasts();
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (QuestlogClient.OPEN_SCREEN_KEY.m_90859_() && minecraft.m_91302_() && (player = minecraft.f_91074_) != null) {
            minecraft.m_91152_((Screen)new QuestlogScreen(minecraft.f_91080_));
        }
    }

    public static void onClientPlayerLogin() {
        QuestlogClient.getLocal();
        QuestDefinitionPacket.handleDeferred();
    }

    public static void onClientPlayerLogout() {
        QuestlogClient.destroyLocal();
        Questlog.EVENTS.removeAllListeners();
    }

    public static void onQuestTriggered(QuestEvent.Triggered event) {
        if (event.quest.getDisplay().shouldPopup() && Minecraft.m_91087_().m_91091_() && (Minecraft.m_91087_().m_91092_() == null || !Minecraft.m_91087_().m_91092_().m_6992_())) {
            QuestToastState.resetCheckDelay();
            QuestToastState.queuedPopups.add(event.quest);
        } else if (event.quest.getDisplay().shouldToastOnTrigger()) {
            QuestToastState.resetCheckDelay();
            QuestToastState.addedToasts.add(new QuestAddedToast(event.quest.getDisplay()));
        }
        SoundEvent triggeredSound = event.quest.getDisplay().getTriggeredSound();
        if (triggeredSound != null) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)triggeredSound, (float)1.0f, (float)1.0f));
        }
    }

    public static void onQuestCompleted(QuestEvent.Completed event) {
        SoundEvent completedSound;
        if (event.quest.getDisplay().shouldToastOnComplete()) {
            QuestToastState.resetCheckDelay();
            QuestToastState.completedToasts.add(new QuestCompletedToast(event.quest.getDisplay()));
        }
        if ((completedSound = event.quest.getDisplay().getCompletedSound()) != null) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)completedSound, (float)1.0f, (float)1.0f));
        }
        for (Reward reward : event.quest.rewards) {
            SoundEvent sound;
            if (!reward.rewardsInstantly() || (sound = Objects.requireNonNull(reward.getDisplay()).getClaimSound()) == null) continue;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)sound, (float)1.0f, (float)1.0f));
        }
    }

    private static void displayQueuedPopups() {
        MenuAccess screen;
        if (QuestToastState.queuedPopups.isEmpty()) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ instanceof QuestDetails) {
            QuestToastState.resetCheckDelay();
            return;
        }
        Screen screen2 = Minecraft.m_91087_().f_91080_;
        if (screen2 instanceof MenuAccess && !(screen = (MenuAccess)screen2).m_6262_().m_142621_().m_41619_()) {
            return;
        }
        Quest quest = QuestToastState.queuedPopups.get(0);
        QuestToastState.queuedPopups.remove(quest);
        Minecraft.m_91087_().m_91152_((Screen)new QuestDetails(Minecraft.m_91087_().f_91080_, quest));
        SoundEvent sound = quest.getDisplay().getTriggeredSound();
        if (sound != null) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)sound, (float)1.0f, (float)1.0f));
        }
        QuestToastState.resetCheckDelay();
    }

    private static void displayQueuedToasts() {
        if (Minecraft.m_91087_().f_91080_ instanceof QuestDetails) {
            return;
        }
        ToastComponent toasts = Minecraft.m_91087_().m_91300_();
        if (!QuestToastState.completedToasts.isEmpty()) {
            for (QuestCompletedToast questCompletedToast : QuestToastState.completedToasts) {
                toasts.m_94922_((Toast)questCompletedToast);
            }
            QuestToastState.completedToasts.clear();
        }
        if (toasts.m_94926_(QuestCompletedToast.class, Toast.f_94894_) != null) {
            QuestToastState.resetCheckDelay();
            return;
        }
        if (!QuestToastState.addedToasts.isEmpty()) {
            for (QuestAddedToast questAddedToast : QuestToastState.addedToasts) {
                toasts.m_94922_((Toast)questAddedToast);
            }
            QuestToastState.addedToasts.clear();
        }
    }

    private static class QuestToastState {
        public static int tickDelayForCheck = -1;
        public static List<QuestAddedToast> addedToasts = new ArrayList<QuestAddedToast>();
        public static List<QuestCompletedToast> completedToasts = new ArrayList<QuestCompletedToast>();
        public static List<Quest> queuedPopups = new ArrayList<Quest>();

        private QuestToastState() {
        }

        public static void resetCheckDelay() {
            tickDelayForCheck = 10;
        }
    }
}

