/*
 * Decompiled with CFR 0.152.
 */
package com.weido.pretty_in_pink.registry;

import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.weido.pretty_in_pink.PrettyInPink;
import com.weido.pretty_in_pink.blocks.SteelBlock;
import com.weido.pretty_in_pink.blocks.SteelDirectionalBlock;
import com.weido.pretty_in_pink.blocks.SteelHullBlock;
import com.weido.pretty_in_pink.data.BuilderTransformers;
import com.weido.pretty_in_pink.registry.PNPCreativeModeTabs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;

public class PNPBlocks {
    private static final CreateRegistrate REGISTRATE = PrettyInPink.registrate();
    public static final Map<String, BlockEntry<SteelBlock>> STEEL_BLOCKS = new HashMap<String, BlockEntry<SteelBlock>>();
    public static final Map<String, BlockEntry<SteelDirectionalBlock>> CORRUGATED_STEEL_BLOCKS = new HashMap<String, BlockEntry<SteelDirectionalBlock>>();
    public static final Map<String, BlockEntry<SteelDirectionalBlock>> STEEL_TANK_BLOCKS = new HashMap<String, BlockEntry<SteelDirectionalBlock>>();
    public static final Map<String, BlockEntry<SteelDirectionalBlock>> STEEL_BOILER_BLOCKS = new HashMap<String, BlockEntry<SteelDirectionalBlock>>();
    public static final Map<String, BlockEntry<SteelDirectionalBlock>> BRUSHED_STEEL_BLOCKS = new HashMap<String, BlockEntry<SteelDirectionalBlock>>();
    public static final Map<String, BlockEntry<SteelHullBlock>> STEEL_HULL_BLOCKS = new HashMap<String, BlockEntry<SteelHullBlock>>();
    public static final Map<String, BlockEntry<SteelHullBlock>> BRUSHED_STEEL_HULL_BLOCKS = new HashMap<String, BlockEntry<SteelHullBlock>>();
    public static MutableComponent TAB_TITLE = PNPBlocks.add("itemGroup", "base", "Pretty In Pink \ud83d\uddff");
    static final List<DyeColor> COLORS;

    private static void registerBlocks(String colorName, MapColor mapColor, String type) {
        BlockEntry entry = ((BlockBuilder)((BlockBuilder)REGISTRATE.block(colorName + "_" + type, SteelDirectionalBlock::new).transform(BuilderTransformers.sharedBlock())).properties(p -> p.m_284180_(mapColor)).blockstate((c, p) -> p.directionalBlock((Block)c.get(), (ModelFile)p.models().getExistingFile(p.modLoc("block/" + colorName + "/" + type)))).recipe((c, p) -> {
            p.stonecutting(DataIngredient.items((ItemLike)Items.f_42416_.m_5456_(), (ItemLike[])new Item[0]), RecipeCategory.DECORATIONS, (Supplier)c, 2);
            p.stonecutting(DataIngredient.items((NonNullSupplier)c, (NonNullSupplier[])new NonNullSupplier[0]), RecipeCategory.DECORATIONS, () -> Items.f_42749_, 2);
            if (!colorName.equals("white")) {
                BlockEntry<SteelDirectionalBlock> whiteEntry;
                switch (type) {
                    case "corrugated_steel": {
                        BlockEntry<SteelDirectionalBlock> blockEntry = CORRUGATED_STEEL_BLOCKS.get("white");
                        break;
                    }
                    case "steel_tank": {
                        BlockEntry<SteelDirectionalBlock> blockEntry = STEEL_TANK_BLOCKS.get("white");
                        break;
                    }
                    case "brushed_steel": {
                        BlockEntry<SteelDirectionalBlock> blockEntry = BRUSHED_STEEL_BLOCKS.get("white");
                        break;
                    }
                    case "steel_boiler": {
                        BlockEntry<SteelDirectionalBlock> blockEntry = STEEL_BOILER_BLOCKS.get("white");
                        break;
                    }
                    default: {
                        BlockEntry<SteelDirectionalBlock> blockEntry = whiteEntry = null;
                    }
                }
                if (whiteEntry != null) {
                    p.stonecutting(DataIngredient.items((NonNullSupplier)c, (NonNullSupplier[])new NonNullSupplier[0]), RecipeCategory.DECORATIONS, whiteEntry, 1);
                }
            }
        }).lang(PNPBlocks.capitalize(colorName) + " " + PNPBlocks.capitalize(type)).item().model((c, p) -> p.withExistingParent(c.getName(), p.modLoc("block/" + colorName + "/" + type))).build()).register();
        switch (type) {
            case "corrugated_steel": {
                CORRUGATED_STEEL_BLOCKS.put(colorName, (BlockEntry<SteelDirectionalBlock>)entry);
                break;
            }
            case "steel_tank": {
                STEEL_TANK_BLOCKS.put(colorName, (BlockEntry<SteelDirectionalBlock>)entry);
                break;
            }
            case "brushed_steel": {
                BRUSHED_STEEL_BLOCKS.put(colorName, (BlockEntry<SteelDirectionalBlock>)entry);
                break;
            }
            case "steel_boiler": {
                STEEL_BOILER_BLOCKS.put(colorName, (BlockEntry<SteelDirectionalBlock>)entry);
            }
        }
    }

    private static void registerHulls(String colorName, MapColor mapColor, String type) {
        BlockEntry entry = ((BlockBuilder)((BlockBuilder)REGISTRATE.block(colorName + "_" + type, SteelHullBlock::new).transform(BuilderTransformers.sharedBlock())).properties(p -> p.m_284180_(mapColor)).blockstate((c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(state -> {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            boolean raised = (Boolean)state.m_61143_((Property)SteelHullBlock.RAISED);
            Object modelName = raised ? type + "_raised" : type;
            int y = switch (facing) {
                case Direction.NORTH -> 90;
                case Direction.EAST -> 180;
                case Direction.SOUTH -> 270;
                default -> 0;
            };
            return ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/" + colorName + "/" + (String)modelName))).rotationX(0).rotationY(y).build();
        })).recipe((c, p) -> {
            p.stonecutting(DataIngredient.items((ItemLike)Items.f_42416_.m_5456_(), (ItemLike[])new Item[0]), RecipeCategory.DECORATIONS, (Supplier)c, 2);
            p.stonecutting(DataIngredient.items((NonNullSupplier)c, (NonNullSupplier[])new NonNullSupplier[0]), RecipeCategory.DECORATIONS, () -> Items.f_42749_, 2);
            if (!colorName.equals("white")) {
                BlockEntry<SteelHullBlock> whiteEntry;
                switch (type) {
                    case "steel_hull": {
                        BlockEntry<SteelHullBlock> blockEntry = STEEL_HULL_BLOCKS.get("white");
                        break;
                    }
                    case "brushed_steel_hull": {
                        BlockEntry<SteelHullBlock> blockEntry = BRUSHED_STEEL_HULL_BLOCKS.get("white");
                        break;
                    }
                    default: {
                        BlockEntry<SteelHullBlock> blockEntry = whiteEntry = null;
                    }
                }
                if (whiteEntry != null) {
                    p.stonecutting(DataIngredient.items((NonNullSupplier)c, (NonNullSupplier[])new NonNullSupplier[0]), RecipeCategory.DECORATIONS, whiteEntry, 1);
                }
            }
        }).lang(PNPBlocks.capitalize(colorName) + " " + PNPBlocks.capitalize(type)).item().model((c, p) -> p.withExistingParent(c.getName(), p.modLoc("block/" + colorName + "/" + type))).build()).register();
        switch (type) {
            case "steel_hull": {
                STEEL_HULL_BLOCKS.put(colorName, (BlockEntry<SteelHullBlock>)entry);
                break;
            }
            case "brushed_steel_hull": {
                BRUSHED_STEEL_HULL_BLOCKS.put(colorName, (BlockEntry<SteelHullBlock>)entry);
            }
        }
    }

    public static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        str = str.replace("_", " ");
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static MutableComponent add(String type, String key, String lang) {
        return REGISTRATE.addLang(type, PrettyInPink.asResource(key), lang);
    }

    public static void register() {
    }

    static {
        REGISTRATE.setCreativeTab(PNPCreativeModeTabs.BASE_CREATIVE_TAB);
        COLORS = List.of(new DyeColor("pink", MapColor.f_283765_), new DyeColor("magenta", MapColor.f_283931_), new DyeColor("maroon", MapColor.f_283913_), new DyeColor("red", MapColor.f_283913_), new DyeColor("orange", MapColor.f_283750_), new DyeColor("vermilion", MapColor.f_283750_), new DyeColor("yellow", MapColor.f_283832_), new DyeColor("cyan", MapColor.f_283772_), new DyeColor("pine_green", MapColor.f_283784_), new DyeColor("olive", MapColor.f_283784_), new DyeColor("green", MapColor.f_283784_), new DyeColor("lime", MapColor.f_283916_), new DyeColor("chartreuse", MapColor.f_283916_), new DyeColor("sea_green", MapColor.f_283772_), new DyeColor("turquoise", MapColor.f_283772_), new DyeColor("light_blue", MapColor.f_283869_), new DyeColor("blue", MapColor.f_283743_), new DyeColor("royal_blue", MapColor.f_283743_), new DyeColor("purple", MapColor.f_283889_), new DyeColor("brown", MapColor.f_283748_), new DyeColor("white", MapColor.f_283779_), new DyeColor("light_gray", MapColor.f_283779_), new DyeColor("gray", MapColor.f_283818_), new DyeColor("black", MapColor.f_283927_));
        for (DyeColor color : COLORS) {
            String colorName = color.name();
            MapColor mapColor = color.color();
            BlockEntry entry = ((BlockBuilder)((BlockBuilder)REGISTRATE.block(colorName + "_steel_block", SteelBlock::new).transform(BuilderTransformers.sharedBlock())).properties(p -> p.m_284180_(mapColor)).blockstate((c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)p.models().getExistingFile(p.modLoc("block/" + colorName + "/steel_block")))).recipe((c, p) -> {
                BlockEntry<SteelBlock> whiteEntry;
                p.stonecutting(DataIngredient.items((ItemLike)Items.f_42416_.m_5456_(), (ItemLike[])new Item[0]), RecipeCategory.DECORATIONS, (Supplier)c, 2);
                p.stonecutting(DataIngredient.items((NonNullSupplier)c, (NonNullSupplier[])new NonNullSupplier[0]), RecipeCategory.DECORATIONS, () -> Items.f_42749_, 2);
                if (!colorName.equals("white") && (whiteEntry = STEEL_BLOCKS.get("white")) != null) {
                    p.stonecutting(DataIngredient.items((NonNullSupplier)c, (NonNullSupplier[])new NonNullSupplier[0]), RecipeCategory.DECORATIONS, whiteEntry, 1);
                }
            }).lang(PNPBlocks.capitalize(colorName) + " " + PNPBlocks.capitalize("steel_block")).item().model((c, p) -> p.withExistingParent(c.getName(), p.modLoc("block/" + colorName + "/steel_block"))).build()).register();
            PNPBlocks.registerBlocks(colorName, mapColor, "corrugated_steel");
            PNPBlocks.registerBlocks(colorName, mapColor, "steel_tank");
            PNPBlocks.registerBlocks(colorName, mapColor, "brushed_steel");
            PNPBlocks.registerBlocks(colorName, mapColor, "steel_boiler");
            PNPBlocks.registerHulls(colorName, mapColor, "steel_hull");
            PNPBlocks.registerHulls(colorName, mapColor, "brushed_steel_hull");
            STEEL_BLOCKS.put(colorName, (BlockEntry<SteelBlock>)entry);
        }
    }

    record DyeColor(String name, MapColor color) {
    }
}

