/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.pipes.generic.subtypes;

import com.finchy.pipeorgans.content.pipes.generic.GenericExtensionBlock;
import com.finchy.pipeorgans.content.pipes.generic.GenericPipeBlock;
import com.finchy.pipeorgans.content.pipes.generic.GenericWhistleProperties;
import com.finchy.pipeorgans.content.pipes.generic.subtypes.QuadrupleExtensionBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class QuadruplePipeBlock
extends GenericPipeBlock {
    public QuadruplePipeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.extensionsPerBlock = 4;
    }

    @Override
    public void incrementSize(LevelAccessor pLevel, BlockPos pPos, boolean playSound) {
        BlockState base = pLevel.m_8055_(pPos);
        if (!base.m_61138_((Property)SIZE)) {
            return;
        }
        GenericWhistleProperties.WhistleSize size = (GenericWhistleProperties.WhistleSize)((Object)base.m_61143_((Property)SIZE));
        SoundType soundtype = base.m_60827_();
        BlockPos currentPos = pPos.m_7494_();
        Direction facing = (Direction)base.m_61143_((Property)FACING);
        float pVolume = (soundtype.m_56773_() + 1.0f) / 2.0f;
        SoundEvent growSound = (SoundEvent)SoundEvents.f_12218_.get();
        SoundEvent hitSound = soundtype.m_56778_();
        for (int i = 1; i <= 12; i += 4) {
            BlockState blockState = pLevel.m_8055_(currentPos);
            if (blockState.m_60734_() instanceof QuadrupleExtensionBlock) {
                if (blockState.m_61143_((Property)QuadrupleExtensionBlock.SHAPE) != GenericWhistleProperties.QuadrupleExtensionShape.QUAD && blockState.m_61143_((Property)QuadrupleExtensionBlock.SHAPE) != GenericWhistleProperties.QuadrupleExtensionShape.QUAD_CONNECTED) {
                    pLevel.m_7731_(currentPos, (BlockState)((BlockState)blockState.m_61122_((Property)QuadrupleExtensionBlock.SHAPE)).m_61124_((Property)FACING, (Comparable)facing), 3);
                    if (playSound) {
                        switch ((GenericWhistleProperties.QuadrupleExtensionShape)((Object)blockState.m_61143_((Property)QuadrupleExtensionBlock.SHAPE))) {
                            case SINGLE: {
                                ++i;
                                break;
                            }
                            case DOUBLE: {
                                i += 2;
                                break;
                            }
                            case TRIPLE: {
                                i += 3;
                            }
                        }
                        float pPitch = (float)Math.pow(2.0, (double)(-i) / 12.0);
                        pLevel.m_5594_(null, currentPos, growSound, SoundSource.BLOCKS, pVolume / 4.0f, pPitch);
                        pLevel.m_5594_(null, currentPos, hitSound, SoundSource.BLOCKS, pVolume, pPitch);
                    }
                    return;
                }
            } else {
                if (!blockState.m_247087_()) {
                    return;
                }
                pLevel.m_7731_(currentPos, (BlockState)((BlockState)((GenericExtensionBlock)((Object)this.extensionBlock.get())).m_49966_().m_61124_((Property)SIZE, (Comparable)((Object)size))).m_61124_((Property)FACING, (Comparable)facing), 3);
                if (playSound) {
                    float pPitch = (float)Math.pow(2.0, (double)(-i) / 12.0);
                    pLevel.m_5594_(null, currentPos, growSound, SoundSource.BLOCKS, pVolume / 4.0f, pPitch);
                    pLevel.m_5594_(null, currentPos, hitSound, SoundSource.BLOCKS, pVolume, pPitch);
                }
                return;
            }
            currentPos = currentPos.m_7494_();
        }
    }
}

