/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics.foundation.mirror;

import com.cak.pattern_schematics.foundation.mirror.CloneSchematicOutlineRenderer;
import com.cak.pattern_schematics.foundation.mirror.PatternSchematicHotbarSlotOverlay;
import com.cak.pattern_schematics.foundation.mirror.PatternSchematicsToolSelectionScreen;
import com.cak.pattern_schematics.foundation.mirror.PatternSchematicsToolType;
import com.cak.pattern_schematics.foundation.util.Vec3iUtils;
import com.cak.pattern_schematics.registry.PatternSchematicsRegistry;
import com.cak.pattern_schematics.registry.PlatformPackets;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllKeys;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.schematics.SchematicItem;
import com.simibubi.create.content.schematics.client.SchematicHandler;
import com.simibubi.create.content.schematics.client.SchematicRenderer;
import com.simibubi.create.content.schematics.client.SchematicTransformation;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Vector;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.levelWrappers.SchematicLevel;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.catnip.outliner.AABBOutline;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public abstract class PatternSchematicHandler
extends SchematicHandler {
    protected String displayedSchematic;
    protected SchematicTransformation transformation;
    protected AABB bounds;
    protected boolean deployed;
    protected boolean active;
    protected PatternSchematicsToolType currentTool;
    protected static final int SYNC_DELAY = 10;
    protected int syncCooldown;
    protected int activeHotbarSlot;
    protected ItemStack activeSchematicItem;
    protected AABBOutline outline;
    protected AABBOutline greaterOutline;
    protected Vector<SchematicRenderer> renderers;
    protected PatternSchematicHotbarSlotOverlay overlay;
    protected PatternSchematicsToolSelectionScreen selectionScreen;
    protected Vec3i cloneScaleMin = new Vec3i(0, 0, 0);
    protected Vec3i cloneScaleMax = new Vec3i(0, 0, 0);
    protected Vec3i cloneOffset = new Vec3i(0, 0, 0);
    protected boolean isRenderingMain;
    protected boolean isRenderingMultiple;

    public PatternSchematicHandler() {
        this.renderers = new Vector(3);
        for (int i = 0; i < this.renderers.capacity(); ++i) {
            this.renderers.add(new SchematicRenderer());
        }
        this.overlay = new PatternSchematicHotbarSlotOverlay();
        this.currentTool = PatternSchematicsToolType.DEPLOY;
        this.selectionScreen = new PatternSchematicsToolSelectionScreen((List<PatternSchematicsToolType>)ImmutableList.of((Object)((Object)PatternSchematicsToolType.DEPLOY)), this::equip);
        this.transformation = new SchematicTransformation();
    }

    public void tick() {
        LocalPlayer player;
        ItemStack stack;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            if (this.active) {
                this.active = false;
                this.syncCooldown = 0;
                this.activeHotbarSlot = 0;
                this.activeSchematicItem = null;
                this.renderers.forEach(r -> r.setActive(false));
            }
            return;
        }
        if (this.activeSchematicItem != null && this.transformation != null) {
            this.transformation.tick();
        }
        if ((stack = this.findBlueprintInHand((Player)(player = mc.f_91074_))) == null) {
            this.active = false;
            this.syncCooldown = 0;
            if (this.activeSchematicItem != null && this.itemLost((Player)player)) {
                this.activeHotbarSlot = 0;
                this.activeSchematicItem = null;
                this.renderers.forEach(r -> r.setActive(false));
            }
            return;
        }
        if (!this.active || !stack.m_41783_().m_128461_("File").equals(this.displayedSchematic)) {
            this.init(player, stack);
        }
        if (!this.active) {
            return;
        }
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
        }
        if (this.syncCooldown == 1) {
            this.sync();
        }
        this.selectionScreen.update();
        this.currentTool.getTool().updateSelection();
    }

    private void init(LocalPlayer player, ItemStack stack) {
        this.loadSettings(stack);
        this.displayedSchematic = stack.m_41783_().m_128461_("File");
        this.active = true;
        if (this.deployed) {
            this.setupRenderer();
            PatternSchematicsToolType toolBefore = this.currentTool;
            this.selectionScreen = new PatternSchematicsToolSelectionScreen(PatternSchematicsToolType.getTools(player.m_7500_()), this::equip);
            if (toolBefore != null) {
                this.selectionScreen.setSelectedElement(toolBefore);
                this.equip(toolBefore);
            }
        } else {
            this.selectionScreen = new PatternSchematicsToolSelectionScreen((List<PatternSchematicsToolType>)ImmutableList.of((Object)((Object)PatternSchematicsToolType.DEPLOY)), this::equip);
        }
    }

    private void setupRenderer() {
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        StructureTemplate schematic = SchematicItem.loadSchematic((Level)clientWorld, (ItemStack)this.activeSchematicItem);
        Vec3i size = schematic.m_163801_();
        if (size.equals((Object)Vec3i.f_123288_)) {
            return;
        }
        SchematicLevel w = new SchematicLevel((Level)clientWorld);
        SchematicLevel wMirroredFB = new SchematicLevel((Level)clientWorld);
        SchematicLevel wMirroredLR = new SchematicLevel((Level)clientWorld);
        StructurePlaceSettings placementSettings = new StructurePlaceSettings();
        BlockPos pos = BlockPos.f_121853_;
        try {
            schematic.m_230328_((ServerLevelAccessor)w, pos, pos, placementSettings, w.m_213780_(), 2);
        }
        catch (Exception e) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)CreateLang.translate((String)"schematic.error", (Object[])new Object[0]).component(), false);
            Create.LOGGER.error("Failed to load Schematic for Previewing", (Throwable)e);
            return;
        }
        placementSettings.m_74377_(Mirror.FRONT_BACK);
        pos = BlockPos.f_121853_.m_122030_(size.m_123341_() - 1);
        schematic.m_230328_((ServerLevelAccessor)wMirroredFB, pos, pos, placementSettings, wMirroredFB.m_213780_(), 2);
        StructureTransform transform = new StructureTransform(placementSettings.m_74407_(), Direction.Axis.Y, Rotation.NONE, placementSettings.m_74401_());
        for (BlockEntity be : wMirroredFB.getRenderedBlockEntities()) {
            transform.apply(be);
        }
        this.fixControllerBlockEntities(wMirroredLR);
        placementSettings.m_74377_(Mirror.LEFT_RIGHT);
        pos = BlockPos.f_121853_.m_122020_(size.m_123343_() - 1);
        schematic.m_230328_((ServerLevelAccessor)wMirroredLR, pos, pos, placementSettings, wMirroredFB.m_213780_(), 2);
        transform = new StructureTransform(placementSettings.m_74407_(), Direction.Axis.Y, Rotation.NONE, placementSettings.m_74401_());
        for (BlockEntity be : wMirroredLR.getRenderedBlockEntities()) {
            transform.apply(be);
        }
        this.fixControllerBlockEntities(wMirroredLR);
        this.renderers.get(0).display(w);
        this.renderers.get(1).display(wMirroredFB);
        this.renderers.get(2).display(wMirroredLR);
    }

    private void fixControllerBlockEntities(SchematicLevel level) {
        for (BlockEntity blockEntity : level.getBlockEntities()) {
            if (!(blockEntity instanceof IMultiBlockEntityContainer)) continue;
            IMultiBlockEntityContainer multiBlockEntity = (IMultiBlockEntityContainer)blockEntity;
            BlockPos lastKnown = multiBlockEntity.getLastKnownPos();
            BlockPos current = blockEntity.m_58899_();
            if (lastKnown == null || current == null || multiBlockEntity.isController() || lastKnown.equals((Object)current)) continue;
            BlockPos newControllerPos = multiBlockEntity.getController().m_121955_((Vec3i)current.m_121996_((Vec3i)lastKnown));
            if (multiBlockEntity instanceof SmartBlockEntity) {
                SmartBlockEntity sbe = (SmartBlockEntity)multiBlockEntity;
                sbe.markVirtual();
            }
            multiBlockEntity.setController(newControllerPos);
        }
    }

    public void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera) {
        boolean present;
        boolean bl = present = this.activeSchematicItem != null;
        if (!this.active && !present) {
            return;
        }
        if (this.active) {
            this.isRenderingMultiple = false;
            this.isRenderingMain = true;
            ms.m_85836_();
            this.currentTool.getTool().renderTool(ms, buffer, camera);
            ms.m_85849_();
        }
        Vec3 schematicSize = new Vec3(this.bounds.m_82362_(), this.bounds.m_82376_(), this.bounds.m_82385_());
        this.isRenderingMultiple = !this.cloneScaleMax.equals((Object)this.cloneScaleMin);
        for (int x = this.cloneScaleMin.m_123341_(); x <= this.cloneScaleMax.m_123341_(); ++x) {
            for (int y = this.cloneScaleMin.m_123342_(); y <= this.cloneScaleMax.m_123342_(); ++y) {
                for (int z = this.cloneScaleMin.m_123343_(); z <= this.cloneScaleMax.m_123343_(); ++z) {
                    this.isRenderingMain = x == 0 && y == 0 && z == 0;
                    this.renderSchematic(this.transformation, new Vec3((double)x, (double)y, (double)z).m_82559_(schematicSize), ms, camera, buffer);
                }
            }
        }
        if (this.active && this.deployed) {
            ms.m_85836_();
            this.transformation.applyTransformations(ms, camera);
            CloneSchematicOutlineRenderer.renderCloneGridLines(ms, this, buffer);
            ms.m_85849_();
        }
    }

    protected void renderSchematic(SchematicTransformation transformation, Vec3 cloneOffset, PoseStack ms, Vec3 camera, SuperRenderTypeBuffer buffer) {
        ms.m_85836_();
        transformation.applyTransformations(ms, camera);
        ms.m_85837_(cloneOffset.m_7096_(), cloneOffset.m_7098_(), cloneOffset.m_7094_());
        if (!this.renderers.isEmpty()) {
            boolean fb;
            float pt = AnimationTickHolder.getPartialTicks();
            boolean lr = transformation.getScaleLR().getValue(pt) < 0.0f;
            boolean bl = fb = transformation.getScaleFB().getValue(pt) < 0.0f;
            if (lr && !fb) {
                this.renderers.get(2).render(ms, buffer);
            } else if (fb && !lr) {
                this.renderers.get(1).render(ms, buffer);
            } else {
                this.renderers.get(0).render(ms, buffer);
            }
        }
        if (this.active && this.isRenderingMain) {
            this.currentTool.getTool().renderOnSchematic(ms, buffer);
        }
        ms.m_85849_();
    }

    public void updateRenderers() {
        for (SchematicRenderer renderer : this.renderers) {
            renderer.update();
        }
    }

    public boolean onMouseInput(int button, boolean pressed) {
        if (!this.active) {
            return false;
        }
        if (!pressed || button != 1) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_.m_6144_()) {
            return false;
        }
        if (mc.f_91077_ instanceof BlockHitResult) {
            BlockHitResult blockRayTraceResult = (BlockHitResult)mc.f_91077_;
            BlockState clickedBlock = mc.f_91073_.m_8055_(blockRayTraceResult.m_82425_());
            if (AllBlocks.SCHEMATICANNON.has(clickedBlock)) {
                return false;
            }
            if (AllBlocks.DEPLOYER.has(clickedBlock)) {
                return false;
            }
        }
        return this.currentTool.getTool().handleRightClick();
    }

    public void onKeyInput(int key, boolean pressed) {
        if (!this.active) {
            return;
        }
        if (key != AllKeys.TOOL_MENU.getBoundCode()) {
            return;
        }
        if (pressed && !this.selectionScreen.focused) {
            this.selectionScreen.focused = true;
        }
        if (!pressed && this.selectionScreen.focused) {
            this.selectionScreen.focused = false;
            this.selectionScreen.m_7379_();
        }
    }

    public boolean mouseScrolled(double delta) {
        if (!this.active) {
            return false;
        }
        if (this.selectionScreen.focused) {
            this.selectionScreen.cycle((int)delta);
            return true;
        }
        if (AllKeys.ctrlDown()) {
            return this.currentTool.getTool().handleMouseWheel(delta);
        }
        return false;
    }

    private ItemStack findBlueprintInHand(Player player) {
        ItemStack stack = player.m_21205_();
        if (!PatternSchematicsRegistry.PATTERN_SCHEMATIC.isIn(stack)) {
            return null;
        }
        if (!stack.m_41782_()) {
            return null;
        }
        this.activeSchematicItem = stack;
        this.activeHotbarSlot = player.m_150109_().f_35977_;
        return stack;
    }

    private boolean itemLost(Player player) {
        for (int i = 0; i < Inventory.m_36059_(); ++i) {
            if (!player.m_150109_().m_8020_(i).equals(this.activeSchematicItem)) continue;
            return false;
        }
        return true;
    }

    public void markDirty() {
        this.syncCooldown = 10;
    }

    public void sync() {
        if (this.activeSchematicItem == null) {
            return;
        }
        PlatformPackets.sendPatternSchematicSyncPacket(this.activeHotbarSlot, this.transformation.toSettings(), this.transformation.getAnchor(), this.deployed, this.cloneScaleMin, this.cloneScaleMax, this.cloneOffset);
    }

    public void equip(PatternSchematicsToolType tool) {
        this.currentTool = tool;
        this.currentTool.getTool().init();
    }

    public void loadSettings(ItemStack blueprint) {
        CompoundTag tag = blueprint.m_41783_();
        assert (tag != null);
        BlockPos anchor = BlockPos.f_121853_;
        StructurePlaceSettings settings = SchematicItem.getSettings((ItemStack)blueprint);
        this.cloneScaleMin = Vec3iUtils.getVec3i("CloneScaleMin", tag);
        this.cloneScaleMax = Vec3iUtils.getVec3i("CloneScaleMax", tag);
        this.cloneOffset = Vec3iUtils.getVec3i("CloneOffset", tag);
        this.transformation = new SchematicTransformation();
        this.deployed = tag.m_128471_("Deployed");
        if (this.deployed) {
            anchor = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Anchor"));
        }
        Vec3i size = NBTHelper.readVec3i((ListTag)tag.m_128437_("Bounds", 3));
        this.bounds = new AABB(0.0, 0.0, 0.0, (double)size.m_123341_(), (double)size.m_123342_(), (double)size.m_123343_());
        this.outline = new AABBOutline(this.bounds);
        this.outline.getParams().colored(10847909).lineWidth(0.0f);
        this.greaterOutline = new AABBOutline(this.calculateGreaterOutlineBounds());
        this.greaterOutline.getParams().colored(10847909).lineWidth(0.0f);
        this.transformation.init(anchor, settings, this.bounds);
    }

    public AABB calculateGreaterOutlineBounds() {
        return this.bounds.m_82369_(new Vec3(0.0, 0.0, 0.0).m_82520_(this.bounds.m_82362_() * (double)this.cloneScaleMin.m_123341_(), this.bounds.m_82376_() * (double)this.cloneScaleMin.m_123342_(), this.bounds.m_82385_() * (double)this.cloneScaleMin.m_123343_())).m_82369_(new Vec3(0.0, 0.0, 0.0).m_82520_(this.bounds.m_82362_() * (double)this.cloneScaleMax.m_123341_(), this.bounds.m_82376_() * (double)this.cloneScaleMax.m_123342_(), this.bounds.m_82385_() * (double)this.cloneScaleMax.m_123343_()));
    }

    public void deploy() {
        if (!this.deployed) {
            List<PatternSchematicsToolType> tools = PatternSchematicsToolType.getTools(Minecraft.m_91087_().f_91074_.m_7500_());
            this.selectionScreen = new PatternSchematicsToolSelectionScreen(tools, this::equip);
        }
        this.deployed = true;
        this.setupRenderer();
    }

    public String getCurrentSchematicName() {
        return this.displayedSchematic != null ? this.displayedSchematic : "-";
    }

    public boolean isActive() {
        return this.active;
    }

    public AABB getBounds() {
        return this.bounds;
    }

    public SchematicTransformation getTransformation() {
        return this.transformation;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public ItemStack getActiveSchematicItem() {
        return this.activeSchematicItem;
    }

    public void setCloneScaleMin(Vec3i min) {
        this.cloneScaleMin = Vec3iUtils.min(min, 0);
    }

    public void setCloneScaleMax(Vec3i max) {
        this.cloneScaleMax = Vec3iUtils.max(max, 0);
    }

    public Vec3i getCloneScaleMin() {
        return this.cloneScaleMin;
    }

    public Vec3i getCloneScaleMax() {
        return this.cloneScaleMax;
    }

    public void setCloneOffset(Vec3i offset) {
        this.cloneOffset = offset;
    }

    public boolean isRenderingMain() {
        return this.isRenderingMain;
    }

    public boolean isRenderingMultiple() {
        return this.isRenderingMultiple;
    }

    public AABB getExtendedBounds() {
        AABB originalBounds = this.getBounds();
        Vec3 boundsLength = new Vec3(originalBounds.m_82362_(), originalBounds.m_82376_(), originalBounds.m_82385_());
        return this.getBounds().m_82369_(new Vec3((double)this.cloneScaleMin.m_123341_(), (double)this.cloneScaleMin.m_123342_(), (double)this.cloneScaleMin.m_123343_()).m_82559_(boundsLength)).m_82369_(new Vec3((double)this.cloneScaleMax.m_123341_(), (double)this.cloneScaleMax.m_123342_(), (double)this.cloneScaleMax.m_123343_()).m_82559_(boundsLength));
    }

    public AABBOutline getGreaterOutline() {
        return this.greaterOutline;
    }
}

