/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class RenderUtils {
    public static void bindTexture(ResourceLocation texture) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
    }

    public static void setup(ResourceLocation texture, float red, float green, float blue, float alpha) {
        RenderUtils.bindTexture(texture);
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void setup(ResourceLocation texture) {
        RenderUtils.setup(texture, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderFluidStack(int x, int y, int width, int height, float depth, FluidStack fluidStack) {
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(props.getStillTexture());
        int col = props.getTintColor(fluidStack);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        float u1 = sprite.m_118409_();
        float v1 = sprite.m_118411_();
        float u2 = sprite.m_118410_();
        float v2 = sprite.m_118412_();
        do {
            int currentHeight = Math.min(sprite.m_245424_().m_245330_(), height);
            height -= currentHeight;
            int x2 = x;
            int width2 = width;
            do {
                int currentWidth = Math.min(sprite.m_245424_().m_246492_(), width2);
                width2 -= currentWidth;
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
                bufferbuilder.m_5483_((double)x2, (double)y, (double)depth).m_7421_(u1, v1).m_6122_(col >> 16 & 0xFF, col >> 8 & 0xFF, col & 0xFF, 255).m_5752_();
                bufferbuilder.m_5483_((double)x2, (double)(y + currentHeight), (double)depth).m_7421_(u1, v2).m_6122_(col >> 16 & 0xFF, col >> 8 & 0xFF, col & 0xFF, 255).m_5752_();
                bufferbuilder.m_5483_((double)(x2 + currentWidth), (double)(y + currentHeight), (double)depth).m_7421_(u2, v2).m_6122_(col >> 16 & 0xFF, col >> 8 & 0xFF, col & 0xFF, 255).m_5752_();
                bufferbuilder.m_5483_((double)(x2 + currentWidth), (double)y, (double)depth).m_7421_(u2, v1).m_6122_(col >> 16 & 0xFF, col >> 8 & 0xFF, col & 0xFF, 255).m_5752_();
                tessellator.m_85914_();
                x2 += currentWidth;
            } while (width2 > 0);
            y += currentHeight;
        } while (height > 0);
        bufferbuilder.m_141991_();
        RenderSystem.disableBlend();
    }

    public static void setColorRGBA(int color) {
        float a = (float)RenderUtils.alpha(color) / 255.0f;
        float r = (float)RenderUtils.red(color) / 255.0f;
        float g = (float)RenderUtils.green(color) / 255.0f;
        float b = (float)RenderUtils.blue(color) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static int red(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int blue(int c) {
        return c & 0xFF;
    }
}

