/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.MoltenVents.core.objects;

import com.Apothic0n.MoltenVents.config.CommonConfig;
import com.Apothic0n.MoltenVents.core.MoltenVentsConductiveData;
import com.Apothic0n.MoltenVents.core.MoltenVentsConvertibleData;
import com.Apothic0n.MoltenVents.core.objects.MoltenBlockEntities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ActiveMoltenBlockEntity
extends BlockEntity {
    private static final Map<ResourceLocation, JsonElement> conductiveMap = MoltenVentsConductiveData.conductiveBlocksMap;
    private static final Map<ResourceLocation, JsonElement> convertibleMap = MoltenVentsConvertibleData.convertibleBlocksMap;
    public static int spreadDistance = 5;

    public ActiveMoltenBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(ActiveMoltenBlockEntity.activeMoltenBlockEntity(blockState), blockPos, blockState);
    }

    private static BlockEntityType<?> activeMoltenBlockEntity(BlockState blockState) {
        List<Map<Block, BlockEntityType<?>>> moltenBlockEntities = MoltenBlockEntities.getMoltenBlockEntities();
        BlockEntityType<?> activeMoltenBlockEntity = null;
        for (int i = 0; i < moltenBlockEntities.size(); ++i) {
            BlockEntityType<?> activeBlockEntity = moltenBlockEntities.get(i).get(blockState.m_60734_());
            if (activeBlockEntity == null) continue;
            activeMoltenBlockEntity = activeBlockEntity;
        }
        return activeMoltenBlockEntity;
    }

    private static Map<Integer, List<Block>> getLists(BlockState blockState) {
        String name = blockState.m_60734_().m_204297_().m_205785_().m_135782_().m_135815_().substring(14);
        ArrayList<Block> conductiveBlocks = new ArrayList<Block>(List.of());
        ArrayList<Block> convertibleBlocks = new ArrayList<Block>(List.of());
        JsonArray conductiveList = Collections.singletonList(conductiveMap.get(new ResourceLocation("molten_vents", name)).getAsJsonObject().get("values").getAsJsonArray()).get(0);
        for (int i = 0; i < conductiveList.size(); ++i) {
            JsonElement blockName = conductiveList.get(i);
            conductiveBlocks.add((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(blockName.toString().substring(1, blockName.toString().length() - 1))));
        }
        JsonArray convertibleList = Collections.singletonList(convertibleMap.get(new ResourceLocation("molten_vents", name)).getAsJsonObject().get("values").getAsJsonArray()).get(0);
        for (int i = 0; i < convertibleList.size(); ++i) {
            JsonElement blockName = convertibleList.get(i);
            convertibleBlocks.add((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(blockName.toString().substring(1, blockName.toString().length() - 1))));
        }
        return Map.of(1, conductiveBlocks, 2, convertibleBlocks);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (!level.f_46443_) {
            ServerLevel serverLevel = Objects.requireNonNull(level.m_7654_()).m_129880_(level.m_46472_());
            Map<Integer, List<Block>> lists = ActiveMoltenBlockEntity.getLists(blockState);
            List<Block> conductiveBlocks = lists.get(1);
            List<Block> convertibleBlocks = lists.get(2);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.m_7494_(), (WorldGenLevel)serverLevel);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.m_7495_(), (WorldGenLevel)serverLevel);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.m_122012_(), (WorldGenLevel)serverLevel);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.m_122029_(), (WorldGenLevel)serverLevel);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.m_122019_(), (WorldGenLevel)serverLevel);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.m_122024_(), (WorldGenLevel)serverLevel);
        }
    }

    private static void spreadBlock(List<Block> conductiveBlocks, List<Block> convertibleBlocks, BlockPos pos, WorldGenLevel level) {
        BlockState[] contacts = new BlockState[]{level.m_8055_(pos.m_7494_()), level.m_8055_(pos.m_7495_()), level.m_8055_(pos.m_122012_()), level.m_8055_(pos.m_122029_()), level.m_8055_(pos.m_122019_()), level.m_8055_(pos.m_122024_())};
        Boolean isTouchingOrestone = false;
        for (int i = 0; i < contacts.length && !isTouchingOrestone.booleanValue(); ++i) {
            if (!conductiveBlocks.contains(contacts[i].m_60734_())) continue;
            isTouchingOrestone = true;
        }
        if (isTouchingOrestone != false && !level.m_8055_(pos).m_278721_() && convertibleBlocks.contains(level.m_8055_(pos).m_60734_()) || isTouchingOrestone != false && (Boolean)CommonConfig.useSource.get() == false && convertibleBlocks.contains(level.m_8055_(pos).m_60734_()) || isTouchingOrestone != false && (Boolean)CommonConfig.useSource.get() != false && convertibleBlocks.contains(level.m_8055_(pos).m_60734_()) && level.m_8055_(pos).m_60819_().m_76170_() || isTouchingOrestone.booleanValue() && conductiveBlocks.contains(level.m_8055_(pos).m_60734_())) {
            List<BlockPos> convertedBlocks;
            if (!level.m_8055_(pos).m_278721_() && convertibleBlocks.contains(level.m_8055_(pos).m_60734_()) || (Boolean)CommonConfig.useSource.get() == false && convertibleBlocks.contains(level.m_8055_(pos).m_60734_()) || ((Boolean)CommonConfig.useSource.get()).booleanValue() && convertibleBlocks.contains(level.m_8055_(pos).m_60734_()) && level.m_8055_(pos).m_60819_().m_76170_()) {
                level.m_7731_(pos, conductiveBlocks.get(0).m_49966_(), 3);
                level.m_5594_(null, pos, SoundEvents.f_12031_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7654_().m_129880_(level.m_6018_().m_46472_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + 0.5, 8, 0.5, 0.25, 0.5, 0.0);
            }
            if ((convertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, pos, level)) != null && !convertedBlocks.isEmpty() && spreadDistance >= 1) {
                ArrayList<BlockPos> secondaryConvertedBlocks = new ArrayList<BlockPos>(List.of());
                for (int i = 0; i < convertedBlocks.size(); ++i) {
                    List<BlockPos> minorConvertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, convertedBlocks.get(i), level);
                    if (minorConvertedBlocks == null || !minorConvertedBlocks.isEmpty()) continue;
                    secondaryConvertedBlocks.addAll(minorConvertedBlocks);
                }
                if (secondaryConvertedBlocks != null && !secondaryConvertedBlocks.isEmpty() && spreadDistance >= 2) {
                    ArrayList<BlockPos> teritaryConvertedBlocks = new ArrayList<BlockPos>(List.of());
                    for (int i = 0; i < secondaryConvertedBlocks.size(); ++i) {
                        List<BlockPos> minorConvertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, (BlockPos)secondaryConvertedBlocks.get(i), level);
                        if (minorConvertedBlocks == null || !minorConvertedBlocks.isEmpty()) continue;
                        teritaryConvertedBlocks.addAll(minorConvertedBlocks);
                    }
                    if (teritaryConvertedBlocks != null && !teritaryConvertedBlocks.isEmpty() && spreadDistance >= 3) {
                        ArrayList<BlockPos> quaternaryConvertedBlocks = new ArrayList<BlockPos>(List.of());
                        for (int i = 0; i < teritaryConvertedBlocks.size(); ++i) {
                            List<BlockPos> minorConvertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, (BlockPos)teritaryConvertedBlocks.get(i), level);
                            if (minorConvertedBlocks == null || !minorConvertedBlocks.isEmpty()) continue;
                            quaternaryConvertedBlocks.addAll(minorConvertedBlocks);
                        }
                        if (quaternaryConvertedBlocks != null && !quaternaryConvertedBlocks.isEmpty() && spreadDistance >= 4) {
                            ArrayList<BlockPos> quinaryConvertedBlocks = new ArrayList<BlockPos>(List.of());
                            for (int i = 0; i < quaternaryConvertedBlocks.size(); ++i) {
                                List<BlockPos> minorConvertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, (BlockPos)quaternaryConvertedBlocks.get(i), level);
                                if (minorConvertedBlocks == null || !minorConvertedBlocks.isEmpty()) continue;
                                quinaryConvertedBlocks.addAll(minorConvertedBlocks);
                            }
                            if (quinaryConvertedBlocks != null && !quinaryConvertedBlocks.isEmpty() && spreadDistance >= 5) {
                                ArrayList<BlockPos> senaryConvertedBlocks = new ArrayList<BlockPos>(List.of());
                                for (int i = 0; i < quinaryConvertedBlocks.size(); ++i) {
                                    List<BlockPos> minorConvertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, (BlockPos)quinaryConvertedBlocks.get(i), level);
                                    if (minorConvertedBlocks == null || !minorConvertedBlocks.isEmpty()) continue;
                                    senaryConvertedBlocks.addAll(minorConvertedBlocks);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static List<BlockPos> convertTouching(List<Block> convertibleBlocks, List<Block> conductiveBlocks, BlockPos pos, WorldGenLevel level) {
        List<BlockPos> lavaBlocks = ActiveMoltenBlockEntity.getLavaTouching(convertibleBlocks, pos, level);
        List<BlockPos> touchingBlocks = ActiveMoltenBlockEntity.getLavaTouching(conductiveBlocks, pos, level);
        if (lavaBlocks != null && !lavaBlocks.isEmpty()) {
            for (int i = 0; i < lavaBlocks.size(); ++i) {
                BlockPos lavaPos = lavaBlocks.get(i);
                if (!(!level.m_8055_(lavaPos).m_278721_() && convertibleBlocks.contains(level.m_8055_(lavaPos).m_60734_()) || (Boolean)CommonConfig.useSource.get() == false && convertibleBlocks.contains(level.m_8055_(lavaPos).m_60734_())) && (!((Boolean)CommonConfig.useSource.get()).booleanValue() || !convertibleBlocks.contains(level.m_8055_(lavaPos).m_60734_()) || !level.m_8055_(lavaPos).m_60819_().m_76170_())) continue;
                level.m_7731_(lavaPos, conductiveBlocks.get(0).m_49966_(), 3);
                level.m_5594_(null, lavaPos, SoundEvents.f_12031_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7654_().m_129880_(level.m_6018_().m_46472_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)lavaPos.m_123341_() + 0.5, (double)lavaPos.m_123342_() + 0.25, (double)lavaPos.m_123343_() + 0.5, 8, 0.5, 0.25, 0.5, 0.0);
            }
        }
        if (touchingBlocks.size() > 0) {
            return touchingBlocks;
        }
        return null;
    }

    private static List<BlockPos> getLavaTouching(List<Block> convertibleBlocks, BlockPos pos, WorldGenLevel level) {
        BlockPos[] contacts = new BlockPos[]{pos.m_7494_(), pos.m_7495_(), pos.m_122012_(), pos.m_122029_(), pos.m_122019_(), pos.m_122024_()};
        ArrayList<BlockPos> lavaBlocks = new ArrayList<BlockPos>(List.of());
        for (int i = 0; i < contacts.length; ++i) {
            if (!(!level.m_8055_(contacts[i]).m_278721_() && convertibleBlocks.contains(level.m_8055_(contacts[i]).m_60734_()) || (Boolean)CommonConfig.useSource.get() == false && convertibleBlocks.contains(level.m_8055_(contacts[i]).m_60734_()) || (Boolean)CommonConfig.useSource.get() != false && convertibleBlocks.contains(level.m_8055_(contacts[i]).m_60734_()) && level.m_8055_(contacts[i]).m_60819_().m_76170_()) && !convertibleBlocks.contains(level.m_8055_(contacts[i]).m_60734_())) continue;
            lavaBlocks.add(contacts[i]);
        }
        if (!lavaBlocks.isEmpty()) {
            return lavaBlocks;
        }
        return null;
    }
}

