/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.condition;

import com.almostreliable.lootjs.loot.condition.IExtendedLootCondition;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class AnyStructure
implements IExtendedLootCondition {
    private final List<StructureLocator> structureLocators;
    private final boolean exact;

    public AnyStructure(List<StructureLocator> structureLocators, boolean exact) {
        this.structureLocators = structureLocators;
        this.exact = exact;
    }

    @Override
    public boolean test(LootContext context) {
        Vec3 origin = (Vec3)context.m_78953_(LootContextParams.f_81460_);
        if (origin != null) {
            BlockPos blockPos = new BlockPos((int)origin.f_82479_, (int)origin.f_82480_, (int)origin.f_82481_);
            StructureManager structureManager = context.m_78952_().m_215010_();
            Registry registry = context.m_78952_().m_9598_().m_175515_(Registries.f_256944_);
            for (StructureLocator l : this.structureLocators) {
                StructureStart structureAt;
                Structure feature = l.getStructure((Registry<Structure>)registry, context.m_78952_(), blockPos);
                if (feature == null || !(structureAt = this.exact ? structureManager.m_220524_(blockPos, feature) : structureManager.m_220494_(blockPos, feature)).m_73603_()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExact() {
        return this.exact;
    }

    public static interface StructureLocator {
        @Nullable
        public Structure getStructure(Registry<Structure> var1, ServerLevel var2, BlockPos var3);
    }

    public static class Builder {
        private final List<ResourceKey<Structure>> ids = new ArrayList<ResourceKey<Structure>>();
        private final List<TagKey<Structure>> tags = new ArrayList<TagKey<Structure>>();

        public Builder add(String idOrTag) {
            if (idOrTag.startsWith("#")) {
                ResourceLocation rl = new ResourceLocation(idOrTag.substring(1));
                this.tags.add((TagKey<Structure>)TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)rl));
            } else {
                ResourceLocation rl = new ResourceLocation(idOrTag);
                this.ids.add((ResourceKey<Structure>)ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)rl));
            }
            return this;
        }

        public AnyStructure build(boolean exact) {
            ArrayList<StructureLocator> locators = new ArrayList<StructureLocator>();
            for (ResourceKey<Structure> resourceKey : this.ids) {
                locators.add(new ById(resourceKey));
            }
            for (TagKey tagKey : this.tags) {
                locators.add(new ByTag((TagKey<Structure>)tagKey));
            }
            return new AnyStructure(locators, exact);
        }
    }

    public record ById(ResourceKey<Structure> id) implements StructureLocator
    {
        @Override
        @Nullable
        public Structure getStructure(Registry<Structure> registry, ServerLevel level, BlockPos pos) {
            return (Structure)registry.m_6246_(this.id);
        }
    }

    public record ByTag(TagKey<Structure> tag) implements StructureLocator
    {
        @Override
        @Nullable
        public Structure getStructure(Registry<Structure> registry, ServerLevel level, BlockPos pos) {
            return registry.m_203431_(this.tag).map(h -> level.m_7726_().m_8481_().m_223037_(level, (HolderSet)h, pos, 1, false)).map(Pair::getSecond).map(Holder::m_203334_).orElse(null);
        }
    }
}

