/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.satisfy.wildernature.entity.ai.AnimationAttackGoal;
import net.satisfy.wildernature.entity.ai.EntityWithAttackAnimation;
import net.satisfy.wildernature.entity.animation.ServerAnimationDurations;
import net.satisfy.wildernature.registry.EntityRegistry;
import net.satisfy.wildernature.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TurkeyEntity
extends Chicken
implements EntityWithAttackAnimation {
    private static final Ingredient FOOD_ITEMS;
    private static final EntityDataAccessor<Boolean> ATTACKING;
    public AnimationState attackAnimationState = new AnimationState();
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    public boolean isPelicanJockey;
    private float nextFlap = 1.0f;

    public TurkeyEntity(EntityType<? extends TurkeyEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        this.attackAnimationState.m_246184_(((Boolean)this.f_19804_.m_135370_(ATTACKING)).booleanValue(), this.f_19797_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    @Override
    public LivingEntity getTarget_() {
        return this.m_5448_();
    }

    @Override
    public double getMeleeAttackRangeSqr_(LivingEntity target) {
        return this.m_142593_(target);
    }

    @Override
    public void setAttacking_(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    @Override
    public Vec3 getPosition_(int i) {
        return super.m_20318_((float)i);
    }

    @Override
    public void doHurtTarget_(LivingEntity targetEntity) {
        super.m_7327_((Entity)targetEntity);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.24).m_22268_(Attributes.f_22281_, 1.25);
    }

    protected void m_8099_() {
        int i = 0;
        this.f_21345_.m_25352_(++i, (Goal)new AnimationAttackGoal(this, 1.0, true, (int)(ServerAnimationDurations.turkey_attack * 20.0f + 2.0f), 8));
        this.f_21345_.m_25352_(++i, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(++i, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(++i, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(++i, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(++i, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(++i, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(++i, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return this.m_6162_() ? entityDimensions.f_20378_ * 0.85f : entityDimensions.f_20378_ * 0.92f;
    }

    public void m_8107_() {
        super.m_8107_();
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (this.m_20096_() ? -1.0f : 3.0f) * 0.2f;
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)0.5f);
        if (!this.m_20096_() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFlap;
    }

    protected void m_142043_() {
        this.nextFlap = this.f_146794_ + this.flapSpeed / 2.0f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.TURKEY_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.TURKEY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.TURKEY_DEATH.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    @Nullable
    public TurkeyEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (TurkeyEntity)((EntityType)EntityRegistry.TURKEY.get()).m_20615_((Level)serverLevel);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    public int m_213860_() {
        return this.isPelicanJockey() ? 12 : super.m_213860_();
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        super.m_19956_(entity, moveFunction);
        float f = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float g = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        double yOffset = -0.18;
        moveFunction.m_20372_(entity, this.m_20185_() + (double)(0.1f * f), this.m_20227_(0.5) + entity.m_6049_() + yOffset, this.m_20189_() - (double)(0.1f * g));
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).f_20883_ = this.f_20883_;
        }
    }

    public boolean isPelicanJockey() {
        return this.isPelicanJockey;
    }

    static {
        ATTACKING = SynchedEntityData.m_135353_(TurkeyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_, Items.f_42578_, Items.f_42577_, Items.f_42733_, Items.f_42406_});
    }
}

