/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.wildernature.entity.RedWolfEntity;
import net.satisfy.wildernature.entity.animation.RedWolfAnimation;
import net.satisfy.wildernature.util.WilderNatureIdentifier;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class RedWolfModel<T extends RedWolfEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation((ResourceLocation)new WilderNatureIdentifier("red_wolf"), "main");
    private static final String REAL_TAIL = "real_tail";
    private final ModelPart root;

    public RedWolfModel(ModelPart root) {
        this.root = root;
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)16.0f, (float)8.0f));
        PartDefinition animroot = root.m_171599_("animroot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg = animroot.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(26, 33).m_171488_(0.0f, 0.0f, -0.99f, 2.0f, 8.0f, 2.01f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)0.0f, (float)-12.0f));
        PartDefinition leftFrontLeg = animroot.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(0.0f, 0.0f, -0.99f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.5f, (float)0.0f, (float)-12.0f));
        PartDefinition rightHindLeg = animroot.m_171599_("rightHindLeg", CubeListBuilder.m_171558_().m_171514_(26, 33).m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)0.0f, (float)-1.0f));
        PartDefinition leftHindLeg = animroot.m_171599_("leftHindLeg", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.5f, (float)0.0f, (float)-1.0f));
        PartDefinition body = animroot.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -7.0f, -5.0f, 6.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-2.0f, (float)-6.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-3.0f, -3.0f, -4.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(20, 0).m_171488_(-3.0f, -7.0f, 0.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(2.0f, -7.0f, 0.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(28, 27).m_171488_(-1.0f, 0.0f, -7.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-8.5f, (float)-1.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171488_(-1.0f, 0.0f, -2.25f, 4.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(23, 17).m_171488_(-1.0f, 9.0f, -2.25f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)7.0f, (float)-1.0f));
        PartDefinition real_tail = tail.m_171599_(REAL_TAIL, CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)12.0f, (float)-6.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(T wolf, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (((RedWolfEntity)wolf).isSneaking()) {
            this.m_267799_(RedWolfAnimation.sneak, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        } else {
            this.m_267799_(RedWolfAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        }
        this.m_233381_(((RedWolfEntity)wolf).attackState, RedWolfAnimation.attack, ageInTicks);
        this.m_233385_(((RedWolfEntity)wolf).sitAnimationState, RedWolfAnimation.sit, ageInTicks, 1.0f);
    }
}

