/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.wildernature.entity.BoarEntity;
import net.satisfy.wildernature.entity.animation.BoarAnimation;
import net.satisfy.wildernature.util.WilderNatureIdentifier;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class BoarModel<T extends BoarEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation((ResourceLocation)new WilderNatureIdentifier("boar"), "main");
    private final ModelPart boar;
    private final ModelPart head;

    public BoarModel(ModelPart root) {
        this.boar = root.m_171324_("boar");
        this.head = this.boar.m_171324_("body").m_171324_("head");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition boar = partdefinition.m_171599_("boar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = boar.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(0.0f, -14.7393f, -13.0868f, 0.0f, 10.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-11.2607f, (float)3.0868f));
        PartDefinition body_r1 = body.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -3.0f, -10.0f, 16.0f, 11.0f, 20.0f, new CubeDeformation(0.02f)), PartPose.m_171423_((float)0.0f, (float)-2.7393f, (float)-0.0868f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-5.7393f, (float)-8.0868f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition head_r1 = head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(3.0f, -5.6134f, -4.8137f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(7, 8).m_171488_(-5.0f, -5.6134f, -4.8137f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(20, 32).m_171488_(-5.0f, -4.6134f, -1.8137f, 10.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(64, 48).m_171488_(-4.0f, -2.6134f, -5.8137f, 8.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.7673f, (float)-9.4924f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition right_ear = head.m_171599_("right_ear", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-7.0f, (float)-5.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.8727f));
        PartDefinition right_ear_r1 = right_ear.m_171599_("right_ear_r1", CubeListBuilder.m_171558_().m_171514_(64, 64).m_171488_(-5.9654f, -6.3277f, 2.1863f, 6.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0231f, (float)7.4403f, (float)-7.4924f, (float)-0.2f, (float)-0.2324f, (float)0.0234f));
        PartDefinition left_ear = head.m_171599_("left_ear", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)7.0f, (float)-5.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.8727f));
        PartDefinition left_ear_r1 = left_ear.m_171599_("left_ear_r1", CubeListBuilder.m_171558_().m_171514_(64, 58).m_171488_(-0.0346f, -6.3277f, 2.1863f, 6.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0231f, (float)7.4403f, (float)-7.4924f, (float)-0.2f, (float)0.2324f, (float)-0.0234f));
        PartDefinition leg_front_left = boar.m_171599_("legfrontleft", CubeListBuilder.m_171558_().m_171514_(39, 50).m_171488_(-4.0f, -1.0f, -3.0f, 6.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)-12.0f, (float)-3.0f));
        PartDefinition leg_back_right = boar.m_171599_("legbackright", CubeListBuilder.m_171558_().m_171514_(0, 62).m_171488_(-14.0f, -2.0f, -2.0f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)-8.0f, (float)9.0f));
        PartDefinition leg_back_left = boar.m_171599_("legbackleft", CubeListBuilder.m_171558_().m_171514_(61, 32).m_171488_(9.0f, -2.0f, -3.0f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)-8.0f, (float)10.0f));
        PartDefinition leg_front_right = boar.m_171599_("legfrontright", CubeListBuilder.m_171558_().m_171514_(53, 0).m_171488_(-2.0f, -1.0f, -3.0f, 6.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)-12.0f, (float)-3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.m_233385_(((BoarEntity)((Object)entity)).idleAnimationState, BoarAnimation.idle, ageInTicks, 1.0f);
        this.m_267799_(BoarAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        if (((BoarEntity)((Object)entity)).isDigging()) {
            AnimationDefinition digAnimation = BoarAnimation.dig;
            this.m_233385_(((BoarEntity)((Object)entity)).idleAnimationState, digAnimation, ageInTicks, 1.0f);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.boar.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.boar;
    }
}

