/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.util.SaturationTracker;

public class SaturationOverlayRenderer {
    public static void renderIfApplicable(PoseStack poseStack, MultiBufferSource buffer, LivingEntity entity) {
        if (!(entity instanceof SaturationTracker.SaturatedAnimal)) {
            return;
        }
        SaturationTracker.SaturatedAnimal saturated = (SaturationTracker.SaturatedAnimal)entity;
        SaturationTracker tracker = saturated.farm_and_charm$getSaturationTracker();
        SaturationOverlayRenderer.render(poseStack, buffer, entity, tracker.level(), tracker.foodCounter());
    }

    public static void render(PoseStack poseStack, MultiBufferSource buffer, LivingEntity entity, int level, int foodCounter) {
        if (entity.m_6162_()) {
            return;
        }
        EntityType type = entity.m_6095_();
        if (type != EntityType.f_20557_ && type != EntityType.f_20510_ && type != EntityType.f_20520_ && type != EntityType.f_20555_) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ItemRenderer itemRenderer = mc.m_91291_();
        double yOffset = (double)entity.m_20206_() + 0.6;
        if (entity.m_8077_()) {
            yOffset += 0.3;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, yOffset, 0.0);
        poseStack.m_252781_(mc.m_91290_().m_253208_());
        poseStack.m_85841_(0.4f, 0.4f, 0.4f);
        ItemStack icon = SaturationOverlayRenderer.resolveIcon(entity);
        int[] thresholds = new int[]{5, 10, 15, 20};
        for (int i = 0; i < 3; ++i) {
            float alpha;
            poseStack.m_85836_();
            poseStack.m_85837_((double)(1 - i) * 1.1, 0.0, 0.0);
            if (level > 0) {
                if (i < level) {
                    alpha = 0.9f;
                } else if (i == level) {
                    float progress = (float)foodCounter / (float)thresholds[level];
                    alpha = Mth.m_14036_((float)(0.4f + 0.5f * progress), (float)0.4f, (float)0.9f);
                } else {
                    alpha = 0.4f;
                }
            } else {
                float progress = SaturationOverlayRenderer.getProgress(foodCounter, i, thresholds);
                alpha = 0.4f + 0.5f * progress;
            }
            int light = Mth.m_14143_((float)(240.0f * alpha));
            itemRenderer.m_269128_(icon, ItemDisplayContext.FIXED, light, OverlayTexture.f_118083_, poseStack, buffer, entity.m_9236_(), 1);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private static float getProgress(int foodCounter, int i, int[] thresholds) {
        int start = switch (i) {
            case 1 -> thresholds[0];
            case 2 -> thresholds[0] + thresholds[1];
            default -> 0;
        };
        int end = switch (i) {
            case 0 -> thresholds[0];
            case 1 -> thresholds[0] + thresholds[1];
            case 2 -> thresholds[0] + thresholds[1] + thresholds[2];
            default -> 1;
        };
        return Mth.m_14036_((float)((float)(foodCounter - start) / (float)(end - start)), (float)0.0f, (float)1.0f);
    }

    private static ItemStack resolveIcon(LivingEntity entity) {
        if (entity instanceof Cow) {
            return new ItemStack((ItemLike)Items.f_42405_);
        }
        if (entity instanceof Pig) {
            return new ItemStack((ItemLike)Items.f_42410_);
        }
        if (entity instanceof Sheep) {
            return new ItemStack((ItemLike)Items.f_42405_);
        }
        if (entity instanceof Chicken) {
            return new ItemStack((ItemLike)Items.f_42404_);
        }
        return new ItemStack((ItemLike)ObjectRegistry.HORSE_FODDER.get());
    }
}

