/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.candlelight.core.block.entity.LargeCookingPotBlockEntity;
import net.satisfy.farm_and_charm.core.registry.SoundEventRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LargeCookingPotBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    public static final BooleanProperty COOKING = BooleanProperty.m_61465_((String)"cooking");
    public static final BooleanProperty NEEDS_SUPPORT = BooleanProperty.m_61465_((String)"needs_support");
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.0625, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.625, (double)0.1875, (double)0.8125, (double)0.75, (double)0.25), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.625, (double)0.75, (double)0.8125, (double)0.75, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.625, (double)0.25), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.75, (double)0.8125, (double)0.625, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.25, (double)0.25, (double)0.625, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.0, (double)0.25, (double)0.8125, (double)0.625, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.625, (double)0.25, (double)0.25, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.625, (double)0.25, (double)0.8125, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.625, (double)0.25, (double)0.25, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.5625, (double)0.6875, (double)0.1875, (double)0.6875, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.5625, (double)0.25, (double)0.9375, (double)0.6875, (double)0.3125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.5625, (double)0.25, (double)0.1875, (double)0.6875, (double)0.3125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.5625, (double)0.6875, (double)0.9375, (double)0.6875, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.5625, (double)0.3125, (double)0.125, (double)0.6875, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.5625, (double)0.3125, (double)0.9375, (double)0.6875, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
        }
    });

    public LargeCookingPotBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)COOKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NEEDS_SUPPORT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LIT, COOKING, NEEDS_SUPPORT});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.getOrDefault(state.m_61143_((Property)FACING), Shapes.m_83040_());
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.f_46443_ && ((Boolean)state.m_61143_((Property)NEEDS_SUPPORT)).booleanValue()) {
            boolean isSupported;
            boolean bl = isSupported = world.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)world, pos.m_7495_()) || world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13087_);
            if (!isSupported) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    BlockPos neighborPos = pos.m_121945_(direction);
                    BlockState neighborState = world.m_8055_(neighborPos);
                    if (!(neighborState.m_60734_() instanceof LargeCookingPotBlock) || !((Boolean)neighborState.m_61143_((Property)NEEDS_SUPPORT)).booleanValue()) continue;
                    isSupported = true;
                    break;
                }
            }
            if (!isSupported) {
                world.m_46961_(pos, true);
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        BlockState belowState = world.m_8055_(pos.m_7495_());
        boolean needsSupport = belowState.m_204336_(BlockTags.f_13087_);
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)NEEDS_SUPPORT, (Comparable)Boolean.valueOf(needsSupport));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = world.m_8055_(belowPos);
        boolean isCampfireBelow = belowState.m_204336_(BlockTags.f_13087_);
        boolean isSolidBelow = belowState.m_60783_((BlockGetter)world, belowPos, Direction.UP);
        return isCampfireBelow || isSolidBelow;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity entity;
        if (!world.f_46443_ && (entity = world.m_7702_(pos)) instanceof MenuProvider) {
            player.m_5893_((MenuProvider)entity);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)COOKING)).booleanValue() && !((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            return;
        }
        double d = (double)pos.m_123341_() + 0.5;
        double e = (double)pos.m_123342_() + 0.7;
        double f = (double)pos.m_123343_() + 0.5;
        world.m_7785_(d, e, f, (SoundEvent)SoundEventRegistry.COOKING_POT_BOILING.get(), SoundSource.BLOCKS, 0.05f, 1.0f, false);
        double h = random.m_188500_() * 0.6 - 0.3;
        double i = h * (double)(random.m_188499_() ? 1 : -1);
        double j = random.m_188500_() * 0.5625;
        double k = h * (double)(random.m_188499_() ? 1 : -1);
        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + i, e + j, f + k, 0.0, 0.0, 0.0);
        world.m_7106_((ParticleOptions)ParticleTypes.f_123774_, d + i, e + j, f + k, 0.0, 0.0, 0.0);
        world.m_7106_((ParticleOptions)ParticleTypes.f_123795_, d + i, e + j, f + k, 0.0, 0.0, 0.0);
        world.m_7106_((ParticleOptions)ParticleTypes.f_123772_, d + i, e + j, f + k, 0.0, 0.0, 0.0);
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new LargeCookingPotBlockEntity(pos, state);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof LargeCookingPotBlockEntity) {
                Containers.m_19010_((Level)world, (BlockPos)pos, ((LargeCookingPotBlockEntity)blockEntity).getItems());
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        if (!world.f_46443_) {
            return (lvl, pos, blkState, t) -> {
                if (t instanceof LargeCookingPotBlockEntity) {
                    LargeCookingPotBlockEntity largecookingPot = (LargeCookingPotBlockEntity)t;
                    largecookingPot.tick(lvl, pos, blkState, largecookingPot);
                }
            };
        }
        return null;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.farm_and_charm.canbeplaced").m_130940_(ChatFormatting.GRAY));
    }
}

