/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.entity;

import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.satisfy.brewery.core.entity.BeerElementalEntity;
import net.satisfy.brewery.core.registry.EntityTypeRegistry;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class DarkBrewEntity
extends ThrowableItemProjectile {
    public DarkBrewEntity(Level world, LivingEntity owner) {
        super((EntityType)EntityTypeRegistry.DARK_BREW.get(), owner, world);
    }

    public DarkBrewEntity(EntityType<? extends DarkBrewEntity> entityType, Level world) {
        super(entityType, world);
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ObjectRegistry.DARK_BREW.get();
    }

    private ParticleOptions getParticleParameters() {
        SimpleParticleType particle;
        ItemStack itemStack = this.m_37454_();
        Object object = particle = itemStack.m_41619_() ? ParticleTypes.f_123781_ : new ItemParticleOption(ParticleTypes.f_123752_, itemStack);
        if (this.m_9236_().f_46443_) {
            this.spawnBlockParticles(Blocks.f_50185_.m_49966_(), 100);
            this.spawnBlockParticles(Blocks.f_50000_.m_49966_(), 20);
            this.spawnSimpleParticles();
        }
        return particle;
    }

    private void spawnBlockParticles(BlockState state, int count) {
        BlockParticleOption particleOption = new BlockParticleOption(ParticleTypes.f_123794_, state);
        for (int i = 0; i < count; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)particleOption, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.m_188583_() * 0.02, 0.2, this.f_19796_.m_188583_() * 0.02);
        }
    }

    private void spawnSimpleParticles() {
        for (int i = 0; i < 25; ++i) {
            double xOffset = this.f_19796_.m_188583_() * 0.1;
            double zOffset = this.f_19796_.m_188583_() * 0.1;
            double yOffset = this.f_19796_.m_188500_() * 0.5 + 0.2;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123781_, this.m_20185_() + xOffset, this.m_20186_() + yOffset, this.m_20189_() + zOffset, xOffset, yOffset, zOffset);
        }
    }

    public void m_7822_(byte status) {
        if (status == 3) {
            ParticleOptions particleEffect = this.getParticleParameters();
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_(particleEffect, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        Entity entity = entityHitResult.m_82443_();
        int damage = 2;
        entity.m_6469_(entity.m_269291_().m_269390_((Entity)this, this.m_19749_()), (float)damage);
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_5496_(SoundEvents.f_12630_, 1.0f, 1.0f);
            BeerElementalEntity beerElemental = new BeerElementalEntity((EntityType<? extends Monster>)((EntityType)EntityTypeRegistry.BEER_ELEMENTAL.get()), this.m_9236_());
            beerElemental.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            this.m_9236_().m_7967_((Entity)beerElemental);
            this.m_146870_();
        }
    }
}

