/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.effect.alcohol;

import java.util.Objects;

public class AlcoholLevel {
    private int drunkenness;
    private int immunity;

    public AlcoholLevel() {
        this(0, 3);
    }

    public AlcoholLevel(int drunkenness, int immunity) {
        this.drunkenness = drunkenness;
        this.immunity = Math.max(immunity, 3);
    }

    public int getDrunkenness() {
        return this.drunkenness;
    }

    public int getImmunity() {
        return this.immunity;
    }

    public boolean isDrunk() {
        return this.drunkenness >= this.immunity;
    }

    public boolean isBlackout() {
        return this.drunkenness > this.immunity;
    }

    public boolean isSober() {
        return this.drunkenness == 0;
    }

    public void drink() {
        this.drink(1);
    }

    public void drink(int amount) {
        this.drunkenness += amount;
    }

    public void sober() {
        this.sober(1);
    }

    public void sober(int amount) {
        this.drunkenness = Math.max(this.drunkenness - amount, 0);
    }

    public void soberUp() {
        this.drunkenness = 0;
    }

    public void gainImmunity() {
        int MAX_IMMUNITY = 10;
        this.immunity = Math.min(this.immunity + 1, MAX_IMMUNITY);
    }

    public AlcoholLevel copy() {
        return new AlcoholLevel(this.drunkenness, this.immunity);
    }

    public String toString() {
        return "AlcoholLevel: drunkenness=" + this.drunkenness + ", immunity=" + this.immunity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlcoholLevel)) {
            return false;
        }
        AlcoholLevel that = (AlcoholLevel)o;
        return this.drunkenness == that.drunkenness && this.immunity == that.immunity;
    }

    public int hashCode() {
        return Objects.hash(this.drunkenness, this.immunity);
    }
}

