/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.satisfy.brewery.recipe.BrewingRecipe;
import net.satisfy.brewery.recipe.SiloRecipe;

public class RecipeTypeRegistry {
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((String)"brewery", (ResourceKey)Registries.f_256764_);
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((String)"brewery", (ResourceKey)Registries.f_256954_);
    public static final RegistrySupplier<RecipeType<BrewingRecipe>> BREWING_RECIPE_TYPE = RecipeTypeRegistry.create("brewing");
    public static final RegistrySupplier<RecipeType<SiloRecipe>> SILO_RECIPE_TYPE = RecipeTypeRegistry.create("drying");
    public static final RegistrySupplier<RecipeSerializer<BrewingRecipe>> BREWING_RECIPE_SERIALIZER = RecipeTypeRegistry.create("brewing", BrewingRecipe.Serializer::new);
    public static final RegistrySupplier<RecipeSerializer<SiloRecipe>> SILO_RECIPE_SERIALIZER = RecipeTypeRegistry.create("drying", SiloRecipe.Serializer::new);

    private static <T extends Recipe<?>> RegistrySupplier<RecipeSerializer<T>> create(String name, Supplier<RecipeSerializer<T>> serializer) {
        return RECIPE_SERIALIZERS.register(name, serializer);
    }

    private static <T extends Recipe<?>> RegistrySupplier<RecipeType<T>> create(final String name) {
        Supplier<RecipeType> type = () -> new RecipeType<T>(){

            public String toString() {
                return name;
            }
        };
        return RECIPE_TYPES.register(name, type);
    }

    public static void init() {
        RECIPE_SERIALIZERS.register();
        RECIPE_TYPES.register();
    }
}

