/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;

public class WetHayBaleBlockEntity
extends BlockEntity {
    public static final TagKey<Biome> HOT_BIOME = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new BeachpartyIdentifier("hot_biome"));
    private int timer = this.initializeTimer();
    private boolean isProtected = false;

    public WetHayBaleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.WET_HAY_BALE_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(ServerLevel level, BlockPos pos, BlockState state, WetHayBaleBlockEntity be) {
        if (be.isProtected) {
            level.m_186460_(pos, state.m_60734_(), 1);
            return;
        }
        if (!level.m_45527_(pos.m_7494_()) || level.m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_)) {
            level.m_186460_(pos, state.m_60734_(), 1);
            return;
        }
        boolean hot = WetHayBaleBlockEntity.isHotBiome(level, pos);
        RandomSource random = level.m_213780_();
        Direction direction = Direction.m_235672_((RandomSource)random);
        if (direction != Direction.UP) {
            BlockPos pos2 = pos.m_121945_(direction);
            if (!(state.m_60815_() && level.m_8055_(pos2).m_60783_((BlockGetter)level, pos2, direction.m_122424_()) || !(random.m_188501_() < 0.3f))) {
                double d = pos.m_123341_();
                double e = pos.m_123342_();
                double f = pos.m_123343_();
                if (direction == Direction.DOWN) {
                    e -= 0.05;
                    d += random.m_188500_();
                    f += random.m_188500_();
                } else {
                    e += random.m_188500_() * 0.8;
                    d += direction.m_122434_() == Direction.Axis.X ? (direction == Direction.EAST ? 1.0 : 0.05) : random.m_188500_();
                    f += direction.m_122434_() == Direction.Axis.X ? random.m_188500_() : (direction == Direction.SOUTH ? 1.0 : 0.05);
                }
                level.m_8767_((ParticleOptions)ParticleTypes.f_123803_, d, e, f, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (hot && random.m_188501_() < 0.25f) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.6, (double)pos.m_123342_() + 1.25, (double)pos.m_123343_() + 0.5, 1, 0.05, 0.1875, 0.05, 0.0);
        }
        --be.timer;
        if (be.timer <= 0) {
            level.m_7731_(pos, hot ? ((Block)ObjectRegistry.THATCH.get()).m_49966_() : Blocks.f_50335_.m_49966_(), 3);
        } else {
            level.m_186460_(pos, state.m_60734_(), 1);
        }
    }

    private static boolean isHotBiome(ServerLevel level, BlockPos pos) {
        Holder biomeHolder = level.m_204166_(pos);
        return biomeHolder.m_203656_(HOT_BIOME);
    }

    private int initializeTimer() {
        ServerLevel serverLevel;
        Level level = this.m_58904_();
        return level instanceof ServerLevel && WetHayBaleBlockEntity.isHotBiome(serverLevel = (ServerLevel)level, this.m_58899_()) ? 1200 + level.f_46441_.m_188503_(601) : 600 + (level != null ? level.f_46441_.m_188503_(601) : 600);
    }

    public void preventDrying() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50129_.m_49966_()), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.0, (double)this.m_58899_().m_123343_() + 0.5, 10, 0.2, 0.2, 0.2, 0.1);
            serverLevel.m_5594_(null, this.m_58899_(), SoundEvents.f_12392_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.isProtected = true;
    }

    public void removeProtection() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.0, (double)this.m_58899_().m_123343_() + 0.5, 10, 0.2, 0.2, 0.2, 0.1);
            serverLevel.m_5594_(null, this.m_58899_(), SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.isProtected = false;
        this.timer = this.initializeTimer();
    }
}

