/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.satisfy.beachparty.core.block.HangingCoconutBlock;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class PalmLeavesBlock
extends LeavesBlock
implements BonemealableBlock {
    public static final IntegerProperty DISTANCE_9 = IntegerProperty.m_61631_((String)"distance_9", (int)1, (int)9);

    public PalmLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DISTANCE_9, (Comparable)Integer.valueOf(9))).m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(7))).m_61124_((Property)f_221367_, (Comparable)Boolean.valueOf(false)));
    }

    private static BlockState updateDistance(BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
        int i = 9;
        BlockPos.MutableBlockPos blockpos$autocloseable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockpos$autocloseable.m_122159_((Vec3i)pPos, direction);
            i = Math.min(i, PalmLeavesBlock.getDistanceAt(pLevel.m_8055_((BlockPos)blockpos$autocloseable)) + 1);
            if (i == 1) break;
        }
        return (BlockState)pState.m_61124_((Property)DISTANCE_9, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState blockState) {
        return PalmLeavesBlock.getOptionalDistanceAt(blockState).orElse(9);
    }

    @NotNull
    public static OptionalInt getOptionalDistanceAt(BlockState blockState) {
        if (blockState.m_204336_(BlockTags.f_13106_)) {
            return OptionalInt.of(0);
        }
        return blockState.m_61138_((Property)DISTANCE_9) ? OptionalInt.of((Integer)blockState.m_61143_((Property)DISTANCE_9)) : OptionalInt.empty();
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)DISTANCE_9) == 9 && (Boolean)state.m_61143_((Property)f_54419_) == false;
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (this.m_221385_(blockState)) {
            LeavesBlock.m_49950_((BlockState)blockState, (Level)serverLevel, (BlockPos)blockPos);
            serverLevel.m_7471_(blockPos, false);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{DISTANCE_9});
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        BlockState blockstate = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_221367_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return PalmLeavesBlock.updateDistance(blockstate, (LevelAccessor)pContext.m_43725_(), pContext.m_8083_());
    }

    protected boolean m_221385_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)f_54419_) == false && (Integer)pState.m_61143_((Property)DISTANCE_9) == 9;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.m_7731_(pPos, PalmLeavesBlock.updateDistance(pState, (LevelAccessor)pLevel, pPos), 3);
    }

    @NotNull
    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        int i;
        if (((Boolean)pState.m_61143_((Property)f_221367_)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if ((i = PalmLeavesBlock.getDistanceAt(pFacingState) + 1) != 1 || (Integer)pState.m_61143_((Property)DISTANCE_9) != i) {
            pLevel.m_186460_(pCurrentPos, (Block)this, 1);
        }
        return pState;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return level.m_8055_(pos.m_7495_()).m_60795_();
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (level.m_8055_(pos.m_7495_()).m_60795_()) {
            level.m_7731_(pos.m_7495_(), (BlockState)((Block)ObjectRegistry.HANGING_COCONUT.get()).m_49966_().m_61124_((Property)HangingCoconutBlock.AGE, (Comparable)Integer.valueOf(0)), 2);
        }
    }
}

