/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.core.block.cake;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.bakery.core.block.cake.PieBlock;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class LinzerTartBlock
extends PieBlock {
    private static final Supplier<VoxelShape> fullShapeSupplier = () -> Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.1875, (double)0.9375);
    public static final Map<Direction, VoxelShape> FULL_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)fullShapeSupplier.get()));
        }
    });
    private static final Supplier<VoxelShape> threeShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.5, (double)0.9375, (double)0.1875, (double)0.9375));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.5, (double)0.1875, (double)0.5));
        return shape;
    };
    public static final Map<Direction, VoxelShape> THREE_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)threeShapeSupplier.get()));
        }
    });
    private static final Supplier<VoxelShape> halfShapeSupplier = () -> Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.5, (double)0.9375, (double)0.1875, (double)0.9375);
    public static final Map<Direction, VoxelShape> HALF_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)halfShapeSupplier.get()));
        }
    });
    private static final Supplier<VoxelShape> quarterShapeSupplier = () -> Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.5, (double)0.5, (double)0.1875, (double)0.9375);
    public static final Map<Direction, VoxelShape> QUARTER_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)quarterShapeSupplier.get()));
        }
    });

    public LinzerTartBlock(BlockBehaviour.Properties settings, Supplier<Item> slice) {
        super(settings, slice);
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int cuts = (Integer)state.m_61143_((Property)CUTS);
        Map<Direction, VoxelShape> shape = switch (cuts) {
            case 1 -> THREE_SHAPE;
            case 2 -> HALF_SHAPE;
            case 3 -> QUARTER_SHAPE;
            default -> FULL_SHAPE;
        };
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        return shape.get(direction);
    }
}

