/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.util;

import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.capabilities.magic.UpgradeData;
import io.redspace.ironsspellbooks.item.armor.UpgradeType;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class UpgradeUtils {
    public static final Map<EquipmentSlot, UUID> UPGRADE_UUIDS_BY_SLOT = Map.of(EquipmentSlot.HEAD, UUID.fromString("f6c19678-1c70-4d41-ad19-cd84d8610242"), EquipmentSlot.CHEST, UUID.fromString("8d02c916-b0eb-4d17-8414-329b4bd38ae7"), EquipmentSlot.LEGS, UUID.fromString("3739c748-98d4-4a2d-9c25-3b4dec74823d"), EquipmentSlot.FEET, UUID.fromString("41cede88-7881-42dd-aac3-d6ab4b56b1f2"), EquipmentSlot.MAINHAND, UUID.fromString("c3865ad7-1f35-46d4-8b4b-a6b934a1a896"), EquipmentSlot.OFFHAND, UUID.fromString("c508430e-7497-42a9-9a9c-1a324dccca54"));

    public static String getRelevantEquipmentSlot(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof ICurioItem) {
            ICurioItem curioItem = (ICurioItem)item;
            Set tags = CuriosApi.getCuriosHelper().getCurioTags((Item)curioItem);
            Optional slot = tags.stream().findFirst();
            if (slot.isPresent()) {
                return (String)slot.get();
            }
        } else {
            item = itemStack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                return armorItem.m_40402_().m_20751_();
            }
        }
        return EquipmentSlot.MAINHAND.m_20751_();
    }

    public static UUID UUIDForSlot(EquipmentSlot slot) {
        return UPGRADE_UUIDS_BY_SLOT.get(slot);
    }

    public static void handleAttributeEvent(Multimap<Attribute, AttributeModifier> modifiers, UpgradeData upgradeData, BiConsumer<Attribute, AttributeModifier> addCallback, BiConsumer<Attribute, AttributeModifier> removeCallback, Optional<UUID> uuidOverride) {
        Map<UpgradeType, Integer> upgrades = upgradeData.getUpgrades();
        for (Map.Entry<UpgradeType, Integer> entry : upgrades.entrySet()) {
            UUID uuid;
            UpgradeType upgradeType = entry.getKey();
            int count = entry.getValue();
            double baseAmount = UpgradeUtils.collectAndRemovePreexistingAttribute(modifiers, upgradeType.getAttribute(), upgradeType.getOperation(), removeCallback);
            if (uuidOverride.isPresent()) {
                uuid = uuidOverride.get();
            } else {
                try {
                    uuid = UpgradeUtils.UUIDForSlot(EquipmentSlot.m_20747_((String)upgradeData.getUpgradedSlot()));
                }
                catch (IllegalArgumentException e) {
                    IronsSpellbooks.LOGGER.warn("Invalid UpgradeData NBT: {}", (Object)e.toString());
                    return;
                }
            }
            addCallback.accept(upgradeType.getAttribute(), new AttributeModifier(uuid, "upgrade", baseAmount + (double)(upgradeType.getAmountPerUpgrade() * (float)count), entry.getKey().getOperation()));
        }
    }

    public static double collectAndRemovePreexistingAttribute(Multimap<Attribute, AttributeModifier> modifiers, Attribute key, AttributeModifier.Operation operationToMatch, BiConsumer<Attribute, AttributeModifier> removeCallback) {
        if (modifiers.containsKey((Object)key)) {
            for (AttributeModifier modifier : modifiers.get((Object)key)) {
                if (!modifier.m_22217_().equals((Object)operationToMatch)) continue;
                removeCallback.accept(key, modifier);
                return modifier.m_22218_();
            }
        }
        return 0.0;
    }
}

