/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.util;

import com.c2h6s.etstlib.EtSTLibConfig;
import com.c2h6s.etstlib.content.misc.EtSTLibToolAttackTweak;
import com.c2h6s.etstlib.entity.specialDamageSources.LegacyDamageSource;
import com.c2h6s.etstlib.register.EtSTLibHooks;
import com.c2h6s.etstlib.tool.hooks.CriticalAttackModifierHook;
import com.c2h6s.etstlib.tool.hooks.ModifyDamageSourceModifierHook;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.DoubleSupplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.weapon.MeleeHitToolHook;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class AttackUtil {
    private static final float DEGREE_TO_RADIANS = (float)Math.PI / 180;
    private static final AttributeModifier ANTI_KNOCKBACK_MODIFIER = new AttributeModifier("tconstruct.anti_knockback", 1.0, AttributeModifier.Operation.ADDITION);

    public static boolean attackEntity(IToolStackView tool, LivingEntity attacker, Entity target, float damageOffset, float damageModifier, boolean noToolDamage) {
        if (!ToolAttackUtil.canPerformAttack((IToolStackView)tool)) {
            return false;
        }
        EtSTLibToolAttackTweak.onStart(tool);
        return AttackUtil.performAttack(tool, ToolAttackContext.attacker((LivingEntity)attacker).target(target).cooldown(1.0f).applyAttributes().build(), damageOffset, damageModifier, noToolDamage);
    }

    public static boolean attackEntityExtra(IToolStackView tool, LivingEntity attacker, Entity target, float damageOffset, float damageModifier, boolean noToolDamage) {
        if (!ToolAttackUtil.canPerformAttack((IToolStackView)tool)) {
            return false;
        }
        EtSTLibToolAttackTweak.onStart(tool);
        return AttackUtil.performAttack(tool, ToolAttackContext.attacker((LivingEntity)attacker).target(target).cooldown(1.0f).applyAttributes().extraAttack().build(), damageOffset, damageModifier, noToolDamage);
    }

    public static boolean attackEntityWithBaseDamage(IToolStackView tool, LivingEntity attacker, Entity target, float damageSet, float damageModifier, boolean noToolDamage) {
        if (!ToolAttackUtil.canPerformAttack((IToolStackView)tool)) {
            return false;
        }
        EtSTLibToolAttackTweak.onStart(tool);
        ToolAttackContext context = ToolAttackContext.attacker((LivingEntity)attacker).target(target).cooldown(1.0f).applyAttributes().build();
        return AttackUtil.performAttack(tool, context, damageSet - context.getBaseDamage(), damageModifier, noToolDamage);
    }

    public static boolean attackEntityExtraWithBaseDamage(IToolStackView tool, LivingEntity attacker, Entity target, float damageSet, float damageModifier, boolean noToolDamage) {
        if (!ToolAttackUtil.canPerformAttack((IToolStackView)tool)) {
            return false;
        }
        EtSTLibToolAttackTweak.onStart(tool);
        ToolAttackContext context = ToolAttackContext.attacker((LivingEntity)attacker).target(target).extraAttack().cooldown(1.0f).applyAttributes().build();
        return AttackUtil.performAttack(tool, context, damageSet - context.getBaseDamage(), damageModifier, noToolDamage);
    }

    public static boolean performAttack(IToolStackView tool, ToolAttackContext context, float damageOffset, float damageModifier, boolean noToolDamage) {
        Player attackerPlayer;
        float baseKnockback;
        float cooldown;
        float baseDamage;
        EtSTLibToolAttackTweak.processContext(tool, context);
        float damage = baseDamage = context.getBaseDamage();
        damage += damageOffset;
        List modifiers = tool.getModifierList();
        for (ModifierEntry entry : modifiers) {
            damage = ((MeleeDamageModifierHook)entry.getHook(ModifierHooks.MELEE_DAMAGE)).getMeleeDamage(tool, entry, context, baseDamage, damage);
        }
        if (damage <= 0.0f) {
            EtSTLibToolAttackTweak.onEnd();
            return false;
        }
        boolean isMagic = damage > baseDamage;
        float criticalModifier = context.getCriticalModifier();
        if (criticalModifier != 1.0f) {
            damage += baseDamage * (criticalModifier - 1.0f);
        }
        if ((cooldown = context.getCooldown()) < 1.0f) {
            damage *= 0.2f + cooldown * cooldown * 0.8f;
        }
        float oldHealth = 0.0f;
        LivingEntity targetLiving = context.getLivingTarget();
        if (targetLiving != null) {
            oldHealth = targetLiving.m_21223_();
        }
        float knockback = baseKnockback = context.getBaseKnockback();
        for (ModifierEntry entry : modifiers) {
            knockback = ((MeleeHitModifierHook)entry.getHook(ModifierHooks.MELEE_HIT)).beforeMeleeHit(tool, entry, context, damage, baseKnockback, knockback);
        }
        LivingEntity attackerLiving = context.getAttacker();
        EquipmentSlot sourceSlot = context.getSlotType();
        ModifierLootingHandler.setLootingSlot((LivingEntity)attackerLiving, (EquipmentSlot)sourceSlot);
        AttributeInstance knockbackModifier = null;
        if (knockback < 0.4f) {
            knockbackModifier = ToolAttackUtil.disableKnockback((LivingEntity)targetLiving);
        } else if (targetLiving != null) {
            knockback -= 0.4f;
        }
        Projectile projectile = context.getProjectile();
        Entity targetEntity = context.getTarget();
        boolean isExtraAttack = context.isExtraAttack();
        EtSTLibToolAttackTweak.setCachedDamage(damage *= damageModifier);
        boolean didHit = isExtraAttack ? targetEntity.m_6469_(context.makeDamageSource(), damage) : MeleeHitToolHook.dealDamage((IToolStackView)tool, (ToolAttackContext)context, (float)damage);
        ModifierLootingHandler.setLootingSlot((LivingEntity)attackerLiving, (EquipmentSlot)EquipmentSlot.MAINHAND);
        if (knockbackModifier != null) {
            AttackUtil.enableKnockback(knockbackModifier);
        }
        Level level = context.getLevel();
        if (!didHit) {
            if (!isExtraAttack) {
                level.m_6263_(null, attackerLiving.m_20185_(), attackerLiving.m_20186_(), attackerLiving.m_20189_(), SoundEvents.f_12315_, attackerLiving.m_5720_(), 1.0f, 1.0f);
            }
            for (ModifierEntry entry : modifiers) {
                ((MeleeHitModifierHook)entry.getHook(ModifierHooks.MELEE_HIT)).failedMeleeHit(tool, entry, context, damage);
            }
            EtSTLibToolAttackTweak.onEnd();
            return false;
        }
        float damageDealt = damage;
        if (targetLiving != null) {
            damageDealt = oldHealth - targetLiving.m_21223_();
        }
        if (knockback > 0.0f) {
            if (targetLiving != null) {
                targetLiving.m_147240_((double)knockback, (double)Mth.m_14031_((float)(attackerLiving.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attackerLiving.m_146908_() * ((float)Math.PI / 180)))));
            } else {
                targetEntity.m_5997_((double)(-Mth.m_14031_((float)(attackerLiving.m_146908_() * ((float)Math.PI / 180))) * knockback), 0.1, (double)(Mth.m_14089_((float)(attackerLiving.m_146908_() * ((float)Math.PI / 180))) * knockback));
            }
            attackerLiving.m_20256_(attackerLiving.m_20184_().m_82542_(0.6, 1.0, 0.6));
            attackerLiving.m_6858_(false);
        }
        if (targetEntity.f_19864_ && targetEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)targetEntity;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(targetEntity));
            targetEntity.f_19864_ = false;
        }
        if ((attackerPlayer = context.getPlayerAttacker()) != null) {
            if (criticalModifier > 1.0f) {
                attackerPlayer.m_5704_(targetEntity);
            }
            if (isMagic) {
                attackerPlayer.m_5700_(targetEntity);
            }
            level.m_6263_(null, attackerLiving.m_20185_(), attackerLiving.m_20186_(), attackerLiving.m_20189_(), context.getSound(), attackerLiving.m_5720_(), 1.0f, 1.0f);
        }
        if (damageDealt > 2.0f && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            int particleCount = (int)(damageDealt * 0.5f);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123798_, targetEntity.m_20185_(), targetEntity.m_20227_(0.5), targetEntity.m_20189_(), particleCount, 0.1, 0.0, 0.1, 0.2);
        }
        attackerLiving.m_21335_(targetEntity);
        if (targetLiving != null) {
            EnchantmentHelper.m_44823_((LivingEntity)targetLiving, (Entity)attackerLiving);
        }
        for (ModifierEntry entry : modifiers) {
            ((MeleeHitModifierHook)entry.getHook(ModifierHooks.MELEE_HIT)).afterMeleeHit(tool, entry, context, damageDealt);
        }
        float speed = ((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_SPEED)).floatValue();
        int time = Math.round(20.0f / speed);
        if (time < targetEntity.f_19802_) {
            targetEntity.f_19802_ = (targetEntity.f_19802_ + time) / 2;
        }
        if (attackerPlayer != null) {
            if (targetLiving != null) {
                ItemStack held;
                if (!(level.f_46443_ || isExtraAttack || (held = attackerLiving.m_6844_(sourceSlot)).m_41619_())) {
                    held.m_41640_(targetLiving, attackerPlayer);
                }
                attackerPlayer.m_36222_(Stats.f_12928_, Math.round(damageDealt * 10.0f));
            }
            if (projectile == null) {
                attackerPlayer.m_36399_(0.1f);
            }
            if (!isExtraAttack && projectile == null) {
                attackerPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)tool.getItem()));
            }
        }
        if (!tool.hasTag(TinkerTags.Items.UNARMED) && !noToolDamage) {
            int durabilityLost;
            int n = durabilityLost = targetLiving != null ? 1 : 0;
            if (!tool.hasTag(TinkerTags.Items.MELEE_PRIMARY)) {
                durabilityLost *= 2;
            }
            if (projectile != null) {
                ToolDamageUtil.damage((IToolStackView)tool, (int)durabilityLost, (LivingEntity)attackerLiving, (ItemStack)attackerLiving.m_6844_(sourceSlot));
            } else {
                ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)durabilityLost, (LivingEntity)attackerLiving, (EquipmentSlot)sourceSlot);
            }
        }
        EtSTLibToolAttackTweak.onEnd();
        return true;
    }

    @Deprecated(forRemoval=true)
    public static boolean attackEntity(IToolStackView tool, LivingEntity attackerLiving, InteractionHand hand, Entity targetEntity, DoubleSupplier cooldownFunction, boolean isExtraAttack, EquipmentSlot sourceSlot, boolean setDamage, float damageSet, boolean noToolDamage) {
        DamageSource damageSource;
        boolean isMagic;
        SoundEvent sound;
        float cooldown;
        if (tool.isBroken() || !tool.hasTag(TinkerTags.Items.MELEE)) {
            return false;
        }
        Level level = attackerLiving.m_9236_();
        if (level.f_46443_ || !targetEntity.m_6097_() || targetEntity.m_7313_((Entity)attackerLiving)) {
            return true;
        }
        LivingEntity targetLiving = ToolAttackUtil.getLivingEntity((Entity)targetEntity);
        Player attackerPlayer = null;
        if (attackerLiving instanceof Player) {
            Player player;
            attackerPlayer = player = (Player)attackerLiving;
        }
        float damage = ToolAttackUtil.getAttributeAttackDamage((IToolStackView)tool, (LivingEntity)attackerLiving, (EquipmentSlot)sourceSlot);
        if (setDamage) {
            damage = damageSet;
        }
        boolean fullyCharged = (cooldown = (float)cooldownFunction.getAsDouble()) > 0.9f;
        boolean isCritical = !isExtraAttack && fullyCharged && attackerLiving.f_19789_ > 0.0f && !attackerLiving.m_20096_() && !attackerLiving.m_6147_() && !attackerLiving.m_20069_() && !attackerLiving.m_21023_(MobEffects.f_19610_) && !attackerLiving.m_20159_() && targetLiving != null && !attackerLiving.m_20142_();
        Iterator iterator = tool.getModifierList().iterator();
        if (iterator.hasNext()) {
            boolean setCritical;
            ModifierEntry entry = (ModifierEntry)iterator.next();
            isCritical = setCritical = ((CriticalAttackModifierHook)entry.getHook(EtSTLibHooks.CRITICAL_ATTACK)).setCritical(tool, entry, attackerLiving, hand, targetEntity, sourceSlot, fullyCharged, isExtraAttack, isCritical);
        }
        ToolAttackContext context = new ToolAttackContext(attackerLiving, attackerPlayer, hand, sourceSlot, targetEntity, targetLiving, isCritical, cooldown, isExtraAttack);
        float baseDamage = damage;
        List modifiers = tool.getModifierList();
        for (ModifierEntry entry : modifiers) {
            damage = ((MeleeDamageModifierHook)entry.getHook(ModifierHooks.MELEE_DAMAGE)).getMeleeDamage(tool, entry, context, baseDamage, damage);
        }
        if (damage <= 0.0f) {
            return !isExtraAttack;
        }
        float knockback = (float)attackerLiving.m_21133_(Attributes.f_22282_) / 2.0f;
        if (targetLiving != null) {
            knockback += 0.4f;
        }
        if (attackerLiving.m_20142_() && fullyCharged) {
            sound = SoundEvents.f_12314_;
            knockback += 0.5f;
        } else {
            sound = fullyCharged ? SoundEvents.f_12316_ : SoundEvents.f_12318_;
        }
        if (!isExtraAttack) {
            float criticalModifier;
            float f = criticalModifier = isCritical ? 1.5f : 1.0f;
            if (attackerPlayer != null) {
                CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)attackerPlayer, (Entity)targetEntity, (boolean)isCritical, (float)(isCritical ? 1.5f : 1.0f));
                boolean bl = isCritical = hitResult != null;
                if (isCritical) {
                    criticalModifier = hitResult.getDamageModifier();
                }
            }
            if (isCritical) {
                damage *= criticalModifier;
            }
        }
        boolean bl = isMagic = damage > baseDamage;
        if (cooldown < 1.0f) {
            damage *= 0.2f + cooldown * cooldown * 0.8f;
        }
        float oldHealth = 0.0f;
        if (targetLiving != null) {
            oldHealth = targetLiving.m_21223_();
        }
        float baseKnockback = knockback;
        for (ModifierEntry entry : modifiers) {
            knockback = ((MeleeHitModifierHook)entry.getHook(ModifierHooks.MELEE_HIT)).beforeMeleeHit(tool, entry, context, damage, baseKnockback, knockback);
        }
        ModifierLootingHandler.setLootingSlot((LivingEntity)attackerLiving, (EquipmentSlot)sourceSlot);
        Optional<AttributeInstance> knockbackModifier = AttackUtil.getKnockbackAttribute(targetLiving);
        boolean canceledKnockback = false;
        if (knockback < 0.4f) {
            canceledKnockback = true;
            knockbackModifier.ifPresent(AttackUtil::disableKnockback);
        } else if (targetLiving != null) {
            knockback -= 0.4f;
        }
        if (attackerLiving instanceof Player) {
            Player player = (Player)attackerLiving;
            damageSource = attackerLiving.m_269291_().m_269075_(player);
        } else {
            damageSource = attackerLiving.m_269291_().m_269333_(attackerLiving);
        }
        LegacyDamageSource source = LegacyDamageSource.any(damageSource);
        for (Object entry : tool.getModifierList()) {
            source = ((ModifyDamageSourceModifierHook)entry.getHook(EtSTLibHooks.MODIFY_DAMAGE_SOURCE)).modifyDamageSource(tool, (ModifierEntry)entry, attackerLiving, hand, targetEntity, sourceSlot, fullyCharged, isExtraAttack, isCritical, source);
        }
        boolean didHit = isExtraAttack ? AttackUtil.dealDefaultDamage(attackerLiving, targetEntity, damage, source) : AttackUtil.dealModifiedDamage(tool, context, damage, source);
        ModifierLootingHandler.setLootingSlot((LivingEntity)attackerLiving, (EquipmentSlot)EquipmentSlot.MAINHAND);
        if (canceledKnockback) {
            knockbackModifier.ifPresent(AttackUtil::enableKnockback);
        }
        if (!didHit) {
            if (!isExtraAttack) {
                level.m_6263_(null, attackerLiving.m_20185_(), attackerLiving.m_20186_(), attackerLiving.m_20189_(), SoundEvents.f_12315_, attackerLiving.m_5720_(), 1.0f, 1.0f);
            }
            for (ModifierEntry entry : modifiers) {
                ((MeleeHitModifierHook)entry.getHook(ModifierHooks.MELEE_HIT)).failedMeleeHit(tool, entry, context, damage);
            }
            return !isExtraAttack;
        }
        float damageDealt = damage;
        if (targetLiving != null) {
            damageDealt = oldHealth - targetLiving.m_21223_();
        }
        if (knockback > 0.0f) {
            if (targetLiving != null) {
                targetLiving.m_147240_((double)knockback, (double)Mth.m_14031_((float)(attackerLiving.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attackerLiving.m_146908_() * ((float)Math.PI / 180)))));
            } else {
                targetEntity.m_5997_((double)(-Mth.m_14031_((float)(attackerLiving.m_146908_() * ((float)Math.PI / 180))) * knockback), 0.1, (double)(Mth.m_14089_((float)(attackerLiving.m_146908_() * ((float)Math.PI / 180))) * knockback));
            }
            attackerLiving.m_20256_(attackerLiving.m_20184_().m_82542_(0.6, 1.0, 0.6));
            attackerLiving.m_6858_(false);
        }
        if (targetEntity.f_19864_ && targetEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)targetEntity;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(targetEntity));
            targetEntity.f_19864_ = false;
        }
        if (attackerPlayer != null) {
            if (isCritical) {
                sound = SoundEvents.f_12313_;
                attackerPlayer.m_5704_(targetEntity);
            }
            if (isMagic) {
                attackerPlayer.m_5700_(targetEntity);
            }
            level.m_6263_(null, attackerLiving.m_20185_(), attackerLiving.m_20186_(), attackerLiving.m_20189_(), sound, attackerLiving.m_5720_(), 1.0f, 1.0f);
        }
        if (damageDealt > 2.0f && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            int particleCount = (int)(damageDealt * 0.5f);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123798_, targetEntity.m_20185_(), targetEntity.m_20227_(0.5), targetEntity.m_20189_(), particleCount, 0.1, 0.0, 0.1, 0.2);
        }
        attackerLiving.m_21335_(targetEntity);
        if (targetLiving != null) {
            EnchantmentHelper.m_44823_((LivingEntity)targetLiving, (Entity)attackerLiving);
        }
        for (ModifierEntry entry : modifiers) {
            ((MeleeHitModifierHook)entry.getHook(ModifierHooks.MELEE_HIT)).afterMeleeHit(tool, entry, context, damageDealt);
        }
        float speed = ((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_SPEED)).floatValue();
        int time = Math.round(20.0f / speed);
        if (time < targetEntity.f_19802_) {
            targetEntity.f_19802_ = (targetEntity.f_19802_ + time) / 2;
        }
        if (attackerPlayer != null) {
            if (targetLiving != null) {
                ItemStack held;
                if (!isExtraAttack && !(held = attackerLiving.m_6844_(sourceSlot)).m_41619_()) {
                    held.m_41640_(targetLiving, attackerPlayer);
                }
                attackerPlayer.m_36222_(Stats.f_12928_, Math.round(damageDealt * 10.0f));
            }
            attackerPlayer.m_36399_(0.1f);
            if (!isExtraAttack) {
                attackerPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)tool.getItem()));
            }
        }
        if (!tool.hasTag(TinkerTags.Items.UNARMED) && !noToolDamage) {
            int durabilityLost;
            int n = durabilityLost = targetLiving != null ? 1 : 0;
            if (!tool.hasTag(TinkerTags.Items.MELEE_PRIMARY)) {
                durabilityLost *= 2;
            }
            ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)durabilityLost, (LivingEntity)attackerLiving);
        }
        return true;
    }

    private static Optional<AttributeInstance> getKnockbackAttribute(@Nullable LivingEntity living) {
        return Optional.ofNullable(living).map(e -> e.m_21051_(Attributes.f_22278_)).filter(attribute -> !attribute.m_22109_(ANTI_KNOCKBACK_MODIFIER));
    }

    private static void disableKnockback(AttributeInstance instance) {
        instance.m_22118_(ANTI_KNOCKBACK_MODIFIER);
    }

    private static void enableKnockback(AttributeInstance instance) {
        instance.m_22130_(ANTI_KNOCKBACK_MODIFIER);
    }

    public static boolean dealDefaultDamage(LivingEntity attacker, Entity target, float damage, LegacyDamageSource source) {
        return target.m_6469_((DamageSource)source, damage);
    }

    public static boolean dealModifiedDamage(IToolStackView tool, ToolAttackContext context, float damage, LegacyDamageSource source) {
        boolean hit = AttackUtil.dealDefaultDamage(context.getAttacker(), context.getTarget(), damage, source);
        if (hit) {
            ((MeleeHitToolHook)tool.getHook(ToolHooks.MELEE_HIT)).afterMeleeHit(tool, context, damage);
        }
        return hit;
    }

    public static boolean hurtEntity(LivingEntity living, float amount, DamageSource source) {
        if (living instanceof Player) {
            return false;
        }
        if (living.m_9236_().f_46443_) {
            return false;
        }
        if (living.m_21224_()) {
            return false;
        }
        if (living.m_5803_() && !living.m_9236_().f_46443_) {
            living.m_5796_();
        }
        living.m_21310_(0);
        boolean flag = false;
        living.f_267362_.m_267771_(1.5f);
        living.f_20898_ = amount;
        living.f_19802_ = 20;
        AttackUtil.actualHurtEntity(living, amount, source);
        living.f_20916_ = living.f_20917_ = 10;
        Entity entity1 = source.m_7639_();
        if (entity1 != null) {
            if (entity1 instanceof LivingEntity) {
                LivingEntity living1 = (LivingEntity)entity1;
                if (!source.m_269533_(DamageTypeTags.f_268718_)) {
                    living.m_6703_(living1);
                }
            }
            if (entity1 instanceof Player) {
                Player player1 = (Player)entity1;
                living.m_6598_(player1);
            }
        }
        living.m_9236_().m_269196_((Entity)living, source);
        if (living.m_21224_()) {
            living.m_6667_(source);
        }
        living.f_20958_ = source;
        living.f_20930_ = living.m_9236_().m_46467_();
        if (entity1 instanceof ServerPlayer) {
            CriteriaTriggers.f_10573_.m_60112_((ServerPlayer)entity1, entity1, source, amount, amount, flag);
        }
        return true;
    }

    public static void actualHurtEntity(LivingEntity living, float amount, DamageSource source) {
        if (amount <= 0.0f) {
            return;
        }
        living.m_21231_().m_289194_(source, amount);
        living.m_21153_(living.m_21223_() - amount);
        living.m_7911_(living.m_6103_() - amount);
        living.m_146850_(GameEvent.f_223706_);
    }

    public static boolean checkPlayer(Entity target, @Nullable Entity attacker) {
        if (!((Boolean)EtSTLibConfig.ALLOW_AOE_ATTACK_PLAYER.get()).booleanValue() && target instanceof Player) {
            return false;
        }
        if (attacker instanceof Player) {
            Player player1 = (Player)attacker;
            if (target instanceof Player) {
                Player player2 = (Player)target;
                return player1.m_7099_(player2);
            }
        }
        return true;
    }
}

