/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.tool.modifiers.base;

import com.c2h6s.etstlib.register.EtSTLibHooks;
import com.c2h6s.etstlib.register.EtSTLibToolStat;
import com.c2h6s.etstlib.tool.hooks.CustomBarDisplayModifierHook;
import com.c2h6s.etstlib.tool.modifiers.base.EtSTBaseModifier;
import com.c2h6s.etstlib.tool.modifiers.capabilityProvider.PnCIntegration.AirStorageProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ValidateModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;

public abstract class BasicPressurizableModifier
extends EtSTBaseModifier
implements ModifierRemovalHook,
TooltipModifierHook,
ToolStatsModifierHook,
CustomBarDisplayModifierHook,
ValidateModifierHook {
    public int getPriority() {
        return 20;
    }

    @Override
    protected void registerHooks(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.REMOVE, ModifierHooks.TOOLTIP, ModifierHooks.TOOL_STATS, EtSTLibHooks.CUSTOM_BAR, ModifierHooks.VALIDATE});
    }

    @Override
    @Nullable
    public Component onRemoved(@NotNull IToolStackView tool, @NotNull Modifier modifier) {
        if (AirStorageProvider.getMaxPressure(tool) <= 0.0f) {
            tool.getPersistentData().remove(AirStorageProvider.LOCATION_AIR_STORAGE);
        }
        return null;
    }

    @Nullable
    public Component validate(IToolStackView tool, ModifierEntry modifierEntry) {
        if (AirStorageProvider.getPressure(tool) > AirStorageProvider.getMaxPressure(tool)) {
            AirStorageProvider.setAir(tool, AirStorageProvider.getMaxVolume(tool));
        }
        return null;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifierEntry, @Nullable Player player, List<Component> list, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        ArrayList<MutableComponent> ls = new ArrayList<MutableComponent>(List.of());
        ls.add(Component.m_237115_((String)"tooltip.etstlib.base_volume").m_130946_(":").m_130946_(" " + AirStorageProvider.getBaseVolume(tool) + "mL").m_130948_(Style.f_131099_.m_178520_(0xBABABA)));
        ls.add(Component.m_237115_((String)"tooltip.etstlib.air").m_130946_(":").m_130946_(" " + AirStorageProvider.getAir(tool) + "mL").m_130948_(Style.f_131099_.m_178520_(0xBABABA)));
        ls.add(Component.m_237115_((String)"tooltip.etstlib.max_pressure").m_130946_(":").m_130946_(" " + String.format("%.1f", Float.valueOf((float)AirStorageProvider.getAir(tool) / (float)AirStorageProvider.getBaseVolume(tool))) + "/" + String.format("%.1f", Float.valueOf(AirStorageProvider.getMaxPressure(tool))) + "bar").m_130948_(Style.f_131099_.m_178520_(0xBABABA)));
        for (Component component : ls) {
            if (list.contains(component) || player == null) continue;
            list.add(component);
        }
    }

    public void addToolStats(IToolContext iToolContext, ModifierEntry modifierEntry, ModifierStatsBuilder modifierStatsBuilder) {
        EtSTLibToolStat.MAX_PRESSURE.add(modifierStatsBuilder, (double)this.getMaxPressure(modifierEntry));
        EtSTLibToolStat.BASIC_AIR_CAPACITY.add(modifierStatsBuilder, (double)this.getBaseVolume(modifierEntry));
    }

    public abstract int getBaseVolume(ModifierEntry var1);

    public abstract float getMaxPressure(ModifierEntry var1);

    @Override
    public boolean showBar(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
        return AirStorageProvider.getPressure(tool) > 0.0f;
    }

    @Override
    public int getBarRGB(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
        return -1;
    }

    @Override
    public Vec2 getBarXYSize(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
        float Pressure = AirStorageProvider.getPressure(tool);
        float maxPressure = AirStorageProvider.getMaxPressure(tool);
        if (maxPressure > 0.0f) {
            return new Vec2(Math.min(13.0f, 13.0f * Pressure / maxPressure), 1.0f);
        }
        return new Vec2(0.0f, 0.0f);
    }

    @Override
    public String barId(IToolStackView tool, ModifierEntry entry, int barsHadBeenShown) {
        return "etstlib:pressure_bar";
    }
}

