/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.event.eventHandler;

import com.c2h6s.etstlib.EtSTLibConfig;
import com.c2h6s.etstlib.api.interfaces.IRandomizeUuidWhenCrafted;
import com.c2h6s.etstlib.content.misc.vibration.ToolVibrationListener;
import com.c2h6s.etstlib.tool.hooks.LeftClickModifierHook;
import com.c2h6s.etstlib.util.IToolUuidGetter;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.library.tools.item.IModifiable;

@Mod.EventBusSubscriber(modid="etstlib", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerEvents {
    @SubscribeEvent
    public static void onLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack;
        Player player = event.getEntity();
        if (player != null && player.m_9236_().f_46443_ && (stack = player.m_21120_(player.m_7655_())).m_41720_() instanceof IModifiable) {
            EquipmentSlot slot = stack.getEquipmentSlot();
            LeftClickModifierHook.handleLeftClick(stack, player, slot);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        if (player != null) {
            BlockState state = player.m_9236_().m_8055_(pos);
            ItemStack stack = player.m_21120_(player.m_7655_());
            if (stack.m_41720_() instanceof IModifiable) {
                EquipmentSlot slot = stack.getEquipmentSlot();
                LeftClickModifierHook.handleLeftClickBlock(stack, player, slot, state, pos);
            }
        }
    }

    @SubscribeEvent
    public static void onLeftClickEntity(AttackEntityEvent event) {
        LeftClickModifierHook.handleLeftClickEntity(event.getEntity().m_21205_(), event.getEntity(), EquipmentSlot.MAINHAND, event.getTarget());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ToolVibrationListener.tickIfPresent(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ToolVibrationListener.removeAllAcceptor((Player)serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack stack = event.getCrafting();
        if (stack.m_41720_() instanceof IRandomizeUuidWhenCrafted) {
            IToolUuidGetter.getUuidOrRandomize(stack);
        } else if (stack.m_41720_() instanceof IModifiable && ((Boolean)EtSTLibConfig.ALLOW_TOOL_UUID_ON_COMMON_TOOL.get()).booleanValue() && (stack.m_41741_() <= 1 || ((Boolean)EtSTLibConfig.ALLOW_TOOL_UUID_ON_STACKABLE_TOOL.get()).booleanValue())) {
            IToolUuidGetter.getUuidOrRandomize(stack);
        }
    }
}

