/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.event.eventHandler;

import com.c2h6s.etstlib.register.EtSTLibEffects;
import com.c2h6s.etstlib.register.EtSTLibHooks;
import com.c2h6s.etstlib.tool.hooks.ArrowDamageModifierHook;
import com.c2h6s.etstlib.tool.hooks.IndividualProtectionModifierHook;
import com.c2h6s.etstlib.tool.hooks.ProjectileDamageModifierHook;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.HashMap;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

@Mod.EventBusSubscriber(modid="etstlib", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LivingEvents {
    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        LivingEntity livingEntity = event.getEntity();
        float amount = event.getAmount();
        if (livingEntity.m_21023_((MobEffect)EtSTLibEffects.FATAL_TRAUMA.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingDamageHigh(LivingDamageEvent event) {
        DamageSource source = event.getSource();
        Entity entity = source.m_7640_();
        if (!event.isCanceled() && entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            projectile.getPersistentData().m_128350_("etstlib_damage", event.getAmount());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingHurtHigh(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        Entity entity = source.m_7640_();
        if (!event.isCanceled() && entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            entity.getCapability(EntityModifierCapability.CAPABILITY).ifPresent(cap -> {
                ModDataNBT nbt = PersistentDataCapability.getOrWarn((Entity)entity);
                ModifierNBT modifiers = cap.getModifiers();
                float baseDamage = event.getAmount();
                AtomicDouble atomicDouble = new AtomicDouble((double)baseDamage);
                if (projectile instanceof AbstractArrow) {
                    AbstractArrow arrow = (AbstractArrow)projectile;
                    modifiers.forEach(entry -> {
                        LivingEntity living;
                        Entity patt3515$temp;
                        atomicDouble.set((double)((ArrowDamageModifierHook)entry.getHook(EtSTLibHooks.ARROW_DAMAGE)).getArrowDamage(nbt, (ModifierEntry)entry, modifiers, arrow, (patt3515$temp = source.m_7639_()) instanceof LivingEntity ? (living = (LivingEntity)patt3515$temp) : null, (Entity)event.getEntity(), baseDamage, atomicDouble.floatValue()));
                    });
                    event.setAmount(atomicDouble.floatValue());
                }
                modifiers.forEach(entry -> {
                    LivingEntity living;
                    AbstractArrow arrow;
                    Entity patt4035$temp = source.m_7639_();
                    atomicDouble.set((double)((ProjectileDamageModifierHook)entry.getHook(EtSTLibHooks.PROJECTILE_DAMAGE)).getProjectileDamage(nbt, (ModifierEntry)entry, modifiers, projectile, projectile instanceof AbstractArrow ? (arrow = (AbstractArrow)projectile) : null, patt4035$temp instanceof LivingEntity ? (living = (LivingEntity)patt4035$temp) : null, (Entity)event.getEntity(), baseDamage, atomicDouble.floatValue()));
                });
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onLivingHurtNormal(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        DamageSource source = event.getSource();
        HashMap protectionMap = new HashMap();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itS = living.m_6844_(slot);
            if (!(itS.m_41720_() instanceof IModifiable)) continue;
            ToolStack tool = ToolStack.from((ItemStack)itS);
            tool.getModifierList().forEach(entry -> {
                Player player;
                IndividualProtectionModifierHook hook = (IndividualProtectionModifierHook)entry.getHook(EtSTLibHooks.INDIVIDUAL_PROTECTION);
                String str = hook.getProtectionName((IToolStackView)tool, (ModifierEntry)entry, living instanceof Player ? (player = (Player)living) : null);
                if (str != null) {
                    EquipmentContext ctx = EquipmentContext.withTool((LivingEntity)living, (IToolStackView)tool, (EquipmentSlot)slot);
                    protectionMap.put(str, Float.valueOf(hook.getIndividualProtectionModifier((IToolStackView)tool, (ModifierEntry)entry, ctx, slot, source, protectionMap.getOrDefault(str, Float.valueOf(0.0f)).floatValue())));
                }
            });
        }
        protectionMap.values().stream().map(f -> Mth.m_14008_((double)f.floatValue(), (double)(-ProtectionModifierHook.getProtectionCap((LivingEntity)living)), (double)ProtectionModifierHook.getProtectionCap((LivingEntity)living))).map(Double::floatValue).forEach(value -> {
            float amount = event.getAmount();
            amount -= amount * (0.04f * value.floatValue());
            event.setAmount(amount);
        });
    }
}

