/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.content.misc;

import com.c2h6s.etstlib.entity.specialDamageSources.LegacyDamageSource;
import com.c2h6s.etstlib.mixin.TconMixin.ToolAttackContextBuilderAccessor;
import com.c2h6s.etstlib.mixinUtil.IToolAttackContextMixin;
import com.c2h6s.etstlib.register.EtSTLibHooks;
import com.c2h6s.etstlib.tool.hooks.CriticalAttackModifierHook;
import com.c2h6s.etstlib.tool.hooks.ModifyDamageSourceModifierHook;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class EtSTLibToolAttackTweak {
    @Nullable
    private static ToolAttackContext context = null;
    @Nullable
    private static IToolStackView tool = null;
    @Nullable
    private static ToolAttackContext.Builder contextBuilder;
    @Nullable
    private static LivingEntity attacker;
    @Nullable
    private static Entity target;
    private static boolean fullyCharged;
    private static float cachedDamage;

    public static void onStart(IToolStackView tool) {
        EtSTLibToolAttackTweak.tool = tool;
    }

    public static void buildCritical(ToolAttackContext.Builder builder) {
        contextBuilder = builder;
    }

    public static void initCritical(LivingEntity attacker, Entity target, boolean fullyCharged) {
        EtSTLibToolAttackTweak.attacker = attacker;
        EtSTLibToolAttackTweak.target = target;
        EtSTLibToolAttackTweak.fullyCharged = fullyCharged;
    }

    public static boolean processCritical(boolean isCritical) {
        if (tool == null) {
            return isCritical;
        }
        ToolAttackContextBuilderAccessor contextExtra = (ToolAttackContextBuilderAccessor)contextBuilder;
        for (ModifierEntry entry : tool.getModifierList()) {
            isCritical = ((CriticalAttackModifierHook)entry.getHook(EtSTLibHooks.CRITICAL_ATTACK)).setCritical(tool, entry, attacker, contextExtra.etstlib$getHand(), target, contextExtra.etstlib$getSlot(), fullyCharged, contextExtra.etstlib$getExtraAttack(), isCritical);
            if (!isCritical) continue;
            return true;
        }
        return isCritical;
    }

    public static void processContext(@NotNull IToolStackView tool, @NotNull ToolAttackContext context) {
        EtSTLibToolAttackTweak.tool = tool;
        EtSTLibToolAttackTweak.context = context;
        IToolAttackContextMixin contextExtra = (IToolAttackContextMixin)context;
        if (EtSTLibToolAttackTweak.isToolAvailable()) {
            if (context.isCritical()) {
                float originalModifier;
                float modifier = originalModifier = 1.5f;
                for (ModifierEntry entry : tool.getModifierList()) {
                    modifier = ((CriticalAttackModifierHook)entry.getHook(EtSTLibHooks.CRITICAL_ATTACK)).getCriticalModifier(tool, entry, context, originalModifier, modifier);
                }
                contextExtra.etstlib$setCriticalModifier(modifier);
            }
            LegacyDamageSource source = LegacyDamageSource.any(context.makeDamageSource());
            for (ModifierEntry entry : tool.getModifierList()) {
                source = ((ModifyDamageSourceModifierHook)entry.getHook(EtSTLibHooks.MODIFY_DAMAGE_SOURCE)).modifyDamageSource(tool, entry, context.getAttacker(), context.getHand(), context.getTarget(), context.getSlotType(), context.isFullyCharged(), context.isExtraAttack(), context.isCritical(), source);
            }
            contextExtra.etstlib$setLegacySource(source);
        }
    }

    public static void onEnd() {
        context = null;
        tool = null;
        contextBuilder = null;
        attacker = null;
        target = null;
        cachedDamage = 0.0f;
    }

    public static boolean isToolAvailable() {
        return tool != null;
    }

    public static boolean isContextAvailable() {
        return context != null;
    }

    public static void setCachedDamage(float cachedDamage) {
        EtSTLibToolAttackTweak.cachedDamage = cachedDamage;
    }

    public static float getCachedDamage() {
        return cachedDamage;
    }

    static {
        cachedDamage = 0.0f;
    }
}

