/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.debug;

import com.simibubi.create.content.trains.entity.Carriage;
import de.mrjulsen.crn.data.train.ScheduleSection;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.mixin.ScheduleRuntimeAccessor;
import de.mrjulsen.crn.mixin.TrainStatusAccessor;
import de.mrjulsen.crn.util.ESpeedUnit;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.client.OverlayManager;
import de.mrjulsen.mcdragonlib.client.gui.DLOverlayScreen;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class DebugOverlay
extends DLOverlayScreen {
    private static long debugOverlayId = -1L;
    int line = 0;
    int trainIndex = 0;
    int lastKey = -1;

    public static void toggle() {
        OverlayManager.remove((long)debugOverlayId);
        debugOverlayId = debugOverlayId == -1L ? OverlayManager.add((DLOverlayScreen)new DebugOverlay()) : -1L;
    }

    public void render(Graphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(0.75f, 0.75f, 0.75f);
        this.line = 0;
        if (!TrainListener.getAllTrainData().isEmpty()) {
            this.trainIndex %= TrainListener.getAllTrainData().size();
            TrainData data = TrainListener.getAllTrainData().stream().skip(this.trainIndex).findFirst().get();
            this.drawLine(graphics, data.getTrain().name.getString() + " (" + (data.isPreInitializationPhase() ? "PREPARING" : (data.isInitialized() ? "READY" : "INITIALIZING")) + ") Train Id: " + String.valueOf(data.getTrainId()) + ", SessionId: " + String.valueOf(data.getSessionId()));
            this.drawLine(graphics, "Display: " + data.getCurrentSection().getDisplayText() + ", Title: " + data.getCurrentTitle() + ", IsDynamic: " + data.isDynamic());
            this.drawLine(graphics, "Track: " + !((TrainStatusAccessor)data.getTrain().status).crn$track() + ", Conductor: " + !((TrainStatusAccessor)data.getTrain().status).crn$conductor() + ", Navigation: " + !((TrainStatusAccessor)data.getTrain().status).crn$navigation() + ", Paused: " + data.getTrain().runtime.paused + ", Auto: " + data.getTrain().runtime.isAutoSchedule + ", Manual: " + data.isManualControlled + ", Cancelled: " + data.isCancelled());
            this.drawLine(graphics, "Duration: " + data.getTotalDuration() + ", Ticks: " + data.getTransitTicks() + "/" + data.waitingAtStationTicks() + "/" + data.waitingForSignalTicks + "/" + data.ticksToNextStop + ", Dest: " + (String)(data.getTrain().navigation.destination == null ? "(at station)" : data.getTrain().navigation.destination.name + ", DestID: " + String.valueOf(data.getTrain().navigation.destination.id)) + ", Delay: " + data.getHighestDeviation() + " (-" + data.getDeviationDelayOffset() + "), Status: " + data.debug_statusInfoCount());
            boolean stalled = false;
            for (int i = 0; i < data.getTrain().carriages.size(); ++i) {
                Carriage carriage = (Carriage)data.getTrain().carriages.get(i);
                if (!carriage.stalled) continue;
                stalled = true;
                break;
            }
            this.drawLine(graphics, (Component)TextUtils.text((String)("Speed: " + (int)ModUtils.calcSpeed(data.getTrain().speed, ESpeedUnit.MS) + " / " + (int)ModUtils.calcSpeed(data.getTrain().targetSpeed, ESpeedUnit.MS) + ", Waiting: " + String.valueOf(data.getTrain().navigation.waitingForSignal == null ? "No" : (Serializable)data.getTrain().navigation.waitingForSignal.getSecond()) + " (" + data.getTrain().navigation.ticksWaitingForSignal + "/" + String.valueOf(data.waitingForSignalId) + "), Stalled: " + stalled + " (" + data.getTrain().speedBeforeStall + ")")).m_130940_(data.getTrain().navigation.waitingForSignal == null ? ChatFormatting.RESET : ChatFormatting.RED));
            this.drawLine(graphics, (Component)TextUtils.text((String)"Predictions:").m_130940_(ChatFormatting.UNDERLINE));
            data.getPredictions().forEach(a -> this.drawLine(graphics, (Component)TextUtils.text((String)" - ").m_7220_(a.formattedText())));
            StringBuilder builder = new StringBuilder();
            builder.append("[ " + data.getCurrentScheduleIndex() + " ]: ");
            data.getPredictionsChronologically().forEach(a -> {
                if (a == null) {
                    return;
                }
                builder.append(" > " + a.getTargetedStationName() + " (" + a.realTime().arrivalIn() + ")");
            });
            this.drawLine(graphics, builder.toString());
            this.drawLine(graphics, (Component)TextUtils.text((String)"Transit Times:").m_130940_(ChatFormatting.UNDERLINE));
            for (TrainPrediction prediction : data.getPredictions()) {
                String suffix = String.join((CharSequence)" | ", Arrays.stream(prediction.transitTime().history()).map(x -> String.valueOf(x)).toList());
                this.drawLine(graphics, " - [ " + prediction.getEntryIndex() + " ]: C: " + prediction.transitTime().value() + ", L: " + prediction.transitTime().measuredValue() + ", H: [" + suffix + "]");
            }
            this.drawLine(graphics, "C: " + String.join((CharSequence)" | ", ((ScheduleRuntimeAccessor)data.getTrain().runtime).crn$getTransitTicks().stream().map(x -> String.valueOf(x)).toList()));
            this.drawLine(graphics, (Component)TextUtils.text((String)"Sections:").m_130940_(ChatFormatting.UNDERLINE));
            for (ScheduleSection section : data.getSections()) {
                this.drawLine(graphics, " - [ " + section.getScheduleIndex() + " ]: " + section.getDisplayText() + " (" + section.getStartStationName() + " -> " + section.getDestinationStationName() + "), Category: " + section.getTrainCategory().map(x -> x.getCategoryName()).orElse("none") + ", Line: " + section.getTrainLine().map(x -> x.getLineName()).orElse("none") + ", Include: " + section.shouldIncludeNextStationOfNextSection() + ", Navigable: " + section.isUsable() + ", Next: " + section.nextSection().getScheduleIndex());
            }
            this.drawLine(graphics, "[ " + data.getCurrentSection().getScheduleIndex() + " ]");
        }
        this.drawLine(graphics, (Component)TextUtils.text((String)"Press K to switch train.").m_130940_(ChatFormatting.AQUA));
        graphics.poseStack().m_85849_();
    }

    private void drawLine(Graphics graphics, String str) {
        this.drawLine(graphics, (Component)TextUtils.text((String)str));
    }

    private void drawLine(Graphics graphics, Component str) {
        int x = 2;
        int y = 2;
        Objects.requireNonNull(this.getFont());
        int n = this.getFont().m_92852_((FormattedText)str) + 2;
        Objects.requireNonNull(this.getFont());
        GuiUtils.fill((Graphics)graphics, (int)(x - 1), (int)(y - 1 + this.line * (9 + 2)), (int)n, (int)(9 + 2), (int)0x44000000);
        Font font = this.getFont();
        Objects.requireNonNull(this.getFont());
        GuiUtils.drawString((Graphics)graphics, (Font)font, (int)x, (int)(y + 1 + this.line * (9 + 2)), (FormattedText)str, (int)-1, (EAlignment)EAlignment.LEFT, (boolean)true);
        ++this.line;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.lastKey != pKeyCode) {
            this.lastKey = pKeyCode;
        } else if (this.lastKey == pKeyCode) {
            this.lastKey = -1;
            if (pKeyCode == 75) {
                ++this.trainIndex;
                return true;
            }
        }
        if (pKeyCode == 80) {
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }
}

