/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train.portable;

import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.TrainExitSide;
import de.mrjulsen.crn.data.train.ScheduleSection;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.data.train.portable.BasicTrainDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainStopDisplayData;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.data.Single;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class TrainDisplayData {
    private final BasicTrainDisplayData trainData;
    private final List<TrainStopDisplayData> stops;
    private final int currentScheduleIndex;
    private final double speed;
    private final boolean oppositeDirection;
    private final TrainExitSide exitSide;
    private final boolean isWaitingAtStation;
    private final State state;
    private final Cache<Pair<Integer, List<TrainStopDisplayData>>> stopsFromHere;
    private final Cache<List<TrainStopDisplayData>> stopovers;
    private static final String NBT_TRAIN = "Train";
    private static final String NBT_STOPS = "Stops";
    private static final String NBT_INDEX = "CurrentIndex";
    private static final String NBT_SPEED = "Speed";
    private static final String NBT_OPPOSITE_DIRECTION = "Opposite";
    private static final String NBT_EXIT_SIDE = "ExitSide";
    private static final String NBT_AT_STATION = "AtStation";
    private static final String NBT_OUT_OF_SERVICE = "OutOfService";
    private static final String NBT_DO_NOT_BOARD = "DoNotBoard";
    private static final String NBT_STATE = "State";

    private TrainDisplayData() {
        this.trainData = BasicTrainDisplayData.empty();
        this.stops = List.of();
        this.currentScheduleIndex = -1;
        this.speed = 0.0;
        this.oppositeDirection = false;
        this.exitSide = TrainExitSide.UNKNOWN;
        this.stopsFromHere = new Cache(() -> Pair.of((Object)0, List.of()));
        this.stopovers = new Cache(() -> List.of());
        this.isWaitingAtStation = false;
        this.state = State.OUT_OF_SERVICE;
    }

    public TrainDisplayData(BasicTrainDisplayData trainData, List<TrainStopDisplayData> stops, int currentScheduleIndex, TrainExitSide exitSide, double speed, boolean oppositeDirection, boolean isWaitingAtStation, State state) {
        this.trainData = trainData;
        this.stops = stops;
        this.currentScheduleIndex = currentScheduleIndex;
        this.speed = speed;
        this.oppositeDirection = oppositeDirection;
        this.exitSide = exitSide;
        this.stopsFromHere = new Cache(() -> {
            boolean startFound = false;
            ArrayList<TrainStopDisplayData> list = new ArrayList<TrainStopDisplayData>();
            int targetIndex = this.getCurrentScheduleIndex();
            int idx = 0;
            int startIndex = -1;
            int lastIdx = -1;
            for (int i = 0; i < this.getAllStops().size(); ++i) {
                TrainStopDisplayData stop = this.getAllStops().get(i);
                int stopIdx = stop.getStationEntryIndex();
                if (startIndex < 0) {
                    startIndex = stopIdx;
                }
                if (lastIdx > stopIdx) {
                    startIndex = 0;
                }
                if (!startFound && targetIndex >= startIndex && stopIdx >= targetIndex) {
                    startFound = true;
                    idx = i;
                }
                lastIdx = stopIdx;
                if (!startFound) continue;
                list.add(stop);
            }
            return Pair.of((Object)idx, list);
        });
        this.isWaitingAtStation = isWaitingAtStation && (((List)((Pair)this.stopsFromHere.get()).getSecond()).isEmpty() || ((TrainStopDisplayData)((List)((Pair)this.stopsFromHere.get()).getSecond()).get(0)).getStationEntryIndex() == this.getCurrentScheduleIndex());
        this.stopovers = new Cache(() -> this.getStopsFromCurrentStation().size() > (isWaitingAtStation ? 2 : 1) ? this.getStopsFromCurrentStation().stream().limit(this.getStopsFromCurrentStation().size() - 1).skip(isWaitingAtStation ? 1L : 0L).toList() : List.of());
        this.state = state;
    }

    public static TrainDisplayData empty() {
        return new TrainDisplayData();
    }

    public static TrainDisplayData of(Train train) throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        if (train.runtime.getSchedule() == null) {
            return TrainDisplayData.empty();
        }
        return TrainListener.getTrainData(train.id).map(data -> {
            boolean isLastStationInSection;
            Single.MutableSingle sideHolder = new Single.MutableSingle(null);
            ModCommonEvents.getCurrentServer().ifPresent(x -> {
                x.execute(() -> sideHolder.setFirst((Object)TrainUtils.getExitSide(train.navigation.destination)));
                while (sideHolder.getFirst() == null) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
            TrainExitSide side = sideHolder.getFirst() == null ? TrainExitSide.UNKNOWN : (TrainExitSide)((Object)((Object)sideHolder.getFirst()));
            ScheduleSection section = data.getCurrentSection();
            ScheduleSection prevSection = section.previousSection();
            ScheduleSection selectedSection = section;
            boolean isAtStation = data.waitingAtStationIndex == data.getCurrentScheduleIndex();
            boolean isFirstStationInSection = section.getFirstStop().map(x -> x.getEntryIndex() == data.getCurrentScheduleIndex()).orElse(false);
            if (isFirstStationInSection) {
                isLastStationInSection = prevSection.isUsable() && prevSection.getFinalStop().map(x -> x.getEntryIndex() == data.getCurrentScheduleIndex()).orElse(false) != false;
            } else {
                boolean bl = isLastStationInSection = section.isUsable() && section.getFinalStop().map(x -> x.getEntryIndex() == data.getCurrentScheduleIndex()).orElse(false) != false;
            }
            if (isFirstStationInSection && !isAtStation && prevSection.shouldIncludeNextStationOfNextSection()) {
                selectedSection = prevSection;
            }
            ArrayList<TrainStopDisplayData> displayData = new ArrayList<TrainStopDisplayData>();
            if (selectedSection.isUsable()) {
                List<TrainPrediction> predictions = selectedSection.getPredictions(-1, false);
                for (TrainPrediction prediction : predictions) {
                    displayData.add(TrainStopDisplayData.of(new TrainStop(prediction)));
                }
            }
            boolean preStart = isFirstStationInSection && (!prevSection.shouldIncludeNextStationOfNextSection() || !prevSection.isUsable()) && !isAtStation;
            boolean nextStopTerminus = false;
            if (isLastStationInSection) {
                nextStopTerminus = isFirstStationInSection ? !prevSection.shouldIncludeNextStationOfNextSection() || !section.isUsable() || !isAtStation : !section.shouldIncludeNextStationOfNextSection() || !section.nextSection().isUsable();
            }
            boolean atTerminus = nextStopTerminus && isAtStation;
            boolean teminusAnnounced = nextStopTerminus && data.getNextStopPrediction().map(x -> x.realTime().arrivalIn() < (long)((Integer)ModClientConfig.NEXT_STOP_ANNOUNCEMENT.get()).intValue()).orElse(false) != false;
            State state = State.OUT_OF_SERVICE;
            if (preStart) {
                state = State.BEFORE_START;
            } else if (atTerminus) {
                state = State.AT_TERMINUS;
            } else if (teminusAnnounced) {
                state = State.TERMINUS_ANNOUNCED;
            } else if (nextStopTerminus) {
                state = State.BEFORE_TERMINUS;
            } else if (selectedSection.isUsable()) {
                state = State.RUNNING;
            }
            return new TrainDisplayData(BasicTrainDisplayData.of(train.id), displayData, data.getCurrentScheduleIndex(), side, train.speed, train.currentlyBackwards, isAtStation, state);
        }).orElse(TrainDisplayData.empty());
    }

    public BasicTrainDisplayData getTrainData() {
        return this.trainData;
    }

    public List<TrainStopDisplayData> getAllStops() {
        return this.stops;
    }

    public List<TrainStopDisplayData> getStopsFromCurrentStation() {
        return (List)((Pair)this.stopsFromHere.get()).getSecond();
    }

    public int getCurrentStopIndex() {
        return (Integer)((Pair)this.stopsFromHere.get()).getFirst();
    }

    public List<TrainStopDisplayData> getStopovers() {
        return (List)this.stopovers.get();
    }

    public double getSpeed() {
        return this.speed;
    }

    public boolean isOppositeDirection() {
        return this.oppositeDirection;
    }

    public TrainExitSide getNextStopExitSide() {
        return this.exitSide;
    }

    public boolean isWaitingAtStation() {
        return this.isWaitingAtStation;
    }

    public State getState() {
        return this.state;
    }

    public int getCurrentScheduleIndex() {
        return this.currentScheduleIndex;
    }

    public Optional<TrainStopDisplayData> getCurrentStop() {
        int idx = this.getCurrentStopIndex() - (this.isWaitingAtStation() ? 0 : 1);
        if (idx < 0 || idx >= this.getAllStops().size()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getAllStops().get(idx));
    }

    public Optional<TrainStopDisplayData> getNextStop() {
        return !this.getStopsFromCurrentStation().isEmpty() ? Optional.of(this.getStopsFromCurrentStation().get(0)) : Optional.empty();
    }

    public Optional<TrainStopDisplayData> getFinalStop() {
        return !this.getStopsFromCurrentStation().isEmpty() ? Optional.of(this.getStopsFromCurrentStation().get(this.getStopsFromCurrentStation().size() - 1)) : Optional.empty();
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        ListTag stopsList = new ListTag();
        List<TrainStopDisplayData> allStops = this.getAllStops();
        for (TrainStopDisplayData stop : allStops) {
            stopsList.add((Object)stop.toNbt());
        }
        nbt.m_128365_(NBT_TRAIN, (Tag)this.trainData.toNbt());
        nbt.m_128365_(NBT_STOPS, (Tag)stopsList);
        nbt.m_128405_(NBT_INDEX, this.currentScheduleIndex);
        nbt.m_128347_(NBT_SPEED, this.speed);
        nbt.m_128379_(NBT_OPPOSITE_DIRECTION, this.oppositeDirection);
        nbt.m_128344_(NBT_EXIT_SIDE, this.exitSide.getAsByte());
        nbt.m_128379_(NBT_AT_STATION, this.isWaitingAtStation);
        nbt.m_128405_(NBT_STATE, this.state.id());
        return nbt;
    }

    public static TrainDisplayData fromNbt(CompoundTag nbt) {
        if (nbt.m_128471_(NBT_OUT_OF_SERVICE) && !nbt.m_128471_(NBT_DO_NOT_BOARD)) {
            return new TrainDisplayData();
        }
        return new TrainDisplayData(BasicTrainDisplayData.fromNbt(nbt.m_128469_(NBT_TRAIN)), nbt.m_128437_(NBT_STOPS, 10).stream().map(x -> TrainStopDisplayData.fromNbt((CompoundTag)x)).toList(), nbt.m_128451_(NBT_INDEX), TrainExitSide.getFromByte(nbt.m_128445_(NBT_EXIT_SIDE)), nbt.m_128459_(NBT_SPEED), nbt.m_128471_(NBT_OPPOSITE_DIRECTION), nbt.m_128471_(NBT_AT_STATION), State.getById(nbt.m_128451_(NBT_STATE)));
    }

    public static enum State {
        RUNNING(0),
        OUT_OF_SERVICE(1),
        AT_TERMINUS(2),
        BEFORE_TERMINUS(3),
        TERMINUS_ANNOUNCED(4),
        BEFORE_START(5);

        private final int id;

        private State(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static State getById(int id) {
            return Arrays.stream(State.values()).filter(x -> x.id() == id).findFirst().orElse(OUT_OF_SERVICE);
        }

        public boolean isOutOfService() {
            return this == OUT_OF_SERVICE || this == BEFORE_START;
        }

        public boolean isTerminating() {
            return this == AT_TERMINUS || this == BEFORE_TERMINUS || this == TERMINUS_ANNOUNCED;
        }

        public boolean isAboutToStart() {
            return this == BEFORE_START;
        }

        public boolean shouldNotBoard() {
            return this == AT_TERMINUS || this == TERMINUS_ANNOUNCED || this.isAboutToStart();
        }

        public boolean isIrregular() {
            return this.shouldNotBoard() || this.isAboutToStart() || this.isOutOfService();
        }
    }
}

