/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ValueWatcher {
    private final int threshold;
    private final int bufferSize;
    private final Runnable updateValue;
    private int value;
    private int measuredValue = -1;
    private final Queue<Integer> valueHistory = new ConcurrentLinkedQueue<Integer>();

    public ValueWatcher(int threshold, int bufferSize, Runnable updateValue) {
        this.threshold = threshold;
        this.bufferSize = bufferSize;
        this.updateValue = updateValue;
    }

    public void fillHistory(int value) {
        this.valueHistory.clear();
        for (int i = 0; i < this.bufferSize; ++i) {
            this.valueHistory.add(value);
        }
    }

    public void forceValue(int value) {
        this.fillHistory(value);
        this.measuredValue = value;
        this.value = value;
    }

    public void add(int value, boolean initializeOnly) {
        if (this.value <= 0) {
            this.forceValue(value);
            DLUtils.doIfNotNull((Object)this.updateValue, Runnable::run);
        }
        if (initializeOnly) {
            return;
        }
        this.measuredValue = value;
        while (this.valueHistory.size() >= this.bufferSize) {
            this.valueHistory.poll();
        }
        this.valueHistory.add(value);
        int refCurrentTransitTime = this.value;
        double median = ModUtils.calculateMedian(this.valueHistory, this.threshold, x -> true);
        if (Math.abs((double)refCurrentTransitTime - median) > (double)this.threshold) {
            int newValue = ModUtils.calculateMedian(this.valueHistory, this.threshold, x -> Math.abs(refCurrentTransitTime - x) > this.threshold);
            this.forceValue(newValue);
            DLUtils.doIfNotNull((Object)this.updateValue, Runnable::run);
        } else if (Math.abs(refCurrentTransitTime - value) < this.threshold) {
            this.fillHistory(refCurrentTransitTime);
        }
    }

    public void tick() {
        ++this.measuredValue;
    }

    public int treshold() {
        return this.threshold;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public int value() {
        return this.value;
    }

    public int measuredValue() {
        return this.measuredValue;
    }

    public Integer[] history() {
        return this.valueHistory.toArray(new Integer[0]);
    }

    public boolean isInitialized() {
        return this.history().length > 0 && this.value() > 0 && this.measuredValue() >= 0;
    }
}

