/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.routedetails;

import de.mrjulsen.crn.client.gui.widgets.routedetails.RoutePartEntryWidget;
import de.mrjulsen.crn.client.gui.widgets.routedetails.RoutePartTrainDetailsWidget;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.data.train.ClientTrainStop;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.DLWidgetsCollection;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class RoutePartWidget
extends DLWidgetContainer {
    private final ClientRoutePart part;
    private final ClientRoute route;
    private int stackLayoutY;
    private boolean expanded;
    private boolean canExpandCollapse = true;
    private boolean showTrainDetails = true;
    private boolean showJourney = false;
    private Consumer<RoutePartWidget> onGuiChanged;
    private final DLWidgetsCollection stationWidgets = new DLWidgetsCollection();
    private final Screen parent;
    public static final int ACTION_BTN_WIDTH = 140;
    public static final int ACTION_BTN_HEIGHT = 14;

    public RoutePartWidget(Screen parent, int x, int y, int width, ClientRoute route, ClientRoutePart part) {
        super(x, y, width, 1);
        this.part = part;
        this.route = route;
        this.parent = parent;
        this.initGui();
    }

    public void initGui() {
        this.clearWidgets();
        this.stackLayoutY = 0;
        this.stationWidgets.clear();
        boolean valid = this.route.isPartReachable(this.part);
        List<ClientTrainStop> stops = this.showJourney ? this.part.getAllJourneyClientStops() : this.part.getAllClientStops();
        this.addToStackLayout(new RoutePartEntryWidget(this.parent, this.part, stops.get(0), this.x(), this.y() + this.stackLayoutY, this.width(), RoutePartEntryWidget.TrainStopType.START, valid));
        if (this.showTrainDetails()) {
            RoutePartTrainDetailsWidget details = new RoutePartTrainDetailsWidget(this.parent, this, this.route, this.part, stops.get(0), this.x(), this.y() + this.stackLayoutY, this.width());
            this.addToStackLayout(details);
        }
        if (this.expanded) {
            for (int i = 1; i < stops.size() - 1; ++i) {
                ClientTrainStop stop = stops.get(i);
                this.addToStackLayout(new RoutePartEntryWidget(this.parent, this.part, stop, this.x(), this.y() + this.stackLayoutY, this.width(), RoutePartEntryWidget.TrainStopType.TRANSIT, valid));
            }
        }
        this.addToStackLayout(new RoutePartEntryWidget(this.parent, this.part, stops.get(stops.size() - 1), this.x(), this.y() + this.stackLayoutY, this.width(), RoutePartEntryWidget.TrainStopType.END, valid));
        this.set_height(this.stackLayoutY);
        DLUtils.doIfNotNull(this.onGuiChanged, x -> x.accept(this));
    }

    public RoutePartWidget withOnGuiChangedEvent(Consumer<RoutePartWidget> onGuiChanged) {
        this.onGuiChanged = onGuiChanged;
        return this;
    }

    public void updateHeight() {
        this.stackLayoutY = 0;
        for (IDragonLibWidget c : this.stationWidgets.components) {
            c.set_y(this.y() + this.stackLayoutY);
            this.stackLayoutY += c.height();
        }
    }

    private <T extends GuiEventListener & Renderable> void addToStackLayout(T widget) {
        this.addRenderableWidget(widget);
        this.stationWidgets.add(widget);
        this.stackLayoutY += ((IDragonLibWidget)widget).height();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean b) {
        this.expanded = b;
        this.initGui();
    }

    public boolean canExpandCollapse() {
        return this.canExpandCollapse;
    }

    public void setCanExpandCollapse(boolean canExpandCollapse) {
        this.canExpandCollapse = canExpandCollapse;
    }

    public boolean showTrainDetails() {
        return this.showTrainDetails;
    }

    public void setShowTrainDetails(boolean showTrainDetails) {
        this.showTrainDetails = showTrainDetails;
    }

    public boolean isShowingJourney() {
        return this.showJourney;
    }

    public void setShowJourney(boolean showJourney) {
        this.showJourney = showJourney;
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public void m_94120_() {
        super.m_94120_();
        boolean valid = this.route.isPartReachable(this.part);
        this.stationWidgets.performForEach(x -> x instanceof RoutePartEntryWidget, x -> ((RoutePartEntryWidget)((Object)x)).setValid(valid));
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }

    public record RoutePartDetailsActionBuilder(Component text, Sprite icon, Consumer<DLIconButton> onClick) {
    }
}

