/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.blockentity;

import com.simibubi.create.content.trains.display.FlapDisplayBlock;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import de.mrjulsen.crn.block.AbstractAdvancedDisplayBlock;
import de.mrjulsen.crn.block.blockentity.IContraptionBlockEntity;
import de.mrjulsen.crn.block.blockentity.IMultiblockBlockEntity;
import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.IPlatformWidthSetting;
import de.mrjulsen.crn.block.display.properties.components.ITimeDisplaySetting;
import de.mrjulsen.crn.block.display.properties.components.ITrainNameWidthSetting;
import de.mrjulsen.crn.block.properties.EDisplayInfo;
import de.mrjulsen.crn.block.properties.EDisplayType;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.AdvancedDisplaysRegistry;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.data.CarriageData;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TrainExitSide;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.data.train.portable.StationDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainStopDisplayData;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.crn.registry.ModDisplayTypes;
import de.mrjulsen.mcdragonlib.block.IBERInstance;
import de.mrjulsen.mcdragonlib.client.ber.IBlockEntityRendererInstance;
import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.data.Tripple;
import de.mrjulsen.mcdragonlib.util.ListUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class AdvancedDisplayBlockEntity
extends SmartBlockEntity
implements IMultiblockBlockEntity<AdvancedDisplayBlockEntity, AbstractAdvancedDisplayBlock>,
IContraptionBlockEntity<AdvancedDisplayBlockEntity>,
IBERInstance<AdvancedDisplayBlockEntity> {
    private static final String NBT_DISPLAY_TYPE_SETTINGS = "DisplaySettings";
    private static final String NBT_FILTER = "Filter";
    private static final String NBT_XSIZE = "XSize";
    private static final String NBT_YSIZE = "YSize";
    private static final String NBT_CONTROLLER = "IsController";
    private static final String NBT_GLOWING = "Glowing";
    private static final String NBT_LAST_REFRESH_TIME = "LastRefreshed";
    private static final String NBT_TRAIN_STOPS = "TrainStops";
    @Deprecated
    private static final String LEGACY_NBT_PLATFORM_WIDTH = "PlatformWidth";
    @Deprecated
    private static final String LEGACY_NBT_TRAIN_NAME_WIDTH = "TrainNameWidth";
    @Deprecated
    private static final String LEGACY_NBT_COLOR = "Color";
    @Deprecated
    private static final String LEGACY_NBT_TIME_DISPLAY = "TimeDisplay";
    @Deprecated
    private static final String LEGACY_NBT_DISPLAY_TYPE_KEY = "DisplayTypeKey";
    @Deprecated
    private static final String LEGACY_NBT_INFO_TYPE = "InfoType";
    @Deprecated
    private static final String LEGACY_NBT_DISPLAY_TYPE = "DisplayType";
    public static final byte MAX_XSIZE = 16;
    public static final byte MAX_YSIZE = 16;
    private static final int REFRESH_FREQUENCY = 100;
    private AdvancedDisplaysRegistry.DisplayTypeResourceKey displayTypeId = ModDisplayTypes.TRAIN_DESTINATION_SIMPLE;
    private byte xSize = 1;
    private byte ySize = 1;
    private boolean isController;
    private List<StationDisplayData> predictions;
    private boolean dataOrderChanged = false;
    private String stationNameFilter;
    private StationTag.StationInfo stationInfo;
    private boolean glowing = false;
    private IDisplaySettings displayTypeSettings = AdvancedDisplaysRegistry.createSettings(ModDisplayTypes.TRAIN_DESTINATION_SIMPLE);
    private long lastRefreshedTime;
    private TrainDisplayData trainData = TrainDisplayData.empty();
    private CarriageData carriageData = new CarriageData(0, Direction.NORTH, false);
    private int syncTicks = 99;
    private final Cache<IBlockEntityRendererInstance<AdvancedDisplayBlockEntity>> renderer = new Cache(() -> new AdvancedDisplayRenderInstance(this), ECachingPriority.ALWAYS);
    public final Cache<TrainExitSide> relativeExitDirection = new Cache(() -> {
        if (this.getCarriageData() == null || !this.getTrainData().getNextStop().isPresent() || !(this.m_58900_().m_60734_() instanceof AbstractAdvancedDisplayBlock)) {
            return TrainExitSide.UNKNOWN;
        }
        TrainExitSide side = this.getTrainData().getNextStopExitSide();
        Direction blockFacing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        if (!this.carriageData.isOppositeDirection()) {
            blockFacing = blockFacing.m_122424_();
        }
        TrainExitSide result = side;
        if (this.getCarriageData().assemblyDirection() == blockFacing) {
            result = result.getOpposite();
        } else if (this.getCarriageData().assemblyDirection().m_122424_() != blockFacing) {
            result = TrainExitSide.UNKNOWN;
        }
        return result;
    });
    public final Cache<Tripple<Float, Float, Float>> renderRotation = new Cache(() -> {
        Block patt0$temp = this.m_58900_().m_60734_();
        if (patt0$temp instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)patt0$temp;
            return block.getRenderRotation(this.f_58857_, this.m_58900_(), this.f_58858_);
        }
        return Tripple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    });
    public final Cache<Pair<Float, Float>> renderOffset = new Cache(() -> {
        Block patt0$temp = this.m_58900_().m_60734_();
        if (patt0$temp instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)patt0$temp;
            return block.getRenderOffset(this.f_58857_, this.m_58900_(), this.f_58858_);
        }
        return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    });
    public final Cache<Pair<Float, Float>> renderZOffset = new Cache(() -> {
        Block patt0$temp = this.m_58900_().m_60734_();
        if (patt0$temp instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)patt0$temp;
            return block.getRenderZOffset(this.f_58857_, this.m_58900_(), this.f_58858_);
        }
        return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    });
    public final Cache<Pair<Float, Float>> renderAspectRatio = new Cache(() -> {
        Block patt0$temp = this.m_58900_().m_60734_();
        if (patt0$temp instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)patt0$temp;
            Pair<Float, Float> raw = block.getRenderAspectRatio(this.f_58857_, this.m_58900_(), this.f_58858_);
            float scale = 1.0f / Math.min(((Float)raw.getFirst()).floatValue(), ((Float)raw.getSecond()).floatValue());
            return Pair.of((Object)Float.valueOf(((Float)raw.getFirst()).floatValue() * scale), (Object)Float.valueOf(((Float)raw.getSecond()).floatValue() * scale));
        }
        return Pair.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
    });
    public final Cache<Float> renderScale = new Cache(() -> Float.valueOf(1.0f / Math.max(((Float)((Pair)this.renderAspectRatio.get()).getFirst()).floatValue(), ((Float)((Pair)this.renderAspectRatio.get()).getSecond()).floatValue())));

    public AdvancedDisplayBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.reset();
    }

    public TrainDisplayData getTrainData() {
        return this.trainData;
    }

    public CarriageData getCarriageData() {
        return this.carriageData;
    }

    public long getLastRefreshedTime() {
        return this.lastRefreshedTime;
    }

    public byte getXSize() {
        return this.xSize;
    }

    public byte getXSizeScaled() {
        return (byte)((float)this.getXSize() * ((Float)((Pair)this.renderAspectRatio.get()).getFirst()).floatValue());
    }

    public byte getYSize() {
        return this.ySize;
    }

    public byte getYSizeScaled() {
        return (byte)((float)this.getYSize() * ((Float)((Pair)this.renderAspectRatio.get()).getSecond()).floatValue());
    }

    @Override
    public boolean isController() {
        return this.isController;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public AdvancedDisplaysRegistry.DisplayTypeResourceKey getDisplayType() {
        return this.displayTypeId;
    }

    @Override
    public byte getMaxWidth() {
        return 16;
    }

    @Override
    public byte getMaxHeight() {
        return 16;
    }

    @Override
    public byte getWidth() {
        return this.xSize;
    }

    @Override
    public byte getHeight() {
        return this.ySize;
    }

    @Override
    public Class<AbstractAdvancedDisplayBlock> getBlockType() {
        return AbstractAdvancedDisplayBlock.class;
    }

    @Override
    public Class<AdvancedDisplayBlockEntity> getBlockEntityType() {
        return AdvancedDisplayBlockEntity.class;
    }

    public List<StationDisplayData> getStops() {
        return this.predictions;
    }

    public boolean isPlatformFixed() {
        return !this.stationNameFilter.contains("*");
    }

    public StationTag.StationInfo getStationInfo() {
        return this.stationInfo;
    }

    public String getStationNameFilter() {
        return this.stationNameFilter;
    }

    public boolean isAllowedOnDisplay(StationTag.ClientStationTag tag) {
        return TrainUtils.stationMatches(tag.stationName(), this.getStationNameFilter());
    }

    public StationTag.ClientStationTag getAllowedDisplayData(TrainStopDisplayData data) {
        if (this.isAllowedOnDisplay(data.getRealTimeStation())) {
            return data.getRealTimeStation();
        }
        if (this.isAllowedOnDisplay(data.getScheduledStation())) {
            return data.getScheduledStation();
        }
        return StationTag.ClientStationTag.empty();
    }

    public boolean isSingleLine() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block2 = (AbstractAdvancedDisplayBlock)block;
            return block2.isSingleLined() || AdvancedDisplaysRegistry.getProperties(this.displayTypeId).singleLined();
        }
        return false;
    }

    public AdvancedDisplaysRegistry.DisplayProperties getDisplayProperties() {
        return AdvancedDisplaysRegistry.getProperties(this.displayTypeId);
    }

    public void setGlowing(boolean glowing) {
        this.glowing = glowing;
        if (this.f_58857_.f_46443_) {
            this.getRenderer().update(this.f_58857_, this.f_58858_, this.m_58900_(), (BlockEntity)this, (Object)EUpdateReason.LAYOUT_CHANGED);
        }
    }

    public void setDisplayType(AdvancedDisplaysRegistry.DisplayTypeResourceKey key, IDisplaySettings settings) {
        this.displayTypeId = key;
        IDisplaySettings iDisplaySettings = this.displayTypeSettings = settings == null ? AdvancedDisplaysRegistry.createSettings(key) : settings;
        if (this.f_58857_.f_46443_) {
            this.getRenderer().update(this.f_58857_, this.f_58858_, this.m_58900_(), (BlockEntity)this, (Object)EUpdateReason.LAYOUT_CHANGED);
        }
    }

    public void setData(List<StationDisplayData> predictions, String stationNameFilter, StationTag.StationInfo staionInfo, long lastRefreshedTime) {
        this.dataOrderChanged = this.dataOrderChanged || !ListUtils.compareCollections(this.predictions, predictions, StationDisplayData::equals);
        boolean clientUpdate = Platform.getEnvironment() == Env.CLIENT && !this.getStationInfo().equals(staionInfo);
        this.predictions = predictions;
        this.stationNameFilter = stationNameFilter;
        this.stationInfo = staionInfo;
        this.lastRefreshedTime = lastRefreshedTime;
        if (clientUpdate) {
            this.getRenderer().update(this.f_58857_, this.f_58858_, this.m_58900_(), (BlockEntity)this, (Object)EUpdateReason.DATA_CHANGED);
        }
    }

    @Override
    public boolean connectable(BlockGetter getter, BlockPos a, BlockPos b) {
        if (getter == null || a == null || b == null) {
            return false;
        }
        BlockEntity blockEntity = getter.m_7702_(a);
        if (blockEntity instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity be1 = (AdvancedDisplayBlockEntity)blockEntity;
            blockEntity = getter.m_7702_(b);
            if (blockEntity instanceof AdvancedDisplayBlockEntity) {
                AdvancedDisplayBlockEntity be2 = (AdvancedDisplayBlockEntity)blockEntity;
                blockEntity = be1.m_58900_().m_60734_();
                if (blockEntity instanceof AbstractAdvancedDisplayBlock) {
                    AbstractAdvancedDisplayBlock block1 = (AbstractAdvancedDisplayBlock)blockEntity;
                    blockEntity = be2.m_58900_().m_60734_();
                    if (blockEntity instanceof AbstractAdvancedDisplayBlock) {
                        AbstractAdvancedDisplayBlock block2 = (AbstractAdvancedDisplayBlock)blockEntity;
                        return block1 == block2 && be1.getDisplayType().equals(be2.getDisplayType()) && block1.canConnectWithBlock(getter, getter.m_8055_(a), getter.m_8055_(b)) && block2.canConnectWithBlock(getter, getter.m_8055_(b), getter.m_8055_(a)) && (!a.m_7494_().equals((Object)b) || (Boolean)be1.m_58900_().m_61143_((Property)AbstractAdvancedDisplayBlock.UP) != false && !be1.isSingleLine()) && (!a.m_7495_().equals((Object)b) || (Boolean)be1.m_58900_().m_61143_((Property)AbstractAdvancedDisplayBlock.DOWN) != false && !be1.isSingleLine());
                    }
                }
            }
        }
        return false;
    }

    public AdvancedDisplayBlockEntity getController() {
        AdvancedDisplayBlockEntity flap;
        BlockEntity found;
        int i;
        if (this.isController()) {
            return this;
        }
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof AbstractAdvancedDisplayBlock)) {
            return null;
        }
        BlockPos.MutableBlockPos pos = this.m_58899_().m_122032_();
        Direction side = ((Direction)blockState.m_61143_((Property)AbstractAdvancedDisplayBlock.FACING)).m_122427_();
        for (i = 0; i < this.getMaxWidth(); ++i) {
            if (!this.connectable((BlockGetter)this.f_58857_, (BlockPos)pos, pos.m_121945_(side))) {
                found = this.f_58857_.m_7702_((BlockPos)pos);
                if (!(found instanceof AdvancedDisplayBlockEntity) || !(flap = (AdvancedDisplayBlockEntity)found).isController()) break;
                return flap;
            }
            pos.m_122173_(side);
        }
        for (i = 0; i < this.getMaxHeight(); ++i) {
            if (!this.connectable((BlockGetter)this.f_58857_, (BlockPos)pos, pos.m_121945_(Direction.UP))) {
                found = this.f_58857_.m_7702_((BlockPos)pos);
                if (!(found instanceof AdvancedDisplayBlockEntity) || !(flap = (AdvancedDisplayBlockEntity)found).isController()) break;
                return flap;
            }
            pos.m_122173_(Direction.UP);
        }
        return null;
    }

    public void copyFrom(AdvancedDisplayBlockEntity other) {
        if (this.getDisplayType().equals(other.getDisplayType()) && this.isGlowing() == other.isGlowing()) {
            return;
        }
        this.glowing = other.isGlowing();
        this.displayTypeId = other.getDisplayType();
        this.displayTypeSettings = other.getSettings();
        this.notifyUpdate();
    }

    public void reset() {
        this.dataOrderChanged = true;
        this.predictions = List.of();
        this.stationNameFilter = "";
        this.xSize = 1;
        this.ySize = 1;
        this.isController = false;
        this.stationInfo = StationTag.StationInfo.empty();
    }

    public void updateControllerStatus() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof AbstractAdvancedDisplayBlock)) {
            return;
        }
        Direction leftDirection = ((Direction)blockState.m_61143_((Property)AbstractAdvancedDisplayBlock.FACING)).m_122427_();
        boolean shouldBeController = !this.connectable((BlockGetter)this.f_58857_, this.f_58858_, this.f_58858_.m_121945_(leftDirection)) && !this.connectable((BlockGetter)this.f_58857_, this.f_58858_, this.f_58858_.m_7494_());
        int newXSize = 1;
        byte newYSize = 1;
        if (shouldBeController) {
            BlockPos relPos;
            for (int xOffset = 1; xOffset < this.getMaxWidth() && this.f_58857_.m_8055_(relPos = this.f_58858_.m_5484_(leftDirection.m_122424_(), xOffset)) == blockState; ++xOffset) {
                newXSize = (byte)(newXSize + 1);
            }
            if (!this.isSingleLine()) {
                for (int yOffset = 0; yOffset < this.getMaxHeight(); ++yOffset) {
                    BlockPos downPos = this.f_58858_.m_5484_(Direction.DOWN, yOffset);
                    for (int i = 0; i < newXSize; ++i) {
                        AdvancedDisplayBlockEntity be;
                        BlockPos relPos2 = downPos.m_5484_(leftDirection.m_122424_(), i);
                        BlockEntity blockEntity = this.f_58857_.m_7702_(relPos2);
                        if (!(blockEntity instanceof AdvancedDisplayBlockEntity) || (be = (AdvancedDisplayBlockEntity)blockEntity) == this) continue;
                        be.copyFrom(this);
                    }
                    if (!this.connectable((BlockGetter)this.f_58857_, downPos, downPos.m_7495_())) break;
                    newYSize = (byte)(newYSize + 1);
                }
            }
        }
        if (this.isController == shouldBeController && newXSize == this.xSize && newYSize == this.ySize) {
            return;
        }
        this.isController = shouldBeController;
        this.xSize = newXSize;
        this.ySize = newYSize;
        if (!this.isController) {
            this.reset();
        }
        this.notifyUpdate();
    }

    public void tick() {
        if (this.f_58857_.f_46443_) {
            this.getRenderer().tick(this.f_58857_, this.m_58899_(), this.m_58900_(), (BlockEntity)this);
        }
        super.tick();
        if (this.getDisplayType().category().getSource() != EDisplayType.EDisplayTypeDataSource.PLATFORM) {
            return;
        }
        ++this.syncTicks;
        if ((this.syncTicks %= 100) == 0 && this.f_58857_.f_46443_) {
            boolean shouldUpdate;
            boolean bl = shouldUpdate = this.getStops().size() > 0 || this.dataOrderChanged;
            if (shouldUpdate) {
                this.getRenderer().update(this.f_58857_, this.m_58899_(), this.m_58900_(), (BlockEntity)this, (Object)(this.dataOrderChanged ? EUpdateReason.LAYOUT_CHANGED : EUpdateReason.DATA_CHANGED));
                this.dataOrderChanged = false;
            }
        }
    }

    public void lazyTick() {
        super.lazyTick();
        this.updateControllerStatus();
    }

    @Override
    public void contraptionTick(Level level, BlockPos pos, BlockState state, CarriageContraption carriage) {
        this.getRenderer().tick(level, pos, state, (BlockEntity)this);
        if (!this.isController()) {
            return;
        }
        if (this.getDisplayType().category().getSource() != EDisplayType.EDisplayTypeDataSource.TRAIN_INFORMATION) {
            return;
        }
        ++this.syncTicks;
        if ((this.syncTicks %= 100) == 0 && level.f_46443_) {
            DataAccessor.getFromServer((Object)((CarriageContraptionEntity)carriage.entity).trainId, ModAccessorTypes.GET_TRAIN_DISPLAY_DATA_FROM_SERVER, data -> {
                boolean outOfService;
                if (data.getState().isOutOfService() && this.trainData.getState().isOutOfService()) {
                    return;
                }
                boolean shouldUpdate = false;
                if (this.trainData != null && this.trainData.getNextStop().isPresent() && data.getNextStop().isPresent()) {
                    TrainStopDisplayData prediction = this.trainData.getNextStop().get();
                    boolean bl = shouldUpdate = !this.trainData.getTrainData().getName().equals(data.getTrainData().getName()) || !prediction.getDestination().equals(data.getNextStop().get().getDestination()) || prediction.getStationEntryIndex() != data.getNextStop().get().getStationEntryIndex() || this.trainData.getNextStopExitSide() != data.getNextStopExitSide() || this.trainData.isWaitingAtStation() != data.isWaitingAtStation();
                }
                if (outOfService = data.getState().isOutOfService()) {
                    shouldUpdate = true;
                }
                this.trainData = outOfService ? TrainDisplayData.empty() : data;
                this.carriageData = new CarriageData(((CarriageContraptionEntity)carriage.entity).carriageIndex, carriage.getAssemblyDirection(), data.isOppositeDirection());
                this.relativeExitDirection.clear();
                this.getRenderer().update(level, pos, state, (BlockEntity)this, (Object)(shouldUpdate ? EUpdateReason.LAYOUT_CHANGED : EUpdateReason.DATA_CHANGED));
            });
        }
    }

    protected void write(CompoundTag pTag, boolean clientPacket) {
        super.write(pTag, clientPacket);
        pTag.m_128344_(NBT_XSIZE, this.getXSize());
        pTag.m_128344_(NBT_YSIZE, this.getYSize());
        pTag.m_128379_(NBT_CONTROLLER, this.isController());
        pTag.m_128359_(NBT_FILTER, this.getStationNameFilter());
        pTag.m_128379_(NBT_GLOWING, this.isGlowing());
        pTag.m_128356_(NBT_LAST_REFRESH_TIME, this.getLastRefreshedTime());
        this.displayTypeId.toNbt(pTag);
        pTag.m_128365_(NBT_DISPLAY_TYPE_SETTINGS, (Tag)this.displayTypeSettings.serializeNbt());
        this.getStationInfo().writeNbt(pTag);
        if (this.getStops() != null && !this.getStops().isEmpty()) {
            ListTag list = new ListTag();
            for (StationDisplayData data : this.getStops()) {
                list.add((Object)data.toNbt());
            }
            pTag.m_128365_(NBT_TRAIN_STOPS, (Tag)list);
        }
    }

    public void read(CompoundTag pTag, boolean clientPacket) {
        boolean updateClient = false;
        IDisplaySettings oldDisplayTypeSettings = this.displayTypeSettings;
        StationTag.StationInfo info = StationTag.StationInfo.fromNbt(pTag);
        if (this.f_58857_ != null && this.m_58900_() != null && this.f_58857_.f_46443_ && (this.isController() != pTag.m_128471_(NBT_CONTROLLER) || this.getXSize() != pTag.m_128445_(NBT_XSIZE) || this.getYSize() != pTag.m_128445_(NBT_YSIZE) || !this.getStationInfo().equals(info) || this.getStops().isEmpty() ^ !pTag.m_128441_(NBT_TRAIN_STOPS))) {
            updateClient = true;
        }
        super.read(pTag, clientPacket);
        this.xSize = pTag.m_128445_(NBT_XSIZE);
        this.ySize = pTag.m_128445_(NBT_YSIZE);
        this.glowing = pTag.m_128471_(NBT_GLOWING);
        this.isController = pTag.m_128471_(NBT_CONTROLLER);
        Class<?> oldDisplaySettings = this.displayTypeSettings.getClass();
        AdvancedDisplaysRegistry.DisplayTypeResourceKey oldDisplayType = this.displayTypeId;
        if (pTag.m_128441_(LEGACY_NBT_INFO_TYPE) && pTag.m_128441_(LEGACY_NBT_DISPLAY_TYPE)) {
            this.displayTypeId = ModDisplayTypes.legacy_getKeyForType(EDisplayType.getTypeById(pTag.m_128451_(LEGACY_NBT_DISPLAY_TYPE)), EDisplayInfo.getTypeById(pTag.m_128451_(LEGACY_NBT_INFO_TYPE)));
            this.displayTypeSettings = AdvancedDisplaysRegistry.createSettings(this.displayTypeId);
        } else if (pTag.m_128441_(LEGACY_NBT_DISPLAY_TYPE_KEY)) {
            this.displayTypeId = AdvancedDisplaysRegistry.DisplayTypeResourceKey.legacy_fromNbt(pTag.m_128469_(LEGACY_NBT_DISPLAY_TYPE_KEY));
            this.displayTypeSettings = AdvancedDisplaysRegistry.createSettings(this.displayTypeId);
        } else {
            this.displayTypeId = AdvancedDisplaysRegistry.DisplayTypeResourceKey.fromNbt(pTag);
            this.displayTypeSettings = AdvancedDisplaysRegistry.createSettings(this.displayTypeId);
            this.displayTypeSettings.deserializeNbt(pTag.m_128469_(NBT_DISPLAY_TYPE_SETTINGS));
        }
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            boolean bl = updateClient = updateClient || !oldDisplayTypeSettings.getClass().equals(this.displayTypeSettings.getClass());
        }
        if (pTag.m_128441_(LEGACY_NBT_COLOR)) {
            this.getSettingsAs(BasicDisplaySettings.class).ifPresent(x -> x.setFontColor(pTag.m_128451_(LEGACY_NBT_COLOR)));
        }
        if (this.displayTypeId.category().getSource() == EDisplayType.EDisplayTypeDataSource.PLATFORM) {
            if (pTag.m_128441_(LEGACY_NBT_PLATFORM_WIDTH)) {
                this.getSettingsAs(IPlatformWidthSetting.class).ifPresent(x -> x.setPlatformWidth(pTag.m_128445_(LEGACY_NBT_PLATFORM_WIDTH)));
            }
            if (pTag.m_128441_(LEGACY_NBT_TRAIN_NAME_WIDTH)) {
                this.getSettingsAs(ITrainNameWidthSetting.class).ifPresent(x -> x.setTrainNameWidth(pTag.m_128445_(LEGACY_NBT_TRAIN_NAME_WIDTH)));
            }
            if (pTag.m_128441_(LEGACY_NBT_TIME_DISPLAY)) {
                this.getSettingsAs(ITimeDisplaySetting.class).ifPresent(x -> x.setTimeDisplay(ETimeDisplay.getById(pTag.m_128445_(LEGACY_NBT_TIME_DISPLAY))));
            }
        }
        this.setData(pTag.m_128441_(NBT_TRAIN_STOPS) ? new ArrayList<StationDisplayData>(pTag.m_128437_(NBT_TRAIN_STOPS, 10).stream().map(x -> StationDisplayData.fromNbt((CompoundTag)x)).toList()) : new ArrayList(), pTag.m_128461_(NBT_FILTER), info, pTag.m_128454_(NBT_LAST_REFRESH_TIME));
        if (!(this.f_58857_ == null || this.m_58900_() == null || !this.f_58857_.f_46443_ || oldDisplaySettings.isInstance(this.displayTypeSettings) && oldDisplayType.equals(this.displayTypeId))) {
            updateClient = true;
        }
        if (updateClient) {
            this.getRenderer().update(this.f_58857_, this.f_58858_, this.m_58900_(), (BlockEntity)this, (Object)EUpdateReason.LAYOUT_CHANGED);
        }
    }

    public AABB getRenderBoundingBox() {
        AABB aabb = new AABB(this.f_58858_);
        if (!this.isController) {
            return aabb;
        }
        Vec3i normal = this.getDirection().m_122427_().m_122436_();
        return aabb.m_82363_((double)(normal.m_123341_() * this.getXSize()), (double)(-this.getYSize()), (double)(normal.m_123343_() * this.getXSize()));
    }

    public Direction getDirection() {
        return this.m_58900_().m_61145_(FlapDisplayBlock.HORIZONTAL_FACING).orElse(Direction.SOUTH).m_122424_();
    }

    public IBlockEntityRendererInstance<AdvancedDisplayBlockEntity> getRenderer() {
        return (IBlockEntityRendererInstance)this.renderer.get();
    }

    public IDisplaySettings getSettings() {
        return this.displayTypeSettings;
    }

    public <S> Optional<S> getSettingsAs(Class<S> clazz) {
        return Optional.ofNullable(clazz.isInstance(this.getSettings()) ? (Object)clazz.cast(this.getSettings()) : null);
    }

    protected AABB createRenderBoundingBox() {
        AABB aabb = new AABB(this.f_58858_);
        if (!this.isController) {
            return aabb;
        }
        Vec3i normal = this.getDirection().m_122427_().m_122436_();
        return aabb.m_82363_((double)(normal.m_123341_() * this.xSize), (double)(-this.ySize), (double)(normal.m_123343_() * this.xSize));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 512);
    }

    public static enum EUpdateReason {
        LAYOUT_CHANGED,
        DATA_CHANGED;

    }
}

