/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.foundation.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.foundation.data.recipe.CreateRecipeProvider;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.nuclearteam.createnuclear.CNItems;
import net.nuclearteam.createnuclear.CNTags;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.content.equipment.cloth.ClothItem;
import net.nuclearteam.createnuclear.foundation.data.recipe.CNProcessingRecipeGen;

public class CNShapelessRecipeGen
extends CNProcessingRecipeGen {
    private final String SHAPELESS = this.enterFolder("shapeless");
    CreateRecipeProvider.GeneratedRecipe RAW_URANIUM = this.create((ItemProviderEntry<? extends ItemLike>)CNItems.RAW_URANIUM).returns(9).withSuffix("_from_decompacting").unlockedByTag(() -> CNTags.forgeItemTag("storage_blocks/raw_uranium")).viaShapeless(b -> b.m_206419_(CNTags.forgeItemTag("storage_blocks/raw_uranium")));
    CreateRecipeProvider.GeneratedRecipe RAW_LEAD = this.create((ItemProviderEntry<? extends ItemLike>)CNItems.RAW_LEAD).returns(9).withSuffix("_from_decompacting").unlockedByTag(() -> CNTags.forgeItemTag("storage_blocks/raw_lead")).viaShapeless(b -> b.m_206419_(CNTags.forgeItemTag("storage_blocks/raw_lead")));
    CreateRecipeProvider.GeneratedRecipe LEAD_INGOT = this.create((ItemProviderEntry<? extends ItemLike>)CNItems.LEAD_INGOT).returns(9).withSuffix("_from_decompacting").unlockedByTag(() -> CNTags.forgeItemTag("storage_blocks/lead")).viaShapeless(b -> b.m_206419_(CNTags.forgeItemTag("storage_blocks/lead")));
    CreateRecipeProvider.GeneratedRecipe LEAD_NUGGET = this.create((ItemProviderEntry<? extends ItemLike>)CNItems.LEAD_NUGGET).returns(9).withSuffix("_from_decompacting").unlockedByTag(() -> CNTags.forgeItemTag("ingots/lead")).viaShapeless(b -> b.m_206419_(CNTags.forgeItemTag("ingots/lead")));
    CreateRecipeProvider.GeneratedRecipe STEEL_INGOT = this.create((ItemProviderEntry<? extends ItemLike>)CNItems.STEEL_INGOT).returns(9).withSuffix("_from_decompacting").unlockedByTag(() -> CNTags.forgeItemTag("storage_blocks/steel")).viaShapeless(b -> b.m_206419_(CNTags.forgeItemTag("storage_blocks/steel")));
    CreateRecipeProvider.GeneratedRecipe STEEL_NUGGET = this.create((ItemProviderEntry<? extends ItemLike>)CNItems.STEEL_NUGGET).returns(9).withSuffix("_from_decompacting").unlockedByTag(() -> CNTags.forgeItemTag("ingots/steel")).viaShapeless(b -> b.m_206419_(CNTags.forgeItemTag("ingots/steel")));
    CreateRecipeProvider.GeneratedRecipe REACTOR_BLUEPRINT_ITEM_CLEAR = this.clearData((ItemProviderEntry<? extends ItemLike>)CNItems.REACTOR_BLUEPRINT);
    private final String SHAPELESS_CLOTH = this.enterFolder("shapeless/cloth");
    ClothItem.DyeRecipeList CLOTH_CHANGING = new ClothItem.DyeRecipeList(color -> {
        ArrayList<Item> ingredients = new ArrayList<Item>(Arrays.asList(Items.f_42535_, Items.f_42536_, Items.f_42537_, Items.f_42538_, Items.f_42539_, Items.f_42540_, Items.f_42489_, Items.f_42490_, Items.f_42491_, Items.f_42492_, Items.f_42493_, Items.f_42494_, Items.f_42495_, Items.f_42496_, Items.f_42497_, Items.f_42498_));
        return this.create((ItemProviderEntry<? extends ItemLike>)CNItems.CLOTHS.get((DyeColor)color)).unlockedBy(ClothItem.Cloths.WHITE_CLOTH::getItem).withCategory(RecipeCategory.BUILDING_BLOCKS).viaShapeless(b -> b.m_206419_(CNTags.CNItemTags.CLOTH.tag).m_126209_((ItemLike)ingredients.get(color.ordinal())));
    });
    String currentFolder = "";

    String enterFolder(String foldedr) {
        this.currentFolder = foldedr;
        return this.currentFolder;
    }

    GeneratedRecipeBuilder create(Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ResourceLocation result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends ItemLike> result) {
        return this.create(() -> result.get());
    }

    CreateRecipeProvider.GeneratedRecipe metalCompacting(List<ItemProviderEntry<? extends ItemLike>> variants, List<Supplier<TagKey<Item>>> ingredients) {
        CreateRecipeProvider.GeneratedRecipe result = null;
        int i = 0;
        while (i + 1 < variants.size()) {
            ItemProviderEntry<? extends ItemLike> currentEntry = variants.get(i);
            ItemProviderEntry<? extends ItemLike> nextEntry = variants.get(i + 1);
            Supplier<TagKey<Item>> currentIngredient = ingredients.get(i);
            Supplier<TagKey<Item>> nextIngredient = ingredients.get(i + 1);
            result = this.create(currentEntry).returns(9).withSuffix("_from_decompacting").unlockedBy(() -> nextEntry.get()).viaShapeless(b -> b.m_206419_((TagKey)nextIngredient.get()));
            ++i;
        }
        return result;
    }

    CreateRecipeProvider.GeneratedRecipe clearData(ItemProviderEntry<? extends ItemLike> item) {
        return this.create(item).withSuffix("_clear").unlockedBy(() -> item.get()).viaShapeless(b -> b.m_126209_((ItemLike)item.get()));
    }

    public CNShapelessRecipeGen(PackOutput output) {
        super(output);
    }

    @Override
    protected IRecipeTypeInfo getRecipeType() {
        return AllRecipeTypes.COMPACTING;
    }

    class GeneratedRecipeBuilder {
        private String path;
        private String suffix;
        private Supplier<? extends ItemLike> result;
        private ResourceLocation compatDatagenOutput;
        List<ICondition> recipeConditions;
        private RecipeCategory category;
        private Supplier<ItemPredicate> unlockedBy;
        private int amount;

        private GeneratedRecipeBuilder(String path) {
            this.path = path;
            this.recipeConditions = new ArrayList<ICondition>();
            this.suffix = "";
            this.amount = 1;
            this.category = RecipeCategory.MISC;
        }

        public GeneratedRecipeBuilder(String path, Supplier<? extends ItemLike> result) {
            this(path);
            this.result = result;
        }

        public GeneratedRecipeBuilder(String path, ResourceLocation result) {
            this(path);
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)item.get()}).m_45077_();
            return this;
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_204145_((TagKey)tag.get()).m_45077_();
            return this;
        }

        GeneratedRecipeBuilder whenModLoaded(String modid) {
            return this.withCondition((ICondition)new ModLoadedCondition(modid));
        }

        GeneratedRecipeBuilder whenModMissing(String modid) {
            return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
        }

        GeneratedRecipeBuilder withCondition(ICondition condition) {
            this.recipeConditions.add(condition);
            return this;
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        GeneratedRecipeBuilder withCategory(RecipeCategory category) {
            this.category = category;
            return this;
        }

        CreateRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return CNShapelessRecipeGen.this.register(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.m_246608_((RecipeCategory)this.category, (ItemLike)this.result.get(), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)CNShapelessRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, this.createSimpleLocation(this.path));
            });
        }

        CreateRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return CNShapelessRecipeGen.this.register(consumer -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.m_246517_((RecipeCategory)this.category, (ItemLike)this.result.get(), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)CNShapelessRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, this.createSimpleLocation(this.path));
            });
        }

        CreateRecipeProvider.GeneratedRecipe viaNetheriteSmithing(Supplier<? extends Item> base, Supplier<Ingredient> upgradeMaterial) {
            this.withCategory(RecipeCategory.COMBAT);
            return CNShapelessRecipeGen.this.register(consumer -> {
                SmithingTransformRecipeBuilder b = SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_265918_}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)base.get()}), (Ingredient)((Ingredient)upgradeMaterial.get()), (RecipeCategory)this.category, (Item)this.result.get().m_5456_());
                b.m_266439_("has_item", (CriterionTriggerInstance)CNShapelessRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)base.get()}).m_45077_()}));
                b.m_266371_(consumer, this.createSimpleLocation(this.path));
            });
        }

        private ResourceLocation createSimpleLocation(String recipeType) {
            return CreateNuclear.asResource(recipeType + "/" + this.getRegistryName().m_135815_() + this.suffix);
        }

        private ResourceLocation createLocation(String recipeType) {
            return CreateNuclear.asResource(recipeType + "/" + this.path + "/" + this.getRegistryName().m_135815_() + this.suffix);
        }

        private ResourceLocation getRegistryName() {
            return this.compatDatagenOutput == null ? CatnipServices.REGISTRIES.getKeyOrThrow(this.result.get().m_5456_()) : this.compatDatagenOutput;
        }

        GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends ItemLike> item) {
            return this.unlockedBy(item).viaCookingIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)item.get()}));
        }

        GeneratedCookingRecipeBuilder viaCookingTag(Supplier<TagKey<Item>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient(() -> Ingredient.m_204132_((TagKey)((TagKey)tag.get())));
        }

        GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<Ingredient> ingredient) {
            return new GeneratedCookingRecipeBuilder(ingredient);
        }

        class GeneratedCookingRecipeBuilder {
            private Supplier<Ingredient> ingredient;
            private float exp;
            private int cookingTime;
            private final RecipeSerializer<? extends AbstractCookingRecipe> FURNACE = RecipeSerializer.f_44091_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> SMOKER = RecipeSerializer.f_44093_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> BLAST = RecipeSerializer.f_44092_;
            private final RecipeSerializer<? extends AbstractCookingRecipe> CAMPFIRE = RecipeSerializer.f_44094_;

            GeneratedCookingRecipeBuilder(Supplier<Ingredient> ingredient) {
                this.ingredient = ingredient;
                this.cookingTime = 200;
                this.exp = 0.0f;
            }

            GeneratedCookingRecipeBuilder forDuration(int duration) {
                this.cookingTime = duration;
                return this;
            }

            GeneratedCookingRecipeBuilder rewardXP(float xp) {
                this.exp = xp;
                return this;
            }

            CreateRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            CreateRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                return this.create(this.FURNACE, builder, 1.0f);
            }

            CreateRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            CreateRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                this.create(this.CAMPFIRE, builder, 3.0f);
                return this.create(this.SMOKER, builder, 0.5f);
            }

            CreateRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            CreateRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                return this.create(this.BLAST, builder, 0.5f);
            }

            private CreateRecipeProvider.GeneratedRecipe create(RecipeSerializer<? extends AbstractCookingRecipe> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, float cookingTimeModifier) {
                return CNShapelessRecipeGen.this.register(consumer -> {
                    boolean isOtherMod = GeneratedRecipeBuilder.this.compatDatagenOutput != null;
                    SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.m_247607_((Ingredient)this.ingredient.get(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)(isOtherMod ? Items.f_42329_ : GeneratedRecipeBuilder.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (RecipeSerializer)serializer));
                    if (GeneratedRecipeBuilder.this.unlockedBy != null) {
                        b.m_126132_("has_item", (CriterionTriggerInstance)CNShapelessRecipeGen.m_126011_((ItemPredicate[])new ItemPredicate[]{GeneratedRecipeBuilder.this.unlockedBy.get()}));
                    }
                    b.m_126140_(result -> consumer.accept(isOtherMod ? new ModdedCookingRecipeResult((FinishedRecipe)result, GeneratedRecipeBuilder.this.compatDatagenOutput, GeneratedRecipeBuilder.this.recipeConditions) : result), GeneratedRecipeBuilder.this.createSimpleLocation(CatnipServices.REGISTRIES.getKeyOrThrow(serializer).m_135815_()));
                });
            }
        }
    }

    private static class ModdedCookingRecipeResult
    implements FinishedRecipe {
        private FinishedRecipe wrapped;
        private ResourceLocation outputOverride;
        private List<ICondition> conditions;

        public ModdedCookingRecipeResult(FinishedRecipe wrapped, ResourceLocation outputOverride, List<ICondition> conditions) {
            this.wrapped = wrapped;
            this.outputOverride = outputOverride;
            this.conditions = conditions;
        }

        public ResourceLocation m_6445_() {
            return this.wrapped.m_6445_();
        }

        public RecipeSerializer<?> m_6637_() {
            return this.wrapped.m_6637_();
        }

        public JsonObject m_5860_() {
            return this.wrapped.m_5860_();
        }

        public ResourceLocation m_6448_() {
            return this.wrapped.m_6448_();
        }

        public void m_7917_(JsonObject object) {
            this.wrapped.m_7917_(object);
            object.addProperty("result", this.outputOverride.toString());
            JsonArray conds = new JsonArray();
            this.conditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            object.add("conditions", (JsonElement)conds);
        }
    }
}

