/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.output;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.motor.KineticScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlock;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlockEntity;
import net.nuclearteam.createnuclear.content.multiblock.output.ReactorOutput;
import net.nuclearteam.createnuclear.foundation.utility.CreateNuclearLang;

public class ReactorOutputEntity
extends GeneratingKineticBlockEntity {
    public int speed = 1;
    public float heat = 0.0f;
    ReactorControllerBlock controller = null;
    ReactorControllerBlockEntity controllerEntity = null;
    protected ScrollValueBehaviour generatedSpeed;

    public ReactorOutputEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.generatedSpeed = new KineticScrollValueBehaviour((Component)CreateNuclearLang.translateDirect("kinetics.reactor_output.rotation_speed", new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new ReactorOutputValue());
        this.generatedSpeed.between(-1500000, 1500000);
        this.generatedSpeed.setValue(this.speed);
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation());
        behaviours.add((BlockEntityBehaviour)this.generatedSpeed);
    }

    public void tick() {
        super.tick();
        Level level = this.m_58904_();
        if (level.m_8055_(this.m_58899_().m_6630_(3)).m_60734_() == CNBlocks.REACTOR_CONTROLLER.get()) {
            this.controller = (ReactorControllerBlock)level.m_8055_(this.m_58899_().m_6630_(3)).m_60734_();
            this.controllerEntity = (ReactorControllerBlockEntity)level.m_7702_(this.m_58899_().m_6630_(3));
            if (this.controllerEntity != null && !this.controllerEntity.getAssembled() && this.getSpeed() != 0.0f) {
                this.setSpeed(0);
            }
        } else {
            this.setSpeed(0);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        float stressBase = this.calculateAddedStressCapacity();
        CreateLang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        float speed = this.getTheoreticalSpeed();
        speed = Math.abs(speed);
        float stressTotal = stressBase * speed;
        CreateLang.number((double)stressTotal).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.FindController(this.m_58899_(), Objects.requireNonNull(this.m_58904_()));
        }
    }

    public void FindController(BlockPos pos, Level level) {
        if (level.m_8055_(pos.m_6630_(3)).m_60734_() == CNBlocks.REACTOR_CONTROLLER.get()) {
            ReactorControllerBlock controller = (ReactorControllerBlock)level.m_8055_(pos.m_6630_(3)).m_60734_();
            controller.Verify(controller.m_49966_(), pos.m_6630_(3), level, level.m_6907_(), false);
        }
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public int getDir() {
        BlockState state = this.m_58900_();
        return (Integer)state.m_61143_((Property)ReactorOutput.DIR);
    }

    public void setDir(int dir, Level level, BlockPos pos) {
        BlockState state = this.m_58900_();
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)ReactorOutput.DIR, (Comparable)Integer.valueOf(dir)));
    }

    public float getGeneratedSpeed() {
        if (!CNBlocks.REACTOR_OUTPUT.has(this.m_58900_())) {
            return 0.0f;
        }
        return this.speed;
    }

    protected Block getStressConfigKey() {
        return super.getStressConfigKey();
    }

    class ReactorOutputValue
    extends ValueBoxTransform.Sided {
        ReactorOutputValue() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Direction facing = (Direction)state.m_61143_((Property)ReactorOutput.FACING);
            return super.getLocalOffset(level, pos, state).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(-0.0625));
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            super.rotate(level, pos, state, ms);
            Direction facing = (Direction)state.m_61143_((Property)ReactorOutput.FACING);
            if (facing.m_122434_() == Direction.Axis.Y) {
                return;
            }
            if (this.getSide() != Direction.UP) {
                return;
            }
            TransformStack.of((PoseStack)ms).rotateZ(-AngleHelper.horizontalAngle((Direction)facing) + 180.0f);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            Direction facing = (Direction)state.m_61143_((Property)ReactorOutput.FACING);
            if (facing.m_122434_() != Direction.Axis.Y && direction == Direction.DOWN) {
                return false;
            }
            return direction.m_122434_() != facing.m_122434_();
        }
    }
}

