/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.kinetics.fan.processing;

import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.CNEffects;
import net.nuclearteam.createnuclear.CNRecipeTypes;
import net.nuclearteam.createnuclear.CNTags;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.content.enriching.campfire.EnrichingCampfireBlock;
import net.nuclearteam.createnuclear.content.kinetics.fan.processing.EnrichedRecipe;

public class CNFanProcessingTypes {
    public static final EnrichedType ENRICHED = CNFanProcessingTypes.register("enriched", new EnrichedType());
    private static final Map<String, FanProcessingType> LEGACY_NAME_MAP;

    private static <T extends FanProcessingType> T register(String id, T type) {
        return (T)((FanProcessingType)Registry.m_122965_((Registry)CreateBuiltInRegistries.FAN_PROCESSING_TYPE, (ResourceLocation)CreateNuclear.asResource(id), type));
    }

    @Nullable
    public static FanProcessingType ofLegacyName(String name) {
        return LEGACY_NAME_MAP.get(name);
    }

    public static void register() {
    }

    public static FanProcessingType parseLegacy(String str) {
        FanProcessingType type = CNFanProcessingTypes.ofLegacyName(str);
        if (type != null) {
            return type;
        }
        return FanProcessingType.parse((String)str);
    }

    static {
        Object2ReferenceOpenHashMap map = new Object2ReferenceOpenHashMap();
        map.put((Object)"ENRICHED", (Object)ENRICHED);
        map.trim();
        LEGACY_NAME_MAP = map;
    }

    public static class EnrichedType
    implements FanProcessingType {
        private static final EnrichedRecipe.EnrichedWrapper ENRICHED_WRAPPER = new EnrichedRecipe.EnrichedWrapper();

        public boolean isValidAt(Level level, BlockPos pos) {
            BlockState state = level.m_8055_(pos);
            if (CNTags.CNBlockTags.FAN_PROCESSING_CATALYSTS_ENRICHED.matches(state)) {
                return !state.m_60713_((Block)CNBlocks.ENRICHING_CAMPFIRE.get()) || !state.m_61138_((Property)EnrichingCampfireBlock.LIT) || (Boolean)state.m_61143_((Property)EnrichingCampfireBlock.LIT) != false;
            }
            return false;
        }

        public int getPriority() {
            return 301;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            ENRICHED_WRAPPER.m_6836_(0, stack);
            Optional recipe = CNRecipeTypes.ENRICHED.find(ENRICHED_WRAPPER, level);
            return recipe.isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            ENRICHED_WRAPPER.m_6836_(0, stack);
            Optional<EnrichedRecipe> recipe = CNRecipeTypes.ENRICHED.find(ENRICHED_WRAPPER, level);
            return recipe.map(enrichedRecipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)enrichedRecipe)).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            pos = pos.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)level.f_46441_, (float)1.0f).m_82542_(1.0, 0.5, 1.0).m_82541_().m_82490_((double)0.15f));
            level.m_7106_((ParticleOptions)ParticleTypes.f_123792_, pos.f_82479_, pos.f_82480_ + (double)0.45f, pos.f_82481_, 0.0, 0.0, 0.0);
            if (level.f_46441_.m_188503_(2) != 0) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123815_, pos.f_82479_, pos.f_82480_ + 0.25, pos.f_82481_, 0.0, 0.0, 0.0);
            }
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)0, (int)1205608, (float)random.m_188501_()));
            particleAccess.setAlpha(1.0f);
            if (random.m_188501_() < 0.0078125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123783_, 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123776_, 0.125f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)CNEffects.RADIATION.get(), 10, 0, true, true));
            }
        }
    }
}

