/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.contraptions.irradiated.wolf;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.nuclearteam.createnuclear.CreateNuclear;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.CNModelLayers;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.wolf.IrradiatedWolf;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.wolf.IrradiatedWolfModel;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class IrradiatedWolfRenderer
extends MobRenderer<IrradiatedWolf, IrradiatedWolfModel<IrradiatedWolf>> {
    private static final ResourceLocation WOLF_LOCATION = CreateNuclear.asResource("textures/entity/irradiated_wolf.png");
    private static final ResourceLocation WOLF_TAME_LOCATION = CreateNuclear.asResource("textures/entity/irradiated_wolf.png");
    private static final ResourceLocation WOLF_ANGRY_LOCATION = CreateNuclear.asResource("textures/entity/irradiated_wolf_angry.png");

    public IrradiatedWolfRenderer(EntityRendererProvider.Context context) {
        super(context, new IrradiatedWolfModel(context.m_174023_(CNModelLayers.IRRADIATED_WOLF)), 0.5f);
    }

    protected float getBob(IrradiatedWolf livingBase, float partialTicks) {
        return livingBase.getTailAngle();
    }

    public void render(IrradiatedWolf entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        if (entity.isWet()) {
            float f = entity.getWetShade(partialTicks);
            ((IrradiatedWolfModel)this.f_115290_).m_102419_(f, f, f);
        }
        super.m_7392_((Mob)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        if (entity.isWet()) {
            ((IrradiatedWolfModel)this.f_115290_).m_102419_(1.0f, 1.0f, 1.0f);
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(IrradiatedWolf entity) {
        if (entity.m_21824_()) {
            return WOLF_TAME_LOCATION;
        }
        return entity.m_21660_() ? WOLF_ANGRY_LOCATION : WOLF_LOCATION;
    }
}

