/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.contraptions.irradiated.cat;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.cat.IrradiatedCat;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class IrradiatedCatModel<T extends IrradiatedCat>
extends AgeableListModel<T> {
    private final ModelPart pustule3;
    private final ModelPart pustule2;
    private final ModelPart teeth2;
    private final ModelPart teeth;
    private final ModelPart pustule;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart tail1;
    private final ModelPart tail2;
    protected int state = 1;

    public IrradiatedCatModel(ModelPart root) {
        this.pustule = root.m_171324_("pustule");
        this.pustule3 = root.m_171324_("pustule3");
        this.pustule2 = root.m_171324_("pustule2");
        this.teeth2 = root.m_171324_("teeth2");
        this.teeth = root.m_171324_("teeth");
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.leftFrontLeg = root.m_171324_("left_front_leg");
        this.rightFrontLeg = root.m_171324_("right_front_leg");
        this.leftHindLeg = root.m_171324_("left_hind_leg");
        this.rightHindLeg = root.m_171324_("right_hind_leg");
        this.tail1 = root.m_171324_("tail1");
        this.tail2 = root.m_171324_("tail2");
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head, (Object)this.pustule);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.leftHindLeg, (Object)this.rightHindLeg, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg, (Object)this.tail1, (Object)this.tail2, (Object)this.pustule2, (Object)this.pustule3);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        if (this.state != 3) {
            this.body.f_104203_ = 1.5707964f;
            if (this.state == 2) {
                this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
                this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + 0.3f)) * limbSwingAmount;
                this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI + 0.3f)) * limbSwingAmount;
                this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
                this.tail2.f_104203_ = 1.7278761f + 0.31415927f * Mth.m_14089_((float)limbSwing) * limbSwingAmount;
            } else {
                this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
                this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
                this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
                this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
                this.tail2.f_104203_ = this.state == 1 ? 1.7278761f + 0.7853982f * Mth.m_14089_((float)limbSwing) * limbSwingAmount : 1.7278761f + 0.47123894f * Mth.m_14089_((float)limbSwing) * limbSwingAmount;
            }
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftFrontLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightFrontLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leftHindLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rightHindLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tail1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tail2.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.pustule.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.pustule3.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.pustule2.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.teeth2.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.teeth.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("pustule3", CubeListBuilder.m_171558_().m_171514_(46, 24).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)19.6f, (float)-4.5f, (float)1.8282f, (float)-1.4377f, (float)3.0129f));
        partdefinition.m_171599_("pustule2", CubeListBuilder.m_171558_().m_171514_(46, 24).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)14.6f, (float)4.5f, (float)1.442f, (float)0.0338f, (float)1.6973f));
        partdefinition.m_171599_("teeth2", CubeListBuilder.m_171558_().m_171514_(41, 23).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.8f, (float)17.1f, (float)-12.2f, (float)0.3927f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("teeth", CubeListBuilder.m_171558_().m_171514_(41, 23).m_171488_(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.8f, (float)17.1f, (float)-12.2f, (float)0.3927f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -2.0f, -3.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 24).m_171488_(-1.5f, -0.02f, -4.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 10).m_171488_(-2.0f, -3.0f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(6, 10).m_171488_(1.0f, -3.0f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-9.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171488_(-2.0f, 3.0f, -8.0f, 4.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)-10.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.1f, (float)14.1f, (float)-5.0f));
        partdefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.1f, (float)14.1f, (float)-5.0f));
        partdefinition.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(8, 13).m_171488_(-1.0f, 0.0f, 1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.1f, (float)18.0f, (float)5.0f));
        partdefinition.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(8, 13).m_171488_(-1.0f, 0.0f, 1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.1f, (float)18.0f, (float)5.0f));
        partdefinition.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)15.0f, (float)8.0f, (float)0.9f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(4, 15).m_171488_(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)14.0f));
        partdefinition.m_171599_("pustule", CubeListBuilder.m_171558_().m_171514_(46, 24).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.1f, (float)15.5f, (float)-10.0f, (float)-0.2597f, (float)0.0338f, (float)1.6973f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }
}

