/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear;

import com.mojang.logging.LogUtils;
import com.simibubi.create.CreateBuildInfo;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import net.nuclearteam.createnuclear.CNBlockEntityTypes;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.CNCreativeModeTabs;
import net.nuclearteam.createnuclear.CNEffects;
import net.nuclearteam.createnuclear.CNEntityType;
import net.nuclearteam.createnuclear.CNFluids;
import net.nuclearteam.createnuclear.CNItems;
import net.nuclearteam.createnuclear.CNMenus;
import net.nuclearteam.createnuclear.CNPackets;
import net.nuclearteam.createnuclear.CNPotions;
import net.nuclearteam.createnuclear.CNRecipeTypes;
import net.nuclearteam.createnuclear.CNTags;
import net.nuclearteam.createnuclear.CreateNuclearClient;
import net.nuclearteam.createnuclear.content.decoration.palettes.CNPaletteBlocks;
import net.nuclearteam.createnuclear.content.kinetics.fan.processing.CNFanProcessingTypes;
import net.nuclearteam.createnuclear.infrastructure.config.CNConfigs;
import net.nuclearteam.createnuclear.infrastructure.data.CreateNuclearDatagen;
import org.slf4j.Logger;

@Mod(value="createnuclear")
public class CreateNuclear {
    public static final String MOD_ID = "createnuclear";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"createnuclear").defaultCreativeTab((ResourceKey)null);

    public CreateNuclear() {
        CreateNuclear.onInitialize();
    }

    public static void onInitialize() {
        LOGGER.info("{} {} initializing! Commit hash: {}", new Object[]{MOD_ID, CreateBuildInfo.VERSION, CreateBuildInfo.GIT_COMMIT});
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        REGISTRATE.registerEventListeners(modEventBus);
        CNTags.init();
        CNBlocks.register();
        CNBlockEntityTypes.register();
        CNItems.register();
        CNPackets.registerPackets();
        CNMenus.register();
        CNFluids.register();
        CNEntityType.register();
        CNPaletteBlocks.register();
        CNConfigs.register(modLoadingContext);
        CNCreativeModeTabs.register(modEventBus);
        CNEffects.register(modEventBus);
        CNPotions.register(modEventBus);
        CNRecipeTypes.register(modEventBus);
        modEventBus.addListener(CreateNuclear::init);
        modEventBus.addListener(CreateNuclear::onRegister);
        modEventBus.addListener(EventPriority.LOWEST, CreateNuclearDatagen::gatherData);
        forgeEventBus.addListener(CNFluids::handleFluidEffect);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreateNuclearClient.onCtorClient(modEventBus, forgeEventBus));
    }

    public static void init(FMLCommonSetupEvent event) {
        CNFluids.registerFluidInteractions();
        event.enqueueWork(CNPotions::registerPotionsRecipes);
    }

    public static void onRegister(RegisterEvent event) {
        CNFanProcessingTypes.register();
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }
}

