/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear;

import java.util.Collections;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.nuclearteam.createnuclear.CreateNuclear;

public class CNTags {
    public static <T> TagKey<T> optionalTag(IForgeRegistry<T> registry, ResourceLocation id) {
        return registry.tags().createOptionalTagKey(id, Collections.emptySet());
    }

    public static <T> TagKey<T> forgeTag(IForgeRegistry<T> registry, String path) {
        return CNTags.optionalTag(registry, new ResourceLocation(NameSpace.FORGE.id, path));
    }

    public static TagKey<Block> forgeBlockTag(String path) {
        return CNTags.forgeTag(ForgeRegistries.BLOCKS, path);
    }

    public static TagKey<Item> forgeItemTag(String path) {
        return CNTags.forgeTag(ForgeRegistries.ITEMS, path);
    }

    public static TagKey<Fluid> forgeFluidTag(String path) {
        return CNTags.forgeTag(ForgeRegistries.FLUIDS, path);
    }

    public static void init() {
        CreateNuclear.LOGGER.info("Registering mod tags for createnuclear");
        CNBlockTags.init();
        CNItemTags.init();
        CNFluidTags.init();
        CNEntityTags.init();
        CNRecipeSerializerTags.init();
    }

    public static enum NameSpace {
        MOD("createnuclear", false, true),
        CREATE("create"),
        FORGE("forge"),
        MINECRAFT("minecraft");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }

    public static enum CNBlockTags {
        FAN_PROCESSING_CATALYSTS_ENRICHED(NameSpace.MOD, "fan_processing_catalysts/enriched"),
        ENRICHING_FIRE_BASE_BLOCKS,
        ALL_CAMPFIRES(NameSpace.MINECRAFT, "all/campfires"),
        URANIUM_ORES,
        LEAD_ORES;

        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;

        private CNBlockTags() {
            this(NameSpace.MOD);
        }

        private CNBlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CNBlockTags(NameSpace nameSpace, String path) {
            this(nameSpace, path, nameSpace.optionalDefault, nameSpace.alwaysDatagenDefault);
        }

        private CNBlockTags(NameSpace nameSpace, boolean optional, boolean alwaysDatagenDefault) {
            this(nameSpace, null, optional, alwaysDatagenDefault);
        }

        private CNBlockTags(NameSpace nameSpace, String path, boolean optional, boolean alwaysDatagenDefault) {
            ResourceLocation id = new ResourceLocation(nameSpace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CNTags.optionalTag(ForgeRegistries.BLOCKS, id) : BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagenDefault;
        }

        public boolean matches(Block block) {
            return block.m_204297_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.m_41720_()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).m_40614_());
        }

        public boolean matches(BlockState state) {
            return state.m_204336_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum CNItemTags {
        CLOTH,
        FUEL,
        COOLER,
        URANIUM_ORES,
        LEAD_ORES,
        ANTI_RADIATION_HELMET_DYE,
        ANTI_RADIATION_CHESTPLATE_DYE,
        ANTI_RADIATION_LEGGINGS_DYE,
        ANTI_RADIATION_BOOTS_DYE,
        ANTI_RADIATION_ARMOR,
        ALL_ANTI_RADIATION_ARMORS,
        ANTI_RADIATION_HELMET_FULL_DYE,
        ANTI_RADIATION_CHESTPLATE_FULL_DYE,
        ANTI_RADIATION_LEGGINGS_FULL_DYE;

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private CNItemTags() {
            this(NameSpace.MOD);
        }

        private CNItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CNItemTags(NameSpace nameSpace, String path) {
            this(nameSpace, path, nameSpace.optionalDefault, nameSpace.alwaysDatagenDefault);
        }

        private CNItemTags(NameSpace nameSpace, boolean optional, boolean alwaysDatagenDefault) {
            this(nameSpace, null, optional, alwaysDatagenDefault);
        }

        private CNItemTags(NameSpace nameSpace, String path, boolean optional, boolean alwaysDatagenDefault) {
            ResourceLocation id = new ResourceLocation(nameSpace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CNTags.optionalTag(ForgeRegistries.ITEMS, id) : ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagenDefault;
        }

        public boolean matches(Item item) {
            return item.m_204114_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum CNFluidTags {
        URANIUM;

        public final TagKey<Fluid> tag;
        public final boolean alwaysDatagen;

        private CNFluidTags() {
            this(NameSpace.MOD);
        }

        private CNFluidTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CNFluidTags(NameSpace nameSpace, String path) {
            this(nameSpace, path, nameSpace.optionalDefault, nameSpace.alwaysDatagenDefault);
        }

        private CNFluidTags(NameSpace nameSpace, boolean optional, boolean alwaysDatagenDefault) {
            this(nameSpace, null, optional, alwaysDatagenDefault);
        }

        private CNFluidTags(NameSpace nameSpace, String path, boolean optional, boolean alwaysDatagenDefault) {
            ResourceLocation id = new ResourceLocation(nameSpace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CNTags.optionalTag(ForgeRegistries.FLUIDS, id) : FluidTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagenDefault;
        }

        public boolean matches(Fluid fluid) {
            return fluid.m_205067_(this.tag);
        }

        public boolean matches(FluidState stack) {
            return stack.m_205070_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum CNEntityTags {
        IRRADIATED_IMMUNE;

        public final TagKey<EntityType<?>> tag;
        public final boolean alwaysDatagen;

        private CNEntityTags() {
            this(NameSpace.MOD);
        }

        private CNEntityTags(NameSpace nameSpace) {
            this(nameSpace, nameSpace.optionalDefault, nameSpace.alwaysDatagenDefault);
        }

        private CNEntityTags(NameSpace nameSpace, String path) {
            this(nameSpace, path, nameSpace.optionalDefault, nameSpace.alwaysDatagenDefault);
        }

        private CNEntityTags(NameSpace nameSpace, boolean optional, boolean alwaysDatagenDefault) {
            this(nameSpace, null, optional, alwaysDatagenDefault);
        }

        private CNEntityTags(NameSpace nameSpace, String path, boolean optional, boolean alwaysDatagenDefault) {
            ResourceLocation id = new ResourceLocation(nameSpace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CNTags.optionalTag(ForgeRegistries.ENTITY_TYPES, id) : TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagenDefault;
        }

        public boolean matches(EntityType<?> type) {
            return type.m_204039_(this.tag);
        }

        public boolean matches(Entity entity) {
            return this.matches(entity.m_6095_());
        }

        private static void init() {
        }
    }

    public static enum CNRecipeSerializerTags {
        AUTOMATION_IGNORE;

        public final TagKey<RecipeSerializer<?>> tag;
        public final boolean alwaysDatagen;

        private CNRecipeSerializerTags() {
            this(NameSpace.MOD);
        }

        private CNRecipeSerializerTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CNRecipeSerializerTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CNRecipeSerializerTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CNRecipeSerializerTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CNTags.optionalTag(ForgeRegistries.RECIPE_SERIALIZERS, id) : TagKey.m_203882_((ResourceKey)Registries.f_256764_, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(RecipeSerializer<?> recipeSerializer) {
            return ((Holder)ForgeRegistries.RECIPE_SERIALIZERS.getHolder(recipeSerializer).orElseThrow()).m_203656_(this.tag);
        }

        private static void init() {
        }
    }
}

