/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.TrapNozzle;

import com.adonis.createfisheryindustry.block.TrapNozzle.TrapNozzleBlock;
import com.adonis.createfisheryindustry.config.CreateFisheryCommonConfig;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.particle.FluidParticleData;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.kinetics.fan.NozzleBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrapNozzleBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    protected static final int INVENTORY_SLOTS = 9;
    protected static final double COLLECTION_RANGE = 1.5;
    protected static final double ENTITY_PROCESSING_RANGE = 1.5;
    protected static final int PROCESSING_TIME = 10;
    private static final double MAX_COLLISION_BOX_SIZE = 0.8;
    protected final ItemStackHandler inventory;
    protected int processingTicks = 0;
    private List<Entity> pushingEntities = new ArrayList<Entity>();
    private float range;
    private boolean pushing;
    private BlockPos fanPos;
    private final LazyOptional<IItemHandler> insertionHandler;
    private final LazyOptional<IItemHandler> extractionHandler;
    private final LazyOptional<IItemHandler> inventoryHandler;

    public TrapNozzleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = this.createInventory();
        this.setLazyTickRate(5);
        this.insertionHandler = LazyOptional.of(() -> new InsertionOnlyItemHandler((IItemHandler)this.inventory));
        this.extractionHandler = LazyOptional.of(() -> new ExtractionOnlyItemHandler((IItemHandler)this.inventory));
        this.inventoryHandler = LazyOptional.of(() -> this.inventory);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected ItemStackHandler createInventory() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                TrapNozzleBlockEntity.this.m_6596_();
                if (TrapNozzleBlockEntity.this.f_58857_ != null && !TrapNozzleBlockEntity.this.f_58857_.m_5776_()) {
                    TrapNozzleBlockEntity.this.f_58857_.m_7260_(TrapNozzleBlockEntity.this.f_58858_, TrapNozzleBlockEntity.this.m_58900_(), TrapNozzleBlockEntity.this.m_58900_(), 3);
                }
            }
        };
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TrapNozzleBlockEntity be) {
        be.tickNozzle();
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ++be.processingTicks;
            if (be.processingTicks >= 10) {
                be.processingTicks = 0;
                be.collectNearbyItems(serverLevel);
                be.tryProcessEntities(serverLevel);
                be.m_6596_();
                be.sendData();
                serverLevel.m_7260_(pos, state, state, 3);
            }
        }
    }

    private void tickNozzle() {
        int probability;
        float range = this.calcRange();
        if (this.range != range) {
            this.setRange(range);
        }
        Vec3 center = Vec3.m_82512_((Vec3i)this.f_58858_);
        if (this.f_58857_.f_46443_ && range != 0.0f && this.f_58857_.f_46441_.m_188503_(probability = Mth.m_14045_((int)(10 - (int)range), (int)1, (int)10)) == 0) {
            Vec3 start = VecHelper.offsetRandomly((Vec3)center, (RandomSource)this.f_58857_.f_46441_, (float)(this.pushing ? 1.0f : range / 2.0f));
            float speedFactor = this.pushing ? 0.05f : 1.0f;
            Vec3 motion = center.m_82546_(start).m_82541_().m_82490_((double)(Mth.m_14036_((float)(range * speedFactor), (float)0.0f, (float)0.5f) * (float)(this.pushing ? -1 : 1)));
            boolean inWater = (Boolean)this.m_58900_().m_61143_((Property)TrapNozzleBlock.WATERLOGGED);
            if (inWater) {
                this.f_58857_.m_7106_((ParticleOptions)new FluidParticleData(AllParticleTypes.FLUID_DRIP.get(), new FluidStack((Fluid)Fluids.f_76193_, 1000)), start.f_82479_, start.f_82480_, start.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
            } else {
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, start.f_82479_, start.f_82480_, start.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
            }
        }
        Iterator<Entity> iterator = this.pushingEntities.iterator();
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            Vec3 diff = entity.m_20182_().m_82546_(center);
            if (!(entity instanceof Player) && this.f_58857_.f_46443_) continue;
            double distance = diff.m_82553_();
            if (distance > (double)range || entity.m_6144_() || this.isPlayerCreativeFlying(entity)) {
                iterator.remove();
                continue;
            }
            if (!this.pushing && distance < 1.5) continue;
            float factor = entity instanceof ItemEntity ? 0.0078125f : 0.03125f;
            Vec3 pushVec = diff.m_82541_().m_82490_(((double)range - distance) * (double)(this.pushing ? 1 : -1));
            entity.m_20256_(entity.m_20184_().m_82549_(pushVec.m_82490_((double)factor)));
            entity.f_19789_ = 0.0f;
            entity.f_19864_ = true;
        }
        this.lazyTickNozzle();
    }

    private void lazyTickNozzle() {
        if (this.range == 0.0f) {
            return;
        }
        Vec3 center = Vec3.m_82512_((Vec3i)this.f_58858_);
        AABB bb = new AABB(center, center).m_82400_((double)(this.range / 2.0f));
        for (Entity entity : this.f_58857_.m_45976_(Entity.class, bb)) {
            Vec3 diff = entity.m_20182_().m_82546_(center);
            double distance = diff.m_82553_();
            if (distance > (double)this.range || entity.m_6144_() || this.isPlayerCreativeFlying(entity)) continue;
            boolean canSee = this.canSee(entity);
            if (!canSee) {
                this.pushingEntities.remove(entity);
                continue;
            }
            if (this.pushingEntities.contains(entity)) continue;
            this.pushingEntities.add(entity);
        }
        Iterator<Entity> iterator = this.pushingEntities.iterator();
        while (iterator.hasNext()) {
            Entity entity;
            entity = iterator.next();
            if (entity.m_6084_()) continue;
            iterator.remove();
        }
    }

    private float calcRange() {
        BlockEntity be;
        if (this.fanPos == null) {
            this.fanPos = this.f_58858_.m_121945_(((Direction)this.m_58900_().m_61143_((Property)NozzleBlock.f_52588_)).m_122424_());
        }
        if (!((be = this.f_58857_.m_7702_(this.fanPos)) instanceof IAirCurrentSource)) {
            return 0.0f;
        }
        IAirCurrentSource source = (IAirCurrentSource)be;
        if (source.getAirCurrent() == null || source.getSpeed() == 0.0f) {
            return 0.0f;
        }
        this.pushing = source.getAirFlowDirection() == source.getAirflowOriginSide();
        return source.getMaxDistance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPlayerCreativeFlying(Entity entity) {
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (!player.m_150110_().f_35935_) return false;
        return true;
    }

    private boolean canSee(Entity entity) {
        Vec3 start = entity.m_20182_();
        Vec3 end = Vec3.m_82512_((Vec3i)this.f_58858_);
        return this.f_58857_.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).m_82425_().equals((Object)this.f_58858_);
    }

    public void setRange(float range) {
        this.range = range;
        if (range == 0.0f) {
            this.pushingEntities.clear();
        }
        this.sendData();
    }

    protected void collectNearbyItems(ServerLevel level) {
        AABB boundingBox = new AABB(this.m_58899_()).m_82400_(1.5);
        List items = level.m_45976_(ItemEntity.class, boundingBox);
        for (ItemEntity itemEntity : items) {
            ItemStack stack;
            if (itemEntity == null || !itemEntity.m_6084_() || (stack = itemEntity.m_32055_()).m_41619_()) continue;
            ItemStack copy = stack.m_41777_();
            if (this.insertItem(copy)) {
                itemEntity.m_146870_();
                continue;
            }
            if (copy.m_41613_() >= stack.m_41613_()) continue;
            itemEntity.m_32045_(copy);
        }
    }

    protected void tryProcessEntities(ServerLevel level) {
        CreateFisheryCommonConfig.refreshCache();
        AABB boundingBox = new AABB(this.m_58899_()).m_82400_(1.5);
        List entities = level.m_45976_(Entity.class, boundingBox);
        for (Entity entity : entities) {
            ResourceLocation entityId;
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            if (!entity.m_6084_() || CreateFisheryCommonConfig.isEntityBlacklisted(entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()))) continue;
            if (CreateFisheryCommonConfig.isEntityWhitelisted(entityId)) {
                this.processEntityDrops(level, mob);
                continue;
            }
            AABB collisionBox = entity.m_20191_();
            double width = collisionBox.m_82362_();
            double height = collisionBox.m_82376_();
            double depth = collisionBox.m_82385_();
            if (!(width <= 0.8) || !(height <= 0.8) || !(depth <= 0.8)) continue;
            this.processEntityDrops(level, mob);
        }
    }

    private void processEntityDrops(ServerLevel level, Mob mob) {
        Player nearestPlayer;
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        ResourceLocation lootTableKey = mob.m_5743_();
        if (lootTableKey == null) {
            return;
        }
        LootParams.Builder paramsBuilder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81455_, (Object)mob).m_287286_(LootContextParams.f_81460_, (Object)mob.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)level.m_269111_().m_269264_());
        List players = level.m_7654_().m_6846_().m_11314_();
        if (!players.isEmpty() && (nearestPlayer = level.m_45930_((Entity)mob, -1.0)) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)nearestPlayer;
            paramsBuilder.m_287286_(LootContextParams.f_81456_, (Object)serverPlayer);
        }
        LootParams params = paramsBuilder.m_287235_(LootContextParamSets.f_81415_);
        LootTable lootTable = level.m_7654_().m_278653_().m_278676_(lootTableKey);
        ObjectArrayList loots = lootTable.m_287195_(params);
        for (ItemStack stack : loots) {
            ItemStack remainder = stack.m_41777_();
            for (int i = 0; i < this.inventory.getSlots() && !(remainder = this.inventory.insertItem(i, remainder, false)).m_41619_(); ++i) {
            }
            if (remainder.m_41619_()) continue;
            ItemEntity itemEntity = new ItemEntity((Level)level, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), remainder);
            level.m_7967_((Entity)itemEntity);
        }
        mob.m_142467_(Entity.RemovalReason.KILLED);
        boolean inWater = (Boolean)this.m_58900_().m_61143_((Property)TrapNozzleBlock.WATERLOGGED);
        this.spawnParticles(level, mob.m_20185_(), mob.m_20186_() + 0.5, mob.m_20189_(), inWater);
        this.addExperienceNugget(level, mob.m_20185_(), mob.m_20186_() + 0.5, mob.m_20189_());
    }

    private void spawnParticles(ServerLevel level, double x, double y, double z, boolean inWater) {
        SimpleParticleType particleType = inWater ? ParticleTypes.f_123795_ : ParticleTypes.f_123796_;
        level.m_8767_((ParticleOptions)particleType, x, y, z, 30, 0.5, 0.5, 0.5, 0.1);
        level.m_5594_(null, new BlockPos((int)x, (int)y, (int)z), SoundEvents.f_11782_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void addExperienceNugget(ServerLevel level, double x, double y, double z) {
        Item expNuggetItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("create", "experience_nugget"));
        if (expNuggetItem != null && expNuggetItem != ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "air"))) {
            ItemStack expNugget = new ItemStack((ItemLike)expNuggetItem, 1);
            ItemStack remainder = expNugget.m_41777_();
            for (int i = 0; i < this.inventory.getSlots() && !(remainder = this.inventory.insertItem(i, remainder, false)).m_41619_(); ++i) {
            }
            if (!remainder.m_41619_()) {
                ItemEntity itemEntity = new ItemEntity((Level)level, x, y, z, remainder);
                level.m_7967_((Entity)itemEntity);
            }
        } else {
            level.m_7967_((Entity)new ExperienceOrb((Level)level, x, y, z, 1));
        }
    }

    public boolean insertItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        ItemStack remainder = stack.m_41777_();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!(remainder = this.inventory.insertItem(i, remainder, false)).m_41619_()) continue;
            return true;
        }
        return stack.m_41613_() != remainder.m_41613_();
    }

    public void dropInventory() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 pos = Vec3.m_82512_((Vec3i)this.f_58858_);
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemEntity itemEntity = new ItemEntity(this.f_58857_, pos.f_82479_, pos.f_82480_, pos.f_82481_, stack);
                serverLevel.m_7967_((Entity)itemEntity);
                this.inventory.setStackInSlot(i, ItemStack.f_41583_);
            }
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("ProcessingTicks", this.processingTicks);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.processingTicks = compound.m_128451_("ProcessingTicks");
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"gui.goggles.trap_nozzle_contents", (Object[])new Object[0]).forGoggles(tooltip);
        ItemStackHandler inv = this.getInventory();
        boolean isEmpty = true;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            isEmpty = false;
            CreateLang.text((String)"").add(Component.m_237115_((String)stack.m_41778_()).m_130940_(ChatFormatting.GRAY)).add(CreateLang.text((String)(" x" + stack.m_41613_())).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
        }
        if (isEmpty) {
            CreateLang.translate((String)"gui.goggles.inventory.empty", (Object[])new Object[0]).forGoggles(tooltip, 1);
        }
        return true;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.insertionHandler.invalidate();
        this.extractionHandler.invalidate();
        this.inventoryHandler.invalidate();
    }

    private static class ExtractionOnlyItemHandler
    implements IItemHandler {
        private final IItemHandler wrapped;

        public ExtractionOnlyItemHandler(IItemHandler wrapped) {
            this.wrapped = wrapped;
        }

        public int getSlots() {
            return this.wrapped.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.wrapped.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.wrapped.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.wrapped.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.wrapped.isItemValid(slot, stack);
        }
    }

    private static class InsertionOnlyItemHandler
    implements IItemHandler {
        private final IItemHandler wrapped;

        public InsertionOnlyItemHandler(IItemHandler wrapped) {
            this.wrapped = wrapped;
        }

        public int getSlots() {
            return this.wrapped.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.wrapped.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return this.wrapped.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.wrapped.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.wrapped.isItemValid(slot, stack);
        }
    }
}

